/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.internal.equinox.console.cmdprov.logwriter;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.service.LogReaderAggregatorService;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.MessageFormatter;
import org.eclipse.soda.sat.internal.equinox.console.cmdprov.logwriter.nls.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class LogWriter {
    private static final String INVALID_LOG_LEVEL_KEY = "LogWriter.InvalidLogLevel";
    private static final String STARTED_LOGGING_EVENTS_KEY = "LogWriter.StartedLoggingEvents";
    private static final String STOPPED_LOGGING_EVENTS_KEY = "LogWriter.StoppedLoggingEvents";
    private static final String INVALID_LOG_LEVEL = Messages.getString("LogWriter.InvalidLogLevel");
    private static final String STARTED_LOGGING_EVENTS = Messages.getString("LogWriter.StartedLoggingEvents");
    private static final String STOPPED_LOGGING_EVENTS = Messages.getString("LogWriter.StoppedLoggingEvents");
    private static final String ERROR_LOG_LEVEL = "ERROR";
    private static final String WARNING_LOG_LEVEL = "WARNING";
    private static final String INFO_LOG_LEVEL = "INFO";
    private static final String DEBUG_LOG_LEVEL = "DEBUG";
    private static final char DATE_DELIMETER = '-';
    private static final char TIME_DELIMETER = ':';
    private static final char ZERO_PADDING = '0';
    private static final Calendar CALENDAR = Calendar.getInstance();
    private LogReaderAggregatorService aggregator;
    private LogListener logListener;
    private volatile int levelValue;
    private boolean started;
    private ICharBuffer buffer;

    private static Calendar getCalendar(long time) {
        Date date = new Date(time);
        CALENDAR.setTime(date);
        return CALENDAR;
    }

    public LogWriter(LogReaderAggregatorService aggregator) {
        this.setAggregator(aggregator);
        this.setLevelValue(4);
        this.setStarted(false);
        this.setBuffer(this.createBuffer());
    }

    private ICharBuffer createBuffer() {
        FactoryUtility utility = FactoryUtility.getInstance();
        ICharBuffer buffer = utility.createCharBuffer(250);
        return buffer;
    }

    private LogListener createLogListener() {
        return new LogListener(){

            public void logged(LogEntry entry) {
                LogWriter.this.handleLogEntry(entry);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatLogMessage(int level, long time, String message, ServiceReference reference) {
        String value;
        ICharBuffer buffer;
        ICharBuffer iCharBuffer = buffer = this.getBuffer();
        synchronized (iCharBuffer) {
            buffer.setLength(0);
            this.printLevelOn(buffer, level);
            buffer.append(' ');
            this.printDateAndTimeOn(buffer, time);
            buffer.append(' ');
            buffer.append(message);
            if (reference != null) {
                buffer.append(',');
                buffer.append(' ');
                this.printServiceReferenceOn(buffer, reference);
            }
            value = buffer.toString();
        }
        return value;
    }

    private LogReaderAggregatorService getAggregator() {
        return this.aggregator;
    }

    private ICharBuffer getBuffer() {
        return this.buffer;
    }

    public String getLevel() {
        int logLevel = this.getLevelValue();
        String value = this.getLevel(logLevel);
        return value;
    }

    private String getLevel(int level) {
        String text;
        switch (level) {
            case 1: {
                text = ERROR_LOG_LEVEL;
                break;
            }
            case 2: {
                text = WARNING_LOG_LEVEL;
                break;
            }
            case 3: {
                text = INFO_LOG_LEVEL;
                break;
            }
            case 4: {
                text = DEBUG_LOG_LEVEL;
                break;
            }
            default: {
                text = "<unknown>";
            }
        }
        return text;
    }

    private int getLevelValue() {
        return this.levelValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogListener getLogListener() {
        LogWriter logWriter = this;
        synchronized (logWriter) {
            if (this.logListener == null) {
                LogListener listener = this.createLogListener();
                this.setLogListener(listener);
            }
            return this.logListener;
        }
    }

    private List getServiceNames(ServiceReference reference) {
        String[] names = (String[])reference.getProperty("objectClass");
        ArrayList<String> list = new ArrayList<String>(names.length);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            list.add(name);
            ++i;
        }
        return list;
    }

    private void handleLogEntry(LogEntry entry) {
        int entryLevel = entry.getLevel();
        int level = this.getLevelValue();
        if (level <= entryLevel) {
            return;
        }
        long time = entry.getTime();
        ServiceReference reference = entry.getServiceReference();
        String message = entry.getMessage();
        this.logMessage(level, time, message, reference);
        Throwable throwable = entry.getException();
        if (throwable == null) {
            return;
        }
        this.logException(throwable);
    }

    private boolean isStarted() {
        return this.started;
    }

    private void logException(Throwable throwable) {
        PrintStream printStream = new PrintStream(System.err);
        throwable.printStackTrace(printStream);
        printStream.flush();
    }

    private void logInvalidLogLevel(String argument) {
        String message = MessageFormatter.format((String)INVALID_LOG_LEVEL, (Object)argument);
        FactoryUtility utility = FactoryUtility.getInstance();
        ICharBuffer buffer = utility.createCharBuffer(75);
        buffer.append(message);
        buffer.append(argument);
        buffer.append('\n');
        buffer.append('\t');
        buffer.append("setll <error | warning | info | debug> - {0}");
        PrintStream stream = System.err;
        stream.println(buffer);
    }

    private void logMessage(int level, long time, String message, ServiceReference reference) {
        String value = this.formatLogMessage(level, time, message, reference);
        System.out.println(value);
    }

    private void printDateAndTimeOn(ICharBuffer buffer, long time) {
        Calendar calendar = LogWriter.getCalendar(time);
        this.printDateOn(buffer, calendar);
        buffer.append(' ');
        this.printTimeOn(buffer, calendar);
    }

    private void printDateOn(ICharBuffer buffer, Calendar calendar) {
        int year = calendar.get(1);
        buffer.append(year);
        buffer.append('-');
        int month = calendar.get(2) + 1;
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        buffer.append('-');
        int day = calendar.get(5);
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
    }

    private void printLevelOn(ICharBuffer buffer, int level) {
        String value = this.getLevel(level);
        buffer.append('[');
        buffer.append(value);
        buffer.append(']');
    }

    private void printServiceReferenceOn(ICharBuffer buffer, ServiceReference reference) {
        List names;
        boolean empty;
        Bundle bundle = reference.getBundle();
        if (bundle != null) {
            String symbolicName = bundle.getSymbolicName();
            long id = bundle.getBundleId();
            buffer.append("bundle");
            buffer.append('=');
            buffer.append(symbolicName);
            buffer.append(' ');
            buffer.append('[');
            buffer.append(id);
            buffer.append(']');
            buffer.append(',');
            buffer.append(' ');
        }
        if (empty = (names = this.getServiceNames(reference)).isEmpty()) {
            return;
        }
        buffer.append("services");
        buffer.append('=');
        buffer.append('[');
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            Object name = iterator.next();
            buffer.append(name);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
            buffer.append(' ');
        }
        buffer.append(']');
    }

    private void printTimeOn(ICharBuffer buffer, Calendar calendar) {
        int hour = calendar.get(11);
        if (hour < 10) {
            buffer.append('0');
        }
        buffer.append(hour);
        buffer.append(':');
        int minute = calendar.get(12);
        if (minute < 10) {
            buffer.append('0');
        }
        buffer.append(minute);
        buffer.append(':');
        int second = calendar.get(13);
        if (second < 10) {
            buffer.append('0');
        }
        buffer.append(second);
        buffer.append('.');
        int millisecond = calendar.get(14);
        if (millisecond < 100) {
            buffer.append('0');
        }
        if (millisecond < 10) {
            buffer.append('0');
        }
        buffer.append(millisecond);
    }

    private void setAggregator(LogReaderAggregatorService aggregator) {
        Assertion.checkArgumentIsNotNull((Object)aggregator, (String)"aggregator");
        this.aggregator = aggregator;
    }

    private void setBuffer(ICharBuffer buffer) {
        this.buffer = buffer;
    }

    public boolean setLevel(String level) {
        Assertion.checkArgumentIsNotNull((Object)level, (String)"level");
        boolean set = false;
        try {
            int value = this.toLevelValue(level);
            this.setLevelValue(value);
            set = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.logInvalidLogLevel(level);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logInvalidLogLevel(level);
        }
        return set;
    }

    private void setLevelValue(int levelValue) {
        this.levelValue = levelValue;
    }

    private void setLogListener(LogListener logListener) {
        this.logListener = logListener;
    }

    private void setStarted(boolean started) {
        this.started = started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LogWriter logWriter = this;
        synchronized (logWriter) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setStarted(true);
            this.startListening();
        }
    }

    private void startListening() {
        LogReaderAggregatorService service = this.getAggregator();
        LogListener listener = this.getLogListener();
        service.addLogListener(listener);
        System.out.println(STARTED_LOGGING_EVENTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LogWriter logWriter = this;
        synchronized (logWriter) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.setStarted(false);
            this.stopListening();
        }
    }

    private void stopListening() {
        LogReaderAggregatorService service = this.getAggregator();
        LogListener listener = this.getLogListener();
        service.removeLogListener(listener);
        System.out.println(STOPPED_LOGGING_EVENTS);
    }

    private int toLevelValue(String value) throws IllegalArgumentException {
        if (ERROR_LOG_LEVEL.equalsIgnoreCase(value)) {
            return 1;
        }
        if (WARNING_LOG_LEVEL.equalsIgnoreCase(value)) {
            return 2;
        }
        if (INFO_LOG_LEVEL.equalsIgnoreCase(value)) {
            return 3;
        }
        if (DEBUG_LOG_LEVEL.equalsIgnoreCase(value)) {
            return 4;
        }
        throw new IllegalArgumentException("invalid log level: " + value);
    }
}

