/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.transport.service.ChannelStateService;

public class ChannelSchedule {
    private ChannelStateService first;
    private ChannelStateService last;

    public synchronized ChannelStateService getFirst() {
        return this.first;
    }

    public synchronized void remove(ChannelStateService element) {
        ChannelStateService next = element.getNext();
        ChannelStateService previous = element.getPrevious();
        if (this.last == element) {
            this.last = previous;
        } else if (next != null) {
            next.setPrevious(previous);
        }
        if (this.first == element) {
            this.first = next;
        } else if (previous != null) {
            previous.setNext(next);
        }
        element.setNext(null);
        element.setPrevious(null);
    }

    public synchronized void removeAll() {
        this.first = null;
        this.last = null;
    }

    public synchronized void scheduleTimeout(ChannelStateService element, Object timestamp, long timeout) {
        element.setTimeout((Long)timestamp + timeout);
        this.remove(element);
        if (this.last == null) {
            element.setNext(null);
            element.setPrevious(null);
            this.first = element;
            this.last = element;
        } else {
            ChannelStateService current = this.last;
            while (current != null && current.getTimeout() > element.getTimeout()) {
                current = current.getPrevious();
            }
            if (current == null) {
                element.setNext(this.first);
                element.setPrevious(null);
                this.first.setPrevious(element);
                this.first = element;
            } else {
                ChannelStateService next = current.getNext();
                element.setNext(next);
                current.setNext(element);
                element.setPrevious(current);
                if (current == this.last) {
                    this.last = element;
                } else {
                    next.setPrevious(element);
                }
            }
        }
    }
}

