/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport.testcase;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public abstract class TransportTestcase
extends TestCase
implements TransportListener {
    protected TransportService transport;
    protected final Object stateWait = new Object();

    protected TransportTestcase() {
    }

    protected TransportTestcase(String name) {
        super(name);
    }

    public abstract TransportService createTransport();

    public void errorOccurred(Object source, Object timestamp, Object data) {
    }

    public TransportService getTransport() {
        return this.transport;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
    }

    public void setTransport(TransportService transport) {
        this.transport = transport;
    }

    protected void setUp() throws Exception {
        this.setTransport(this.createTransport());
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransport() throws Exception {
        this.transport.addTransportListener((TransportListener)this);
        this.transport.start();
        while (this.transport.getState() != 5) {
            Object object = this.stateWait;
            synchronized (object) {
                this.stateWait.wait(500L);
            }
        }
    }

    public void test_Fields() {
        TransportService transportService = this.getTransport();
        try {
            Field field = transportService.getClass().getField("CLASS_NAME");
            Object value = field.get(null);
            TransportTestcase.assertEquals((Object)transportService.getClass().getName(), (Object)value);
        }
        catch (Exception e) {
            TransportTestcase.fail((String)String.valueOf(e));
        }
    }

    public void test_Interfaces() {
        TransportService transportService = this.getTransport();
        Class<?>[] interfaces = transportService.getClass().getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            try {
                Class<?> interfaceClass = interfaces[i];
                Field field = interfaceClass.getField("SERVICE_NAME");
                Object value = field.get(null);
                TransportTestcase.assertEquals((Object)interfaceClass.getName(), (Object)value);
            }
            catch (Exception e) {
                TransportTestcase.fail((String)String.valueOf(e));
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        Object object = this.stateWait;
        synchronized (object) {
            this.stateWait.notifyAll();
        }
    }
}

