/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.parser;

import org.eclipse.soda.dk.testmanager.parser.BooleanConverter;
import org.eclipse.soda.dk.testmanager.parser.ByteConverter;
import org.eclipse.soda.dk.testmanager.parser.CharacterConverter;
import org.eclipse.soda.dk.testmanager.parser.DoubleConverter;
import org.eclipse.soda.dk.testmanager.parser.FloatConverter;
import org.eclipse.soda.dk.testmanager.parser.IntegerConverter;
import org.eclipse.soda.dk.testmanager.parser.LongConverter;
import org.eclipse.soda.dk.testmanager.parser.PropertyConverter;
import org.eclipse.soda.dk.testmanager.parser.ShortConverter;
import org.eclipse.soda.dk.testmanager.parser.StringConverter;

public class PropertyConverterFactory {
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String BYTE_TYPE = "byte";
    public static final String CHARACTER_TYPE = "character";
    public static final String DOUBLE_TYPE = "double";
    public static final String FLOAT_TYPE = "float";
    public static final String INTEGER_TYPE = "integer";
    public static final String LONG_TYPE = "long";
    public static final String SHORT_TYPE = "short";
    public static final String STRING_TYPE = "string";
    private static final BooleanConverter BOOLEAN_CONVERTER = new BooleanConverter();
    private static final ByteConverter BYTE_CONVERTER = new ByteConverter();
    private static final CharacterConverter CHARACTER_CONVERTER = new CharacterConverter();
    private static final DoubleConverter DOUBLE_CONVERTER = new DoubleConverter();
    private static final FloatConverter FLOAT_CONVERTER = new FloatConverter();
    private static final IntegerConverter INTEGER_CONVERTER = new IntegerConverter();
    private static final LongConverter LONG_CONVERTER = new LongConverter();
    private static final ShortConverter SHORT_CONVERTER = new ShortConverter();
    private static final StringConverter STRING_CONVERTER = new StringConverter();

    public static PropertyConverter create(String type) {
        if (type == null || type.length() == 0 || type.toLowerCase().equals(STRING_TYPE)) {
            return STRING_CONVERTER;
        }
        if (type.toLowerCase().equals(BOOLEAN_TYPE)) {
            return BOOLEAN_CONVERTER;
        }
        if (type.toLowerCase().equals(BYTE_TYPE)) {
            return BYTE_CONVERTER;
        }
        if (type.toLowerCase().equals(CHARACTER_TYPE)) {
            return CHARACTER_CONVERTER;
        }
        if (type.toLowerCase().equals(DOUBLE_TYPE)) {
            return DOUBLE_CONVERTER;
        }
        if (type.toLowerCase().equals(FLOAT_TYPE)) {
            return FLOAT_CONVERTER;
        }
        if (type.toLowerCase().equals(INTEGER_TYPE)) {
            return INTEGER_CONVERTER;
        }
        if (type.toLowerCase().equals(LONG_TYPE)) {
            return LONG_CONVERTER;
        }
        if (type.toLowerCase().equals(SHORT_TYPE)) {
            return SHORT_CONVERTER;
        }
        return STRING_CONVERTER;
    }
}

