/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.AbstractAction;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.action.ConfigurationTemplate;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.eclipse.soda.dk.testmanager.service.TestStatisticsService;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.InvalidSyntaxException;

public abstract class ConfigurationAction
extends AbstractAction
implements Action {
    private List configurationTemplates = new ArrayList();

    protected ConfigurationAction(String id) {
        super(id);
    }

    public void addConfiguration(String id, String controllerId, String pid, String factoryPid, String bundleLocation, String filter, Dictionary properties) {
        ConfigurationTemplate template = new ConfigurationTemplate(id, controllerId, pid, factoryPid, bundleLocation, filter, properties);
        this.configurationTemplates.add(template);
    }

    public void addCounts(TestStatisticsService testStatistics) {
        testStatistics.incrementCount("CONFIGURATION_COUNT", this.getConfigurationTemplates().size());
    }

    public void execute(TestScriptService testScript) {
        TestStatisticsService testStatistics = testScript.getTestStatistics();
        Iterator iterator = this.getConfigurationTemplates().iterator();
        while (iterator.hasNext()) {
            ConfigurationTemplate template = (ConfigurationTemplate)iterator.next();
            try {
                this.execute(testScript, template);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                String filter = template.getFilter();
                Object[] parms = new Object[]{filter};
                LogUtility.logError((String)Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7162)), (Object[])parms));
                testScript.getScriptListener().scriptActionError(this.getId(), this.getDescription(), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7162)), (Object[])parms));
                testStatistics.incrementCount("CONFIGURATION_ERROR_COUNT", 1);
            }
            catch (IOException exception) {
                LogUtility.logError((Object)this, (String)TestManager.DefaultResourceBundle.getString(Integer.toString(7163)), (Throwable)exception);
                testScript.getScriptListener().scriptActionError(this.getId(), this.getDescription(), TestManager.DefaultResourceBundle.getString(Integer.toString(7163)));
                testStatistics.incrementCount("CONFIGURATION_ERROR_COUNT", 1);
            }
        }
    }

    protected abstract void execute(TestScriptService var1, ConfigurationTemplate var2) throws InvalidSyntaxException, IOException;

    protected List getConfigurationTemplates() {
        return this.configurationTemplates;
    }

    public String getDescription() {
        Object[] parms = new Object[]{this.getName()};
        return Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7172)), (Object[])parms);
    }

    protected abstract String getName();

    protected TestSessionService getTestSession(TestScriptService testScript, String controllerId) throws IOException {
        TestSessionService testSession = testScript.getDistributedTestSession().getTestSession(controllerId);
        if (testSession == null) {
            String detail = controllerId == null ? TestManager.DefaultResourceBundle.getString(Integer.toString(7198)) : Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7199)), (Object)controllerId);
            this.handleScriptActionError(testScript, detail);
        }
        return testSession;
    }
}

