/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.comm;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.ParallelPort;
import javax.comm.ParallelPortEvent;
import javax.comm.ParallelPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import org.eclipse.soda.dk.comm.DeviceListEntry;
import org.eclipse.soda.dk.comm.NSCommDriver;
import org.eclipse.soda.dk.comm.NSDeviceInputStream;
import org.eclipse.soda.dk.comm.NSDeviceOutputStream;
import org.eclipse.soda.dk.comm.ParallelErrorEventThread;

public class NSParallelPort
extends ParallelPort {
    public static final int LPT_MODE_ANY = 0;
    public static final int LPT_MODE_SPP = 1;
    public static final int LPT_MODE_PS2 = 2;
    public static final int LPT_MODE_EPP = 3;
    public static final int LPT_MODE_ECP = 4;
    public static final int LPT_MODE_NIBBLE = 5;
    private int mode = 1;
    int fd = -1;
    FileDescriptor FD = null;
    private NSDeviceInputStream ins = null;
    private NSDeviceOutputStream outs = null;
    int rcvThreshold = -1;
    int rcvTimeout = -1;
    boolean rcvFraming = false;
    int rcvFramingByte;
    boolean rcvFramingByteReceived;
    int insBufferSize = 0;
    int insBufferCount = 0;
    boolean outsSuspended = false;
    int outsBufferSize = 0;
    int outsBufferCount = 0;
    private ParallelPortEventListener listener = null;
    private boolean notifyOnErrorFlag = false;
    boolean notifyOnBufferFlag = false;
    private ParallelErrorEventThread errorThread = null;
    private DeviceListEntry dle = null;
    private NSCommDriver cd = null;

    NSParallelPort(String portName, NSCommDriver driver) throws IOException {
        this.name = portName;
        this.cd = driver;
        DeviceListEntry cur = this.cd.getFirstDLE();
        while (cur != null) {
            if (cur.logicalName.equals(portName)) {
                if (this.fd == -1 || !cur.opened) {
                    this.fd = this.openDeviceNC(cur.physicalName, cur.semID);
                    if (this.fd == -1) {
                        throw new IOException();
                    }
                    this.dle = cur;
                    this.dle.opened = true;
                    break;
                }
                throw new IOException();
            }
            cur = this.cd.getNextDLE(cur);
        }
    }

    public synchronized void addEventListener(ParallelPortEventListener lst) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = lst;
        if (this.notifyOnErrorFlag && this.errorThread == null) {
            this.errorThread = new ParallelErrorEventThread(this.fd, this);
            this.errorThread.start();
        }
    }

    public void close() {
        if (this.fd == -1) {
            return;
        }
        if (this.errorThread != null) {
            this.errorThread.setStopThreadFlag(1);
            this.errorThread = null;
            this.notifyOnErrorFlag = false;
        }
        if (this.outs != null) {
            try {
                this.outs.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.outs = null;
        }
        if (this.ins != null) {
            this.ins = null;
        }
        this.closeDeviceNC(this.fd, this.dle.semID);
        this.fd = -1;
        this.dle.opened = false;
        super.close();
    }

    private native int closeDeviceNC(int var1, int var2);

    public void disableReceiveFraming() {
        this.rcvFraming = false;
    }

    public void disableReceiveThreshold() {
        this.rcvThreshold = -1;
    }

    public void disableReceiveTimeout() {
        this.rcvTimeout = -1;
    }

    public void enableReceiveFraming(int rcvFramingByte) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void enableReceiveThreshold(int thresh) throws UnsupportedCommOperationException {
        if (thresh > 0) {
            this.rcvThreshold = thresh;
        }
    }

    public void enableReceiveTimeout(int rt) throws UnsupportedCommOperationException {
        if (rt > 0) {
            this.rcvTimeout = rt;
        } else if (rt == 0) {
            this.rcvTimeout = -1;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public int getInputBufferSize() {
        return this.insBufferSize;
    }

    public InputStream getInputStream() throws IOException {
        if (this.ins == null) {
            this.ins = new NSDeviceInputStream(this, this.dle.portType);
            if (this.ins == null) {
                throw new IOException();
            }
            this.ins.fd = this.fd;
        }
        return this.ins;
    }

    public int getMode() {
        return this.mode;
    }

    public int getOutputBufferFree() {
        return this.outsBufferSize > this.outsBufferCount ? this.outsBufferSize - this.outsBufferCount : 0;
    }

    public int getOutputBufferSize() {
        return this.outsBufferSize;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outs == null) {
            this.outs = new NSDeviceOutputStream(this, this.dle.portType);
            if (this.outs == null) {
                throw new IOException();
            }
            this.outs.fd = this.fd;
        }
        return this.outs;
    }

    public int getReceiveFramingByte() {
        return this.rcvFramingByte;
    }

    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    public boolean isPaperOut() {
        return this.isPaperOutNC(this.fd);
    }

    private native boolean isPaperOutNC(int var1);

    public boolean isPrinterBusy() {
        return this.isPrinterBusyNC(this.fd);
    }

    private native boolean isPrinterBusyNC(int var1);

    public boolean isPrinterError() {
        return this.isPrinterErrorNC(this.fd);
    }

    private native boolean isPrinterErrorNC(int var1);

    public boolean isPrinterSelected() {
        return this.isPrinterSelectedNC(this.fd);
    }

    private native boolean isPrinterSelectedNC(int var1);

    public boolean isPrinterTimedOut() {
        return this.isPrinterTimedOutNC(this.fd);
    }

    private native boolean isPrinterTimedOutNC(int var1);

    public boolean isReceiveFramingEnabled() {
        return this.rcvFraming;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.rcvThreshold != -1;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcvTimeout != -1;
    }

    public synchronized void notifyOnBuffer(boolean notify) {
        this.notifyOnBufferFlag = notify;
    }

    public synchronized void notifyOnError(boolean notify) {
        if (notify) {
            if (!this.notifyOnErrorFlag) {
                if (this.errorThread == null && this.listener != null) {
                    this.errorThread = new ParallelErrorEventThread(this.fd, this);
                    this.errorThread.start();
                }
                this.notifyOnErrorFlag = true;
            }
        } else if (this.notifyOnErrorFlag) {
            if (this.errorThread != null) {
                this.errorThread.setStopThreadFlag(1);
            }
            this.notifyOnErrorFlag = false;
            this.errorThread = null;
        }
    }

    private native int openDeviceNC(String var1, int var2);

    public synchronized void removeEventListener() {
        if (this.listener != null) {
            if (this.errorThread != null) {
                this.errorThread.setStopThreadFlag(1);
            }
            this.errorThread = null;
            this.listener = null;
        }
    }

    synchronized void reportParallelEvent(int eventType, boolean oldvalue, boolean newvalue) {
        if (this.listener != null) {
            ParallelPortEvent pe = new ParallelPortEvent(this, eventType, oldvalue, newvalue);
            this.listener.parallelEvent(pe);
        }
    }

    public void restart() {
        this.outsSuspended = false;
    }

    public void setInputBufferSize(int size) {
    }

    public int setMode(int md) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void setOutputBufferSize(int size) {
        if (size >= 0) {
            this.outsBufferSize = size;
        }
    }

    public void suspend() {
        this.outsSuspended = true;
    }
}

