/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.platform.validation.test.agent;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.platform.validation.test.agent.PlatformValidationTestAgent;
import org.eclipse.soda.dk.platform.validation.test.checker.ClassLibValidator;
import org.eclipse.soda.dk.platform.validation.test.checker.LogService;
import org.eclipse.soda.dk.testagent.TestAgent;
import org.eclipse.soda.dk.testagent.framework.ConfiguredTestCase;

public class ClassLibraryValidationTestCase
extends ConfiguredTestCase
implements LogService {
    public static final String DEFAULT_MIN_JAVA_VERSION = "1.3";
    public static final String DEFAULT_REQUIRED_LIBRARIES = "ee.minimum11";
    private ClassLibValidator validator;
    static /* synthetic */ Class class$0;

    public ClassLibraryValidationTestCase(String name) {
        super(name);
    }

    public static boolean checkVersion(String actualVersion, String minimumVersion) {
        StringTokenizer actualTokenizer = new StringTokenizer(actualVersion, ".");
        StringTokenizer minimumTokenizer = new StringTokenizer(minimumVersion, ".");
        while (minimumTokenizer.hasMoreTokens()) {
            int actual;
            int minimum = Integer.parseInt(minimumTokenizer.nextToken());
            int n = actual = actualTokenizer.hasMoreTokens() ? Integer.parseInt(actualTokenizer.nextToken()) : 0;
            if (actual < minimum) {
                return false;
            }
            if (actual > minimum) break;
        }
        return true;
    }

    public static void main(String[] arguments) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.platform.validation.test.agent.ClassLibraryValidationTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    private void loadClassLib(String libName) throws IOException, ClassNotFoundException {
        this.getContext().log(3, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7400)), (Object)libName));
        String resourceName = "cinfo/" + libName + ".cinfo";
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        ClassLibraryValidationTestCase.assertNotNull((String)Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7401)), (Object)libName), (Object)in);
        this.validator.loadClassLib(in);
    }

    public void log(int severity, String message) {
        this.getContext().log(severity, message);
    }

    public void log(int severity, String message, Throwable exception) {
        this.getContext().log(severity, message, exception);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new ClassLibValidator(this);
    }

    public void test000_ValidateJavaVersion() {
        String minimumVersion = this.getString("min.java.version", DEFAULT_MIN_JAVA_VERSION);
        String actualVersion = System.getProperty("java.version");
        if (!ClassLibraryValidationTestCase.checkVersion(actualVersion, minimumVersion)) {
            Object[] parms = new Object[]{actualVersion, minimumVersion};
            String errorMsg = Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7402)), (Object[])parms);
            ClassLibraryValidationTestCase.fail((String)errorMsg);
        }
    }

    public void test001_ValidateClassLibraries() throws IOException, ClassNotFoundException {
        String classLibraries = this.getString("required.libraries", DEFAULT_REQUIRED_LIBRARIES);
        StringTokenizer tokenizer = new StringTokenizer(classLibraries, ",");
        while (tokenizer.hasMoreTokens()) {
            this.loadClassLib(tokenizer.nextToken().trim());
        }
        int passed = this.validator.checkClasses();
        Object[] parms = new Object[]{Integer.toString(passed), Integer.toString(this.validator.getClassCount())};
        this.getContext().log(3, Nls.format((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7403)), (Object[])parms));
        ClassLibraryValidationTestCase.assertEquals((String)PlatformValidationTestAgent.DefaultResourceBundle.getString(Integer.toString(7406)), (int)this.validator.getClassCount(), (int)passed);
    }
}

