/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display;

import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.display.IDisplayElement;
import org.eclipse.soda.dk.epcglobal.llrp.config.servlet.store.LLRPConfigStore;

public abstract class AbstractDisplayElement
implements IDisplayElement {
    private String name;
    private Object paramObj;
    private int type;
    private StringBuffer comment;

    protected AbstractDisplayElement(String name, Object paramObj, int type) {
        this.name = name;
        this.paramObj = paramObj != null ? paramObj : LLRPConfigStore.getNewParamObj(name);
        this.type = type;
    }

    protected static String getButton(String name, int actionId, String path) {
        StringBuffer result = new StringBuffer();
        result.append("<input type=\"submit\" value=\"" + name + "\" ");
        result.append("onclick=\"setValue('Action','" + actionId + "');");
        result.append("setValue('Path','" + path + "')");
        result.append("\">\n");
        return result.toString();
    }

    protected static String getJavaScriptFunction() {
        StringBuffer result = new StringBuffer();
        result.append("<script type=\"text/javascript\">\n");
        result.append("function setValue(id,val)\n");
        result.append("{\n");
        result.append("document.getElementById(id).value=val");
        result.append("}\n");
        result.append("</script>\n");
        return result.toString();
    }

    public void addComment(String comment) {
        this.comment.append("<br>" + comment);
    }

    public void addCommentTitle(String commentTitle) {
        this.comment.insert(0, "<br>" + commentTitle + "<br>");
    }

    public void clearComment() {
        this.comment.delete(0, this.comment.length());
    }

    public String getComment() {
        if (this.comment == null) {
            this.comment = new StringBuffer();
        }
        return this.comment.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object getParamObj() {
        return this.paramObj;
    }

    public int getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }
}

