/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.measurement.ReadMeasurement;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class CommandMeasurement
extends ReadMeasurement {
    private CommandService writeCommand;

    public CommandMeasurement(String key, Object value, UnitsService units, TransformService transform, SignalService signal, CommandService readCommand, CommandService writeCommand) {
        super(key, value, units, transform, signal, readCommand);
        this.setWriteCommand(writeCommand);
    }

    public void executeWrite(ChannelService channel, Object value) {
        CommandService writeCommand = this.getWriteCommand();
        if (writeCommand != null) {
            TransformService transformService = this.getTransform();
            if (transformService == null) {
                writeCommand.execute(channel, value);
            } else {
                writeCommand.execute(channel, transformService.encode(value));
            }
        } else {
            super.executeWrite(channel, value);
        }
    }

    public CommandService getWriteCommand() {
        return this.writeCommand;
    }

    public void setWriteCommand(CommandService writeCommand) {
        this.writeCommand = writeCommand;
    }
}

