/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.MethodCommand;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Container;
import org.eclipse.soda.dk.device.DeviceListeners;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceControl;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.service.MultiplexDeviceListener;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.transport.ResponseTransport;
import org.eclipse.soda.dk.transport.service.TransportService;

public class Device
extends Container
implements DeviceService,
Runnable {
    public static final String START_COMMAND_NAME = "start";
    public static final String STOP_COMMAND_NAME = "stop";
    public static final String POLL_COMMAND_NAME = "poll";
    protected static final int STARTED_MASK = 65536;
    private DeviceListener deviceListener;
    private long readTimeout = 4000L;
    private Thread thread;
    private boolean isRunning = false;
    protected Measurement channels;
    protected Signal channelChanged;
    protected Command openChannel;
    protected Command closeChannel;

    public Device() {
        this("Device/Capabilities", "Device/Status", "Device/Configuration", "Device/Metrics", "Device/Channels", "Device/ChannelChanged", "Device/OpenChannel", "Device/CloseChannel");
    }

    protected Device(String capabilities, String status, String configuration, String metrics) {
        this.initialize(capabilities, status, configuration, metrics);
        this.setState(1);
    }

    protected Device(String capabilities, String status, String configuration, String metrics, String channels, String channelChanged, String openChannel, String closeChannel) {
        this.initialize(capabilities, status, configuration, metrics, channels, channelChanged, openChannel, closeChannel);
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeviceListener(DeviceListener deviceListener) {
        Map channels;
        Object currentTimestamp = null;
        if (deviceListener != null) {
            int state = this.getState();
            currentTimestamp = Device.getCurrentTimestamp();
            deviceListener.deviceChanged((DeviceService)this, currentTimestamp, state, state);
        }
        this.setDeviceListener(DeviceListeners.add(this.getDeviceListener(), deviceListener));
        TransportService transport = this.getTransport();
        if (transport != null && (channels = transport.getChannels()) != null) {
            Map map = channels;
            synchronized (map) {
                Iterator iterator = channels.values().iterator();
                while (iterator.hasNext()) {
                    ChannelService channel = (ChannelService)iterator.next();
                    if (currentTimestamp == null) {
                        currentTimestamp = Device.getCurrentTimestamp();
                    }
                    this.channelChanged(transport, currentTimestamp, channel, channel.getState(), channel.getState());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelChanged(Object timestamp, ChannelService channel, int newState, int oldState) {
        if (this.channels != null && newState == 5 && (oldState < 5 || this.getChannel(channel.getId()) == null)) {
            this.startupCommands(channel);
            this.activate(channel);
        }
        this.fireChannelChanged(timestamp, channel, newState, oldState);
        if (oldState == 5 && newState < 5) {
            this.deactivate(channel);
        }
        if (this.channels != null) {
            HashMap<String, ChannelService> channels = (HashMap<String, ChannelService>)this.channels.getValueRaw(null);
            String id = channel.getId();
            if (newState == 0) {
                if (channels != null) {
                    HashMap<String, ChannelService> hashMap = channels;
                    synchronized (hashMap) {
                        channels.remove(id);
                    }
                }
            } else {
                if (channels == null) {
                    channels = new HashMap<String, ChannelService>();
                    this.channels.setValue(null, channels, timestamp);
                }
                HashMap<String, ChannelService> hashMap = channels;
                synchronized (hashMap) {
                    if (!channels.containsKey(id)) {
                        channels.put(id, channel);
                    }
                }
            }
        }
        if (this.channelChanged != null) {
            this.channelChanged.trigger(channel, timestamp, this.getStatusDictionary(newState, oldState));
        }
    }

    public void channelChanged(TransportService source, Object timestamp, ChannelService channel, int newState, int oldState) {
        this.channelChanged(timestamp, channel, newState, oldState);
    }

    public void closeChannel(ChannelService channel) {
        this.getTransport().closeChannel(channel);
    }

    public void controlAdded(EscObject container, Object currentTimestamp, ControlService control) {
        DeviceListener deviceListener = this.getDeviceListener();
        if (deviceListener != null) {
            deviceListener.controlChanged((DeviceService)this, currentTimestamp != null ? currentTimestamp : Device.getCurrentTimestamp(), control, 1);
        }
    }

    public void controlRemoved(EscObject container, Object timestamp, ControlService control) {
        DeviceListener deviceListener = this.getDeviceListener();
        if (deviceListener != null) {
            deviceListener.controlChanged((DeviceService)this, timestamp != null ? timestamp : Device.getCurrentTimestamp(), control, 0);
        }
    }

    protected void finalize() throws Throwable {
        if (this.getState() > 0) {
            this.exit();
        }
    }

    public void fireChannelChanged(Object timestamp, ChannelService channel, int newState, int oldState) {
        try {
            MultiplexDeviceListener deviceListener = this.getMultiplexDeviceListener();
            if (deviceListener != null) {
                deviceListener.channelChanged((DeviceService)this, timestamp, channel, newState, oldState);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 3020, this.getMultiplexDeviceListener(), channel);
        }
    }

    public void fireContainerChanged(Object timestamp, int newState, int oldState) {
        try {
            DeviceListener deviceListener = this.getDeviceListener();
            if (deviceListener != null) {
                deviceListener.deviceChanged((DeviceService)this, timestamp, newState, oldState);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 3006, this.deviceListener);
        }
        this.broadcastStatus(timestamp, newState, oldState);
    }

    public void fireErrorOccurred(Object timestamp, Object data) {
        DeviceListener deviceListener = this.getDeviceListener();
        if (deviceListener != null) {
            try {
                deviceListener.errorOccurred((Object)this, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public MeasurementService getCapabilities() {
        return this.capabilities;
    }

    public ChannelService getChannel(String channelId) {
        Map channels;
        if (channelId != null && (channels = (Map)this.getChannels().getValue(null)) != null) {
            return (ChannelService)channels.get(channelId);
        }
        return null;
    }

    public Signal getChannelChanged() {
        return this.channelChanged;
    }

    public Measurement getChannels() {
        return this.channels;
    }

    public Command getCloseChannel() {
        return this.closeChannel;
    }

    public MeasurementService getConfiguration() {
        return this.configuration;
    }

    public String getDefaultKey() {
        return "Device";
    }

    public DeviceListener getDeviceListener() {
        return this.deviceListener;
    }

    public int getMessageCapacity() {
        return 101;
    }

    public Object getMessageKey(MessageService message) {
        if (message == null) {
            return this;
        }
        byte[] bytes = message.getBytes();
        if (bytes.length < 1) {
            return null;
        }
        return Device.createInteger((int)(bytes[0] & 0xFF));
    }

    public MultiplexDeviceListener getMultiplexDeviceListener() {
        DeviceListener deviceListener = this.getDeviceListener();
        return deviceListener instanceof MultiplexDeviceListener ? (MultiplexDeviceListener)deviceListener : null;
    }

    public int getNotificationPriorityDefault() {
        return 0;
    }

    public Command getOpenChannel() {
        return this.openChannel;
    }

    public int getPriority() {
        int priority = this.getInformation() & 0xF;
        if (priority == 0) {
            return 6;
        }
        return priority;
    }

    public long getReadTimeout() {
        if (this.getTransport() instanceof ResponseTransport) {
            long responseTimeout = ((ResponseTransport)this.getTransport()).getResponseTimeout();
            return Math.max(responseTimeout, this.readTimeout);
        }
        return this.readTimeout;
    }

    public MeasurementService getStatus() {
        return this.status;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleMethodChannels(int code, Measurement measurement, ChannelService channel, Object data) {
        switch (code) {
            case 0: {
                HashMap channels = (HashMap)measurement.getValueRaw(null);
                if (channels == null) break;
                HashMap hashMap = channels;
                synchronized (hashMap) {
                    return channels.clone();
                }
            }
        }
        return null;
    }

    public Object handleMethodCloseChannel(int code, Command command, ChannelService channel, Object data) throws IOException {
        switch (code) {
            case 0: {
                this.closeChannel(channel);
                return channel;
            }
        }
        return null;
    }

    public Object handleMethodMetrics(int code, Measurement measurement, ChannelService channel, Object data) {
        if (channel == null) {
            return this.handleMethodMetrics(code, measurement, data);
        }
        return null;
    }

    public Object handleMethodOpenChannel(int code, Command command, ChannelService channel, Object data) throws IOException {
        switch (code) {
            case 0: {
                return this.openChannel((Map)data);
            }
        }
        return null;
    }

    public boolean hasListeners() {
        return this.getDeviceListener() != null;
    }

    protected void initialize(String capabilities, String status, String configuration, String metrics) {
        this.capabilities = new Measurement(capabilities);
        this.status = new Measurement(status);
        this.configuration = new Measurement(configuration);
        this.metrics = new MethodMeasurement(metrics);
        this.put(this.configuration);
        this.put(this.status);
        this.put(this.capabilities);
        this.put(this.metrics);
    }

    protected void initialize(String capabilities, String status, String configuration, String metrics, String channels, String channelChanged, String openChannel, String closeChannel) {
        this.initialize(capabilities, status, configuration, metrics);
        this.channels = new MethodMeasurement(channels);
        this.channelChanged = new Signal(channelChanged);
        this.openChannel = new MethodCommand(openChannel);
        this.closeChannel = new MethodCommand(closeChannel);
        this.put(this.channels);
        this.put(this.channelChanged);
        this.put(this.openChannel);
        this.put(this.closeChannel);
    }

    public boolean isAutoStart() {
        return (this.getInformation() & 1) == 1;
    }

    public boolean isBlockProcessing() {
        return (this.getInformation() & 8) == 8;
    }

    public boolean isEvenProcessing() {
        return (this.getInformation() & 4) == 4;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isStarted() {
        return this.getState() >= 5;
    }

    public boolean isThreadNeeded() {
        return this.isInitializeMeasurements() || !this.getControls().isEmpty();
    }

    protected void load(ControlService control) {
        if (control instanceof DeviceControl) {
            ((DeviceControl)control).setDevice((DeviceService)this);
        }
    }

    public ChannelService openChannel(Map parameters) throws IOException {
        return this.getTransport().openChannel(parameters);
    }

    public void put(String key, ControlService control) {
        super.put(key, control);
        if (this.hasListeners()) {
            this.controlAdded(this, Device.getCurrentTimestamp(), control);
        }
    }

    public void remove(String key) {
        ControlService control = this.get(key);
        if (control != null && this.hasListeners()) {
            this.controlRemoved(this, Device.getCurrentTimestamp(), control);
        }
        super.remove(key);
    }

    public void removeDeviceListener(DeviceListener deviceListener) {
        this.setDeviceListener(DeviceListeners.remove(this.getDeviceListener(), deviceListener));
    }

    public void restart() {
        this.startup(true);
    }

    public void run() {
        if (this.isRunning()) {
            this.transportStartedWait();
            if (this.isRunning()) {
                this.startupCommands(null);
                if (this.isRunning()) {
                    this.setState(5);
                }
            }
        }
    }

    public void setDeviceListener(DeviceListener deviceListener) {
        this.deviceListener = deviceListener;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    public void setStarted(boolean started) {
        if (started) {
            this.setInformation(this.getInformation() | 0x10000);
        } else {
            this.setInformation(this.getInformation() & 0xFFFEFFFF);
        }
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public synchronized void start() {
        TransportService transport;
        super.start();
        if (this.getState() < 4 && (transport = this.getTransport()) != null) {
            if (transport.getState() == 5) {
                if (this.isThreadNeeded()) {
                    this.startup(true);
                } else {
                    this.setState(5);
                }
            } else {
                transport.start();
            }
            return;
        }
        this.startup(true);
    }

    public void startup(boolean output) {
        if (this.isThreadNeeded()) {
            Thread thread = this.getThread();
            if (thread != null) {
                this.setRunning(false);
                thread.interrupt();
                try {
                    thread.join(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setThread(new Thread((Runnable)this, String.valueOf(this.getOutputName())));
            this.thread.setPriority(this.getPriority());
            this.thread.setDaemon(true);
            this.setRunning(true);
            this.thread.start();
        } else {
            this.setState(5);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void stop() {
        this.setRunning(false);
        if (this.getState() >= 5) {
            ControlService control = this.get(POLL_COMMAND_NAME);
            if (control instanceof CommandService) {
                try {
                    ((CommandService)control).execute(null, (Object)Boolean.FALSE);
                }
                catch (RuntimeException runtimeException) {}
            }
            if ((control = this.get(STOP_COMMAND_NAME)) instanceof CommandService) {
                try {
                    ((CommandService)control).execute(null);
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        this.setState(1);
        try {
            try {
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.interrupt();
                    thread.join(10000L);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.thread = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.thread = null;
            return;
        }
    }
}

