/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.service;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public interface DeviceService
extends ControlService {
    public static final String SERVICE_NAME;
    public static final short AUTOSTART = 1;
    public static final short NULL = 0;
    public static final short INITIALIZEMEASUREMENTS = 2;
    public static final short EVENPROCESSING = 4;
    public static final short BLOCKPROCESSING = 8;
    public static final String GET_EXTERNAL_KEY = "/get";
    public static final String READ_EXTERNAL_KEY = "/read";
    public static final String WRITE_EXTERNAL_KEY = "/write";
    public static final String SET_EXTERNAL_KEY = "/set";
    public static final String EXECUTE_EXTERNAL_KEY = "/execute";
    public static final String ERROR_EXTERNAL_KEY = "/error";
    public static final String TRIGGER_EXTERNAL_KEY = "/trigger";
    public static final String VALUE_DATA_KEY = "value";
    public static final String KEYS_DATA_KEY = "keys";
    public static final String VALUE_OLD_DATA_KEY = "value_old";
    public static final String STATE_DATA_KEY = "state";
    public static final String STATE_OLD_DATA_KEY = "state_old";
    public static final String TIMESTAMP_DATA_KEY = "timestamp";
    public static final String SOURCE_DATA_KEY = "source";
    public static final String CONFIGURATION_DATA_KEY = "configuration";
    public static final String RECEIVED_KEY_DATA_KEY = "received_key";
    public static final String[] ALL_COMMANDS;
    public static final String[] ALL_MEASUREMENTS;
    public static final String[] ALL_SIGNALS;
    public static final String Capabilities = "Device/Capabilities";
    public static final String CAPABILITIES_EXTERNAL_KEY = "Device/Capabilities";
    public static final String CAPABILITIES_GET_EXTERNAL_KEY = "Device/Capabilities/get";
    public static final String CAPABILITIES_READ_EXTERNAL_KEY = "Device/Capabilities/read";
    public static final String CAPABILITIES_WRITE_EXTERNAL_KEY = "Device/Capabilities/write";
    public static final String Configuration = "Device/Configuration";
    public static final String CONFIGURATION_EXTERNAL_KEY = "Device/Configuration";
    public static final String CONFIGURATION_GET_EXTERNAL_KEY = "Device/Configuration/get";
    public static final String CONFIGURATION_READ_EXTERNAL_KEY = "Device/Configuration/read";
    public static final String CONFIGURATION_WRITE_EXTERNAL_KEY = "Device/Configuration/write";
    public static final String Status = "Device/Status";
    public static final String STATUS_EXTERNAL_KEY = "Device/Status";
    public static final String STATUS_GET_EXTERNAL_KEY = "Device/Status/get";
    public static final String STATUS_READ_EXTERNAL_KEY = "Device/Status/read";
    public static final String STATUS_WRITE_EXTERNAL_KEY = "Device/Status/write";
    public static final int ACTIVE = 4;
    public static final int ALIVE = 2;
    public static final int CONNECTED = 3;
    public static final int CREATED = 1;
    public static final int DEAD = 0;
    public static final int STARTED = 5;
    public static final String Metrics = "Device/Metrics";
    public static final String METRICS_EXTERNAL_KEY = "Device/Metrics";
    public static final String METRICS_GET_EXTERNAL_KEY = "Device/Metrics/get";
    public static final String BROADCAST_COMMAND_COUNT_DATA_KEY = "broadcastCommandCount";
    public static final String BROADCAST_MEASUREMENT_COUNT_DATA_KEY = "broadcastMeasurementCount";
    public static final String BROADCAST_SIGNAL_COUNT_DATA_KEY = "broadcastSignalCount";
    public static final String CHANNEL_ID_DATA_KEY = "channel_id";
    public static final String CHANNEL_EXTERNAL_ID_DATA_KEY = "channel_external_id";
    public static final String Channels = "Device/Channels";
    public static final String CHANNELS_EXTERNAL_KEY = "Device/Channels";
    public static final String CHANNELS_GET_EXTERNAL_KEY = "Device/Channels/get";
    public static final String CHANNELS_READ_EXTERNAL_KEY = "Device/Channels/read";
    public static final String CHANNELS_WRITE_EXTERNAL_KEY = "Device/Channels/write";
    public static final String ChannelChanged = "Device/ChannelChanged";
    public static final String CHANNEL_CHANGED_EXTERNAL_KEY = "Device/ChannelChanged";
    public static final String OpenChannel = "Device/OpenChannel";
    public static final String OPEN_CHANNEL_EXTERNAL_KEY = "Device/OpenChannel";
    public static final String CloseChannel = "Device/CloseChannel";
    public static final String CLOSE_CHANNEL_EXTERNAL_KEY = "Device/CloseChannel";

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.soda.dk.device.service.DeviceService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        SERVICE_NAME = clazz.getName();
        ALL_COMMANDS = new String[0];
        ALL_MEASUREMENTS = new String[]{"Device/Capabilities", "Device/Configuration", "Device/Status"};
        ALL_SIGNALS = new String[0];
    }

    public void addDeviceListener(DeviceListener var1);

    public void closeChannel(ChannelService var1);

    public Enumeration elements();

    public void exit();

    public ControlService get(String var1);

    public ChannelService getChannel(String var1);

    public CommandService getCommand(String var1);

    public Dictionary getConfigurationInformation();

    public MeasurementService getMeasurement(String var1);

    public NotificationService getNotificationService();

    public SignalService getSignal(String var1);

    public int getState();

    public TransportService getTransport();

    public boolean isStarted();

    public ChannelService openChannel(Map var1) throws IOException;

    public void put(String var1, ControlService var2);

    public void remove(String var1);

    public void removeDeviceListener(DeviceListener var1);

    public void send(ChannelService var1, MessageService var2);

    public void send(ChannelService var1, MessageService var2, ResponseListener var3);

    public void send(MessageService var1, ResponseListener var2);

    public void send(MessageService var1);

    public void setConfigurationInformation(Dictionary var1);

    public void setNotificationService(NotificationService var1);

    public void setTransport(TransportService var1);

    public void start();

    public void stop();
}

