/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.nslog.servlet;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.nslog.servlet.CommonUtils;
import org.eclipse.soda.dk.device.nslog.servlet.DeviceNslogServletContext;
import org.eclipse.soda.dk.device.nslog.servlet.NSBuffer;
import org.eclipse.soda.dk.device.nslog.servlet.NSLogConstants;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;

public class DeviceNslogServlet
extends DeviceServlet
implements NotificationListener,
DeviceServletService,
Servlet {
    private static final long serialVersionUID = 6798842794720561718L;
    private static String[] ignoretopics = NSLogConstants.DEFAULT_IGNORE_TOPIC;
    private static String[] listentopics = NSLogConstants.DEFAULT_LISTEN_TOPIC;
    private static NotificationListener notificationlistener;
    private static NotificationService notificationservice;
    private static NSBuffer nsbuffer;
    private static String topicfilter;

    static {
        nsbuffer = new NSBuffer();
        topicfilter = "";
    }

    private void buildcfgmenu(DeviceServletContext context) {
        context.addEntity("ObjectName", (Object)"Buffer Configuration");
        context.addEntity("ObjectDescription", (Object)"Set what is subscribed to and stored by the buffer.");
        context.template("configbegin");
        context.addEntity("Name", (Object)"Log Size");
        context.addEntity("Value", (Object)new Integer(nsbuffer.getMaxSize()));
        context.addEntity("Message", (Object)"The Maximum number of messages to be stored (positive integer)");
        context.template("configentry");
        context.addEntity("Name", (Object)"Topic Subscriptions");
        context.addEntity("Value", (Object)CommonUtils.CommaSplitString(listentopics));
        context.addEntity("Message", (Object)"Topics to subscribe to (comma-delimited list of Strings)");
        context.template("configentry");
        context.addEntity("Name", (Object)"Ignore Topics");
        context.addEntity("Value", (Object)CommonUtils.CommaSplitString(ignoretopics));
        context.addEntity("Message", (Object)"Subscribed topics to ignore (comma-delimited list of Strings)");
        context.template("configentry");
        context.addEntity("Value", (Object)"Save");
        context.template("configend");
    }

    private void builddisplaymenu(DeviceServletContext context) {
        context.addEntity("ObjectName", (Object)"Display Configuration");
        context.addEntity("ObjectDescription", (Object)"Set what is displayed from the buffer.");
        context.template("configbegin");
        context.addEntity("Name", (Object)"Topic Filter");
        context.addEntity("Value", (Object)topicfilter);
        context.addEntity("Message", (Object)"Only display messages from the buffer for a given topic (String)");
        context.template("configentry");
        context.addEntity("Value", (Object)"Save");
        context.template("configend");
    }

    private void buildpublishmenu(DeviceServletContext context) {
        context.addEntity("ObjectName", (Object)"Publish NS Data");
        context.addEntity("ObjectDescription", (Object)"Publish data to the notification service.");
        context.template("configbegin");
        context.addEntity("Name", (Object)"Publish Topic");
        context.addEntity("Value", (Object)"Test/Example");
        context.addEntity("Message", (Object)"Topic to publish on (String)");
        context.template("configentry");
        context.addEntity("Name", (Object)"Publish Data");
        context.addEntity("Value", (Object)"{value={output=true}}");
        context.addEntity("Message", (Object)"Data to publish (String or Map.toString() format)");
        context.template("configentry");
        context.addEntity("Value", (Object)"Publish");
        context.template("configend");
    }

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DeviceNslogServletContext context = new DeviceNslogServletContext(request, response, this.getServletAlias());
        return context;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object publishdata;
        Object Ignoring;
        Object Subscriptions;
        Object TopicFilter;
        int newsize;
        DeviceServletContext context = this.createContext(request, response);
        this.setup(context);
        context.begin();
        HashMap<String, String> table = new HashMap<String, String>(101);
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = String.valueOf(enumeration.nextElement());
            String value = request.getParameter(key);
            table.put(key, value);
        }
        Object Size = table.get("Log Size");
        if (Size != null && Size.toString().length() > 0 && (newsize = Integer.parseInt(Size.toString())) > 0) {
            nsbuffer.resize(newsize);
        }
        if ((TopicFilter = table.get("Topic Filter")) != null) {
            topicfilter = TopicFilter.toString();
        }
        if ((Subscriptions = table.get("Topic Subscriptions")) != null) {
            listentopics = CommonUtils.SplitString(Subscriptions.toString(), ",");
            notificationservice.unregister(notificationlistener);
            if (!"".equals(listentopics[0])) {
                notificationservice.register(listentopics, notificationlistener);
            }
        }
        if ((Ignoring = table.get("Ignore Topics")) != null) {
            ignoretopics = CommonUtils.SplitString(Ignoring.toString(), ",");
        }
        if ((publishdata = table.get("Publish Data")) != null && publishdata.toString().length() > 0) {
            Object publishtopic = table.get("Publish Topic");
            if (publishdata.toString().startsWith("{") && publishdata.toString().endsWith("}")) {
                String trimbraces = publishdata.toString().substring(1, publishdata.toString().length() - 1);
                Hashtable pass = new Hashtable(7);
                Dictionary wrapper = CommonUtils.ParseSimpleDictionary(trimbraces, pass);
                wrapper = CommonUtils.ParseNestedDictionary(trimbraces, pass);
                wrapper = CommonUtils.StringtoDictionaryLoop(wrapper);
                notificationservice.broadcast(publishtopic.toString(), wrapper);
            } else {
                Hashtable<String, String> pubdata = new Hashtable<String, String>(1);
                ((Dictionary)pubdata).put("value", publishdata.toString());
                notificationservice.broadcast(publishtopic.toString(), pubdata);
            }
        }
        this.processRequest(context);
        context.end();
    }

    public NotificationService getNotificationService() {
        return notificationservice;
    }

    public void notificationReceived(String topic, Dictionary data) {
        boolean ignore = false;
        int i = 0;
        while (i < ignoretopics.length) {
            if (topic.equals(ignoretopics[i])) {
                ignore = true;
            }
            ++i;
        }
        if (!ignore) {
            nsbuffer.enqueue(topic, data);
        }
    }

    public void processRequest(DeviceServletContext context) {
        this.buildcfgmenu(context);
        this.builddisplaymenu(context);
        this.buildpublishmenu(context);
        context.addEntity("ObjectName", (Object)"History");
        if ("".equals(CommonUtils.CommaSplitString(listentopics))) {
            context.addEntity("StatusVar", (Object)"Stopped");
        } else {
            context.addEntity("StatusVar", (Object)"Active");
        }
        context.addEntity("ObjectDescription", (Object)("Messages published on Notification Service listed in descending order from oldest to newest. (Max " + nsbuffer.getMaxSize() + ')'));
        context.template("Historybegin");
        Object[][] msgbuffer = nsbuffer.getOrderedBuffer();
        if (msgbuffer != null) {
            int i = 0;
            while (i < msgbuffer.length) {
                if ("".equals(topicfilter)) {
                    context.addEntity("NSTopic", (Object)msgbuffer[i][0].toString());
                    context.addEntity("NSData", (Object)msgbuffer[i][1].toString());
                    context.template("nsentry");
                } else if (topicfilter.equals(msgbuffer[i][0].toString())) {
                    context.addEntity("NSTopic", (Object)msgbuffer[i][0].toString());
                    context.addEntity("NSData", (Object)msgbuffer[i][1].toString());
                    context.template("nsentry");
                }
                ++i;
            }
        }
        context.template("nsend");
    }

    public void setNotificationService(NotificationService notificationService) {
        if (notificationservice != null) {
            notificationservice.unregister((NotificationListener)this);
        }
        notificationservice = notificationService;
        notificationlistener = this;
        if (notificationservice != null) {
            notificationservice.register(listentopics, notificationlistener);
        }
    }
}

