/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.bundle.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.soda.dk.device.bundle.servlet.DeviceBundleServletContext;
import org.eclipse.soda.dk.device.servlet.DeviceServlet;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.device.servlet.service.DeviceServletService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.AttributeDefinition;

public class DeviceBundleServlet
extends DeviceServlet
implements DeviceServletService,
Servlet {
    private static final long serialVersionUID = 124828893804251702L;

    public DeviceServletContext createContext(HttpServletRequest request, HttpServletResponse response) {
        DeviceBundleServletContext context = new DeviceBundleServletContext(request, response, this.getServletAlias());
        return context;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DeviceServletContext context = this.createContext(request, response);
        this.setup(context);
        context.begin();
        this.processRequest(context);
        HashMap<String, String> table = new HashMap<String, String>(101);
        HashMap<String, String> extraTable = new HashMap<String, String>(101);
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = String.valueOf(enumeration.nextElement());
            String value = request.getParameter(key);
            if (key.startsWith("_")) {
                extraTable.put(key, value);
                continue;
            }
            table.put(key, value);
        }
        context.template("end");
    }

    public AttributeDefinition findAttribute(Object key, AttributeDefinition[] attributeDefinitions) {
        int i = 0;
        while (i < attributeDefinitions.length) {
            if (key.equals(attributeDefinitions[i].getID())) {
                return attributeDefinitions[i];
            }
            ++i;
        }
        return null;
    }

    public void processBundleHeaders(DeviceBundleServletContext context) {
        Bundle[] bundles = this.getBundles();
        Bundle[] filteredBundles = context.filter(bundles);
        context.sort(filteredBundles);
        int i = 0;
        while (i < filteredBundles.length) {
            Bundle bundle = filteredBundles[i];
            Dictionary headers = bundle.getHeaders();
            context.addEntityBundle(bundle);
            context.template("bundleheaderbegin");
            ArrayList<String> keyList = new ArrayList<String>(100);
            Enumeration enumeration = headers.keys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement().toString();
                keyList.add(key);
            }
            int keySize = keyList.size();
            String[] keys = new String[keySize];
            keys = keyList.toArray(keys);
            context.sort(keys);
            int j = 0;
            while (j < keySize) {
                String key = keys[j];
                Object value = headers.get(key);
                context.addEntity("Key", context.formatData(key));
                context.addEntityIcon("ManifestEntryIcon", "mf_entry_obj.gif");
                if (key.endsWith("Package") || key.endsWith("Service") || key.endsWith("Require-Bundle")) {
                    StringTokenizer tokinzer = new StringTokenizer(String.valueOf(value), ",");
                    while (tokinzer.hasMoreTokens()) {
                        String token = tokinzer.nextToken();
                        int index = token.indexOf(59);
                        if (index > 0) {
                            context.addEntity("Value", token.substring(0, index).trim());
                            String version = token.substring(index + 1);
                            if (version.startsWith("version")) {
                                int eqindex = version.indexOf(61);
                                if (eqindex > 0) {
                                    version = version.substring(eqindex + 1);
                                }
                                if ((version = version.trim()).startsWith("\"") && version.endsWith("\"")) {
                                    version = version.substring(1, version.length() - 1);
                                }
                                context.addEntity("Version", version);
                                context.template("bundleheaderrevisionentry");
                            } else {
                                context.addEntity("Version", version);
                                context.template("bundleheaderrevisionentry");
                            }
                        } else {
                            context.addEntity("Value", token.trim());
                            context.addEntity("Version", "");
                            context.template("bundleheaderentry");
                        }
                        context.addEntity("Key", "");
                        context.addEntityIcon("ManifestEntryIcon", "");
                    }
                } else {
                    context.addEntity("Value", context.formatData(value));
                    context.addEntity("Version", "");
                    context.template("bundleheaderentry");
                }
                ++j;
            }
            String value = bundle.getLocation();
            context.addEntityIcon("ManifestEntryIcon", "");
            context.addEntity("Key", "<b>Location</b>");
            context.addEntity("Value", context.formatData(value));
            context.addEntity("Version", "");
            context.template("bundleheaderentry");
            context.template("bundleheaderend");
            ++i;
        }
    }

    public void processBundles(DeviceBundleServletContext context) {
        Bundle[] bundles = this.getBundles();
        Bundle[] filteredBundles = context.filter(bundles);
        context.template("bundlebegin");
        int i = filteredBundles.length - 1;
        while (i >= 0) {
            Bundle bundle = filteredBundles[i];
            ServiceReference[] registeredServices = bundle.getRegisteredServices();
            if (registeredServices == null) {
                registeredServices = new ServiceReference[]{};
            } else {
                context.sort(registeredServices);
            }
            ServiceReference[] servicesInUse = bundle.getServicesInUse();
            if (servicesInUse == null) {
                servicesInUse = new ServiceReference[]{};
            } else {
                context.sort(servicesInUse);
            }
            int maxSize = Math.max(registeredServices.length, servicesInUse.length);
            if (maxSize < 1) {
                maxSize = 1;
            }
            context.addEntityBundle(bundle);
            int j = 0;
            while (j < maxSize) {
                if (j == 0) {
                    context.template("bundleentry");
                } else {
                    context.template("bundleserviceentry");
                }
                if (j < registeredServices.length) {
                    context.addEntityIcon("ServiceIcon", "service.gif");
                    context.addEntityServiceReference(registeredServices[j]);
                    context.template("servicereference");
                }
                if (j < servicesInUse.length) {
                    context.addEntityIcon("ServiceIcon", "service.gif");
                    context.addEntityServiceReference(servicesInUse[j]);
                    context.template("servicereference");
                }
                context.template("bundleentryend");
                ++j;
            }
            --i;
        }
        context.template("bundleend");
    }

    public void processFileRequest(DeviceServletContext context) {
        Bundle[] bundles = this.getBundles();
        Bundle[] filteredBundles = context.filter(bundles);
        context.sort(filteredBundles);
        int i = 0;
        while (i < filteredBundles.length) {
            Bundle bundle = filteredBundles[i];
            URL url = bundle.getResource(context.getFilePath());
            context.respondWith(url);
            ++i;
        }
    }

    public void processRequest(DeviceServletContext context) {
        this.processBundles((DeviceBundleServletContext)context);
        this.processBundleHeaders((DeviceBundleServletContext)context);
    }
}

