/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.MultiParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class SingleParameter
extends MultiParameter {
    public SingleParameter() {
    }

    public SingleParameter(String key) {
        super(key);
    }

    public SingleParameter(String key, ParameterService[] parameters) {
        super(key, parameters);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        Object result = null;
        int count = 0;
        int index = 0;
        while (index < length) {
            ParameterService parameter = parameters[index];
            Object value = parameter.decodeValue(message, cursor);
            if (!parameter.isConstantParameter()) {
                result = value;
                ++count;
            }
            ++index;
        }
        if (count > 1) {
            throw new IllegalArgumentException(String.valueOf(count));
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        ParameterService[] parameters = this.getParameters();
        int length = parameters.length;
        MessageService result = message;
        int count = 0;
        int index = 0;
        while (index < length) {
            ParameterService parameter = parameters[index];
            result = parameter.encodeValue(result, value, cursor);
            if (!parameter.isConstantParameter()) {
                ++count;
            }
            ++index;
        }
        if (count > 1) {
            throw new IllegalArgumentException(String.valueOf(count));
        }
        return result;
    }
}

