/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.parameter.StringParameter;

public class BooleanStringParameter
extends StringParameter {
    private String falseString;
    private String trueString;

    public BooleanStringParameter() {
    }

    public BooleanStringParameter(String key, int length) {
        super(key, length);
    }

    public BooleanStringParameter(String key, int length, String encoding) {
        super(key, length, encoding);
    }

    public BooleanStringParameter(String key, int offset, int length) {
        super(key, offset, length);
    }

    public BooleanStringParameter(String key, int offset, int length, String encoding) {
        super(key, offset, length, encoding);
    }

    public BooleanStringParameter(String key, int offset, int length, String falseString, String trueString, String encoding) {
        super(key, offset, length, encoding);
        this.setFalseString(falseString);
        this.setTrueString(trueString);
    }

    public String dataToString(Object data) {
        boolean state = EscConfiguration.booleanValue(data);
        if (state) {
            return this.getTrueString();
        }
        return this.getFalseString();
    }

    public String getFalseString() {
        if (this.falseString != null) {
            return this.falseString;
        }
        return this.getFalseStringDefault();
    }

    public String getFalseStringDefault() {
        return "0";
    }

    public String getTrueString() {
        if (this.trueString != null) {
            return this.trueString;
        }
        return this.getTrueStringDefault();
    }

    public String getTrueStringDefault() {
        return "1";
    }

    public void setFalseString(String falseString) {
        this.falseString = falseString;
    }

    public void setTrueString(String trueString) {
        this.trueString = trueString;
    }
}

