/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.block;

import org.eclipse.soda.dk.parameter.IntegerParameter;
import org.eclipse.soda.dk.parameter.service.BlockService;
import org.eclipse.soda.dk.parameter.service.LengthBlockService;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class LengthBlock
extends IntegerParameter
implements BlockService,
LengthBlockService {
    public LengthBlock() {
    }

    public LengthBlock(int length) {
        super("", length);
    }

    public LengthBlock(String key) {
        super(key);
    }

    public LengthBlock(String key, int length) {
        super(key, length);
    }

    public LengthBlock(String key, int offset, int length) {
        super(key, offset, length);
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        int offset = this.getOffsetValue(cursor);
        int plength = this.getLength(cursor);
        int length = this.updateLength(LengthBlock.getUnsignedInteger(container, offset, plength));
        Integer number = LengthBlock.createInteger(length);
        if (cursor != null) {
            super.updateCursor(cursor, plength);
            cursor.setLength(length);
        } else {
            super.updateCursor(cursor);
        }
        return number;
    }

    public byte[] encodeBytes(byte[] container, Object data, ParameterCursorService cursor) {
        if (cursor != null) {
            LengthBlockService lengthBlock = cursor.getLengthBlock();
            if (lengthBlock == null) {
                int bytesLength = cursor.getMessageLength();
                byte[] bytes = LengthBlock.setBits(container, bytesLength, this.getOffsetAbsolute(cursor), this.getLength(cursor), 0L, this.isInsert(cursor));
                cursor.setLengthBlock((LengthBlockService)this);
                cursor.setOffsetAbsolute(this.getOffsetAbsolute(cursor) + this.getLength(cursor));
                if (this.isInsert(cursor)) {
                    cursor.updateMessageLength(this.getLength(cursor));
                }
                return bytes;
            }
            byte[] bytes = LengthBlock.setBits(container, this.getOffsetAbsolute(cursor.getLengthCursor()), this.getLength(cursor.getLengthCursor()), this.getCorrectLength(cursor.getLength()), false);
            cursor.setLengthBlock(null);
            return bytes;
        }
        return null;
    }

    public int getCorrectLength(int length) {
        return length;
    }

    public boolean isConstantParameter() {
        return true;
    }

    protected void updateCursor(ParameterCursorService cursor) {
    }

    protected int updateLength(int length) {
        return length;
    }
}

