/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.data;

import org.eclipse.soda.dk.data.Fraction;

public class LongFraction
extends Fraction {
    private static final long serialVersionUID = 5069584593980662404L;
    protected long numerator;
    protected long denominator;

    public LongFraction(int numerator) {
        this(numerator, 1);
    }

    public LongFraction(int numerator, int denominator) {
        this.setNumerator(numerator);
        this.setDenominator(denominator);
        this.reduce();
    }

    public LongFraction(long numerator) {
        this(numerator, 1L);
    }

    public LongFraction(long numerator, long denominator) {
        this.setNumerator(numerator);
        this.setDenominator(denominator);
        this.reduce();
    }

    public LongFraction(String value) {
        int index = value.indexOf(47, 0);
        if (index == -1) {
            this.setNumerator(Long.parseLong(value, 10));
            this.setDenominator(1L);
        } else {
            this.setNumerator(Long.parseLong(value.substring(0, index), 10));
            this.setDenominator(Long.parseLong(value.substring(index + 1), 10));
        }
    }

    public Number add(Number fraction) {
        return new LongFraction(this.getNumerator() + fraction.longValue() * this.getDenominator(), this.getDenominator());
    }

    public LongFraction divide(int value) {
        if (this.getNumerator() == (long)value) {
            return new LongFraction(1L, this.getDenominator());
        }
        return new LongFraction(this.getNumerator(), this.getDenominator() * (long)value);
    }

    public LongFraction divide(LongFraction fraction) {
        if (this.getNumerator() == fraction.getNumerator()) {
            return new LongFraction(this.getDenominator(), fraction.getDenominator());
        }
        if (this.getDenominator() == fraction.getDenominator()) {
            return new LongFraction(this.getNumerator(), fraction.getNumerator());
        }
        return new LongFraction((int)(this.getNumerator() * fraction.getDenominator()), (int)(this.getDenominator() * fraction.getNumerator()));
    }

    public Number divide(Number value) {
        if (value instanceof LongFraction) {
            return this.divide((LongFraction)value);
        }
        return this.divide(value.intValue());
    }

    public double doubleValue() {
        return (double)this.getNumerator() / (double)this.getDenominator();
    }

    public boolean equals(Object compare) {
        if (compare instanceof LongFraction) {
            LongFraction compare2 = (LongFraction)compare;
            if (this.getNumerator() != compare2.getNumerator()) {
                return false;
            }
            return this.getNumerator() == compare2.getNumerator();
        }
        return false;
    }

    public float floatValue() {
        return (float)this.getNumerator() / (float)this.getDenominator();
    }

    public long getDenominator() {
        return this.denominator;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public int intDenominator() {
        return (int)this.getDenominator();
    }

    public int intNumerator() {
        return (int)this.getNumerator();
    }

    public int intValue() {
        return (int)(this.getNumerator() / this.getDenominator());
    }

    public long longDenominator() {
        return this.getDenominator();
    }

    public long longNumerator() {
        return this.getNumerator();
    }

    public long longValue() {
        return this.getNumerator() / this.getDenominator();
    }

    public LongFraction multiply(int value) {
        if (this.getDenominator() == (long)value) {
            return new LongFraction(this.getNumerator());
        }
        return new LongFraction(this.getNumerator() * (long)value, this.getDenominator());
    }

    public LongFraction multiply(LongFraction fraction) {
        if (this.getNumerator() == fraction.getDenominator()) {
            return new LongFraction(fraction.getNumerator(), this.getDenominator());
        }
        if (this.getDenominator() == fraction.getNumerator()) {
            return new LongFraction(this.getNumerator(), fraction.getDenominator());
        }
        return new LongFraction(this.getNumerator() * fraction.getNumerator(), (long)((int)(this.getDenominator() * fraction.getDenominator())));
    }

    public Number multiply(Number value) {
        if (value instanceof LongFraction) {
            return this.multiply((LongFraction)value);
        }
        return this.multiply(value.intValue());
    }

    public Number negate() {
        return new LongFraction(-this.getNumerator(), this.getDenominator());
    }

    public Number reciprocal() {
        return new LongFraction(this.getDenominator(), this.getNumerator());
    }

    public void reduce() {
        if (this.getNumerator() % this.getDenominator() == 0L) {
            this.setNumerator(this.getNumerator() / this.getDenominator());
            this.setDenominator(1L);
        }
    }

    public void setDenominator(long denominator) {
        this.denominator = denominator;
    }

    protected void setNumerator(long numerator) {
        this.numerator = numerator;
    }

    public Number subtract(Number fraction) {
        return new LongFraction(this.getNumerator() - fraction.longValue() * this.getDenominator(), this.getDenominator());
    }

    public String toString() {
        if (this.getDenominator() == 1L) {
            return Long.toString(this.getNumerator());
        }
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(Long.toString(this.getNumerator()));
        buffer.append('/');
        buffer.append(Long.toString(this.getDenominator()));
        return buffer.toString();
    }
}

