/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.core;

public class LargeInteger
extends Number {
    private static final long serialVersionUID = -5982724466502061065L;
    private byte[] bytes;

    public LargeInteger() {
        this(new byte[0]);
    }

    public LargeInteger(byte[] bytes) {
        this.bytes = bytes;
    }

    public LargeInteger(String string) {
        this.setBytes(LargeInteger.largeNumberBytes(string));
    }

    public static final byte[] addDigit(byte[] bytes, int digit) {
        int length = bytes.length;
        byte[] tbytes = new byte[length];
        int carry = 0;
        int i = length - 1;
        while (i >= 0) {
            int value = bytes[i] & 0xFF;
            value *= 10;
            if (i == length - 1) {
                if ((value += digit) > 255) {
                    carry = value >> 8;
                    value &= 0xFF;
                } else {
                    carry = 0;
                }
            } else if ((value += carry) > 255) {
                carry = value >> 3;
                value &= 0xFF;
            } else {
                carry = 0;
            }
            tbytes[i] = (byte)value;
            --i;
        }
        return tbytes;
    }

    public static final byte[] complementBytes(byte[] bytes) {
        int length = bytes.length;
        byte[] tbytes = new byte[length];
        int carry = 0;
        int i = length - 1;
        while (i >= 0) {
            int value = bytes[i] & 0xFF ^ 0xFF;
            carry = i == length - 1 ? (++value > 255 ? value / 255 : 0) : ((value += carry) > 255 ? value / 255 : 0);
            tbytes[i] = (byte)value;
            --i;
        }
        return tbytes;
    }

    public static final byte[] largeNumberBytes(String number) {
        boolean negative = number.startsWith("-");
        char[] characters = number.toCharArray();
        int length = characters.length;
        int start = negative ? 1 : 0;
        byte[] tbytes = new byte[length << 2];
        int i = start;
        while (i < length) {
            int digit = characters[i] - 48;
            tbytes = LargeInteger.addDigit(tbytes, digit);
            ++i;
        }
        if (negative) {
            tbytes = LargeInteger.complementBytes(tbytes);
        }
        return LargeInteger.reduceBytes(tbytes, negative);
    }

    public static final String largeNumberString(byte[] bytes) {
        boolean positive;
        boolean bl = positive = (bytes[0] & 0x80) == 0;
        if (positive) {
            return LargeInteger.unsignedLargeNumberString(bytes);
        }
        StringBuffer buffer = new StringBuffer(1024);
        int length = bytes.length;
        byte[] tbytes = new byte[length];
        int start = 0;
        int carry = 0;
        int i = length - 1;
        while (i >= 0) {
            int value = bytes[i] & 0xFF ^ 0xFF;
            carry = i == length - 1 ? (++value > 255 ? value - 255 : 0) : ((value += carry) > 255 ? value - 255 : 0);
            tbytes[i] = (byte)value;
            if (bytes[i] != 0) {
                start = i;
            }
            --i;
        }
        while (start < length) {
            carry = 0;
            i = start;
            while (i < length) {
                int a = tbytes[i] & 0xFF;
                int newa = a + (carry << 8);
                int b = newa / 10;
                carry = newa % 10;
                tbytes[i] = (byte)b;
                if (i == start && b == 0) {
                    ++start;
                }
                ++i;
            }
            buffer.append(carry);
        }
        buffer.append('-');
        return buffer.reverse().toString();
    }

    public static final byte[] reduceBytes(byte[] bytes, boolean negative) {
        boolean countNegative;
        int count = 0;
        int length = bytes.length;
        byte value = negative ? (byte)-1 : 0;
        int i = 0;
        while (i < length) {
            if (bytes[i] != value) break;
            ++count;
            ++i;
        }
        if (count == 0) {
            return bytes;
        }
        boolean bl = countNegative = (bytes[count] & 0x80) != 0;
        if (countNegative ^ negative) {
            --count;
        }
        byte[] newbytes = new byte[length - count];
        System.arraycopy(bytes, count, newbytes, 0, length - count);
        return newbytes;
    }

    public static final String unsignedLargeNumberString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer(1024);
        int length = bytes.length;
        byte[] tbytes = new byte[length];
        int start = 0;
        int i = length - 1;
        while (i >= 0) {
            tbytes[i] = bytes[i];
            if (bytes[i] != 0) {
                start = i;
            }
            --i;
        }
        while (start < length) {
            int carry = 0;
            int i2 = start;
            while (i2 < length) {
                int a = tbytes[i2] & 0xFF;
                int newa = a + (carry << 8);
                int b = newa / 10;
                carry = newa % 10;
                tbytes[i2] = (byte)b;
                if (i2 == start && b == 0) {
                    ++start;
                }
                ++i2;
            }
            buffer.append(carry);
        }
        return buffer.reverse().toString();
    }

    public double doubleValue() {
        return 0.0;
    }

    public float floatValue() {
        return 0.0f;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int intValue() {
        return 0;
    }

    public long longValue() {
        return 0L;
    }

    public byte[] multiplyByTen(byte[] bytes) {
        int length = bytes.length;
        byte[] tbytes = new byte[length];
        int carry = 0;
        int i = length - 1;
        while (i >= 0) {
            int value = bytes[i] & 0xFF;
            carry = i == length - 1 ? (value > 255 ? value >> 8 : 0) : ((value += carry) > 255 ? (value *= 10) >> 8 : 0);
            tbytes[i] = (byte)value;
            --i;
        }
        return tbytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        return LargeInteger.largeNumberString(this.getBytes());
    }
}

