/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.base.device;

import org.eclipse.soda.dk.base.device.service.BaseDeviceService;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.transport.service.TransportService;

public abstract class BaseDevice
extends Device
implements DeviceService,
BaseDeviceService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.base.device.BaseDevice";
    protected final Measurement status = new Measurement("Device/Status");
    protected final Measurement configuration = new Measurement("Device/Configuration");
    protected final Measurement capabilities = new Measurement("Device/Capabilities");

    protected BaseDevice() {
        super("Device/Capabilities", "Device/Status", "Device/Configuration", "Device/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    protected BaseDevice(String capabilities, String status, String configuration, String metrics) {
        super(capabilities, status, configuration, metrics);
    }

    protected BaseDevice(String capabilities, String status, String configuration, String metrics, String channels, String channelChanged, String openChannel, String closeChannel) {
        super(capabilities, status, configuration, metrics, channels, channelChanged, openChannel, closeChannel);
    }

    public MeasurementService getCapabilities() {
        return this.capabilities;
    }

    public MeasurementService getConfiguration() {
        return this.configuration;
    }

    public int getControlCapacity() {
        return 7;
    }

    public String getDefaultKey() {
        return "BaseDevice";
    }

    public TransportService getDefaultTransport() {
        return null;
    }

    public int getMessageCapacity() {
        return 2;
    }

    public MeasurementService getStatus() {
        return this.status;
    }

    private void initialize() {
        this.put((ControlService)this.status);
        this.put((ControlService)this.configuration);
        this.put((ControlService)this.capabilities);
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("basedevice.notificationpriority", this.getNotificationPriority()));
    }
}

