/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.barcode.reader.inventory.profile;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.barcode.reader.inventory.profile.service.BarcodeReaderInventoryProfileService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.inventory.profile.RfidInventoryProfile;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class BarcodeReaderInventoryProfile
extends RfidInventoryProfile
implements ProfileService,
BarcodeReaderInventoryProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.barcode.reader.inventory.profile.BarcodeReaderInventoryProfile";
    protected SignalService barcodeReaderDeviceServiceBarcodeReport;
    private AdapterService adapter;
    protected boolean reading = false;

    public BarcodeReaderInventoryProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    protected boolean autonomousModeOff() {
        this.setReading(false);
        return false;
    }

    protected boolean autonomousModeOn() {
        this.setReading(true);
        return false;
    }

    public AdapterService getAdapter() {
        return this.adapter;
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)BarcodeReaderInventoryProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.barcode.reader.device.BarcodeReaderDevice");
    }

    public String getDefaultKey() {
        return "BarcodeReaderInventoryProfile";
    }

    public void handleBarcodeReaderDeviceServiceBarcodeReport(SignalService source, Object timestamp, Object data) {
        if (data instanceof Map) {
            Map map = (Map)data;
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Map value = (Map)entry.getValue();
                value.put("reader", this.getId());
                value.put("timestampFirst", timestamp);
                value.put("timestampLast", timestamp);
                value.put("count", BarcodeReaderInventoryProfile.createInteger((int)1));
                value.put("tagType", "barcode");
            }
            this.notifyTagRead(map);
        } else if (data instanceof Message || data instanceof String) {
            Hashtable<String, Object> value = new Hashtable<String, Object>();
            value.put("reader", this.getId());
            value.put("timestampFirst", timestamp);
            value.put("timestampLast", timestamp);
            value.put("count", BarcodeReaderInventoryProfile.createInteger((int)1));
            value.put("tagType", "barcode");
            Hashtable<String, Hashtable<String, Object>> report = new Hashtable<String, Hashtable<String, Object>>();
            report.put(data.toString(), value);
            this.notifyTagRead(report);
        } else {
            this.tagReport.fireErrorOccurred(timestamp, data);
        }
    }

    protected void handleSetAggregationMaskSetting(Measurement measurement, Object data) {
        if (!(data instanceof String)) {
            throw new IllegalArgumentException(String.valueOf(data));
        }
        this.aggregationInterest = this.parseBarcodeInterestMasks((String)data);
        measurement.setValue(data, BarcodeReaderInventoryProfile.getCurrentTimestamp());
    }

    protected void handleSetTagMaskSetting(Measurement measurement, Object data) {
        if (data instanceof String) {
            this.tagInterest = this.parseBarcodeInterestMasks((String)data);
            measurement.setValue(data, BarcodeReaderInventoryProfile.getCurrentTimestamp());
            return;
        }
        throw new IllegalArgumentException("handleSetTagMaskSetting: " + data);
    }

    private void initialize() {
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    public boolean isReading() {
        return this.reading;
    }

    protected InterestMasks parseBarcodeInterestMasks(String targetTagConfig) {
        InterestMasks interests = new InterestMasks();
        if (targetTagConfig != null) {
            try {
                String[] masksConfig = BarcodeReaderInventoryProfile.parseDelimitedByToken((String)targetTagConfig, (String)";");
                int i = 0;
                while (i < masksConfig.length) {
                    String[] configParam = BarcodeReaderInventoryProfile.parseDelimitedByToken((String)masksConfig[i], (String)",");
                    int offset = Integer.parseInt(configParam[1]);
                    int length = Integer.parseInt(configParam[2]);
                    byte[] pattern = configParam[3].getBytes();
                    InterestMask interest = new InterestMask(offset, length, pattern);
                    interests.add((InterestService)interest);
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("parseInterestMasks: " + targetTagConfig);
            }
        }
        return interests;
    }

    public void setAdapter(AdapterService adapter) {
        this.adapter = adapter;
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null && this.barcodeReaderDeviceServiceBarcodeReport != null) {
            this.barcodeReaderDeviceServiceBarcodeReport.removeSignalListener((SignalListener)this);
        }
        if (device != null) {
            this.barcodeReaderDeviceServiceBarcodeReport = device.getSignal("BarcodeReport");
            this.initializeSignal(this.barcodeReaderDeviceServiceBarcodeReport);
        }
        super.setDevice(device);
    }

    public void setReading(boolean reading) {
        this.reading = reading;
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("barcodereaderinventoryprofile.notificationpriority", this.getNotificationPriority()));
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.barcodeReaderDeviceServiceBarcodeReport == source) {
            this.handleBarcodeReaderDeviceServiceBarcodeReport(source, timestamp, data);
            return;
        }
        super.signalOccurred(source, timestamp, data);
    }

    protected byte[] strToBytes(String str) {
        if (str == null) {
            return null;
        }
        return str.getBytes();
    }
}

