/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testagent.wizard;

import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.testagent.wizard.TestAgentMessages;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitBasePage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.widgets.Composite;

public class TestAgentPage
extends DeviceKitBasePage {
    public static final String[] TEST_AGENT_COMMON_TEXT_KEYS = new String[]{"name", "packagebase", "usermessagebase", "provider", "version", "vendor", "vendortwo", "description"};
    private static IWizardMessages messages = TestAgentMessages.getInstance();

    public TestAgentPage(String pageName) {
        this(messages.getString("new." + pageName), messages.getString(pageName));
    }

    public TestAgentPage(String pageName, String title) {
        super(pageName);
        this.setTitle(title);
    }

    public TestAgentPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createCustomControl(Composite composite) {
        this.createCommonOptions(composite);
    }

    protected String[] getCommonTextKeys() {
        return TEST_AGENT_COMMON_TEXT_KEYS;
    }

    protected String getKey() {
        return "profile";
    }

    public String getString(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception exception) {
            return super.getString(key);
        }
    }

    protected String getUserMessageBase() {
        return this.getWidgetText("usermessagebase");
    }

    public Map getVariables() {
        Map table = super.getVariables();
        table.put("device.superclass", "");
        return table;
    }

    protected boolean updatePageErrors() {
        return super.updatePageErrors() & this.userMessageBaseOk();
    }

    protected boolean userMessageBaseOk() {
        String userMessageBase = this.getUserMessageBase();
        try {
            Integer.valueOf(userMessageBase);
        }
        catch (NumberFormatException numberFormatException) {
            String errorMessage = this.getString("usermessagebase.error");
            this.update(false, false, errorMessage, null);
            return false;
        }
        return true;
    }
}

