/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.soda.devicekit.ui.preference.ParentItem;

public class LeafItem
extends ParentItem {
    private TemplatePersistenceData templatePersistenceData;
    private String contents = "";

    public LeafItem() {
    }

    public LeafItem(String id, String name) {
        super(id, name);
    }

    public LeafItem(ParentItem parentItem, TemplatePersistenceData templatePersistenceData) {
        this.setTemplatePersistenceData(templatePersistenceData);
        if (templatePersistenceData != null) {
            this.setId(templatePersistenceData.getId());
            Template template = templatePersistenceData.getTemplate();
            this.setName(template.getName());
            this.setContents(template.getPattern().trim());
        }
    }

    public String getContents() {
        return this.contents;
    }

    public TemplatePersistenceData getTemplatePersistenceData() {
        return this.templatePersistenceData;
    }

    public void revert() {
        this.getTemplatePersistenceData().revert();
    }

    public void save() {
        Template template = this.getTemplatePersistenceData().getTemplate();
        String templatePattern = template.getPattern().trim();
        if (!this.getContents().equals(templatePattern)) {
            Template newTemplate = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), this.getContents(), template.isAutoInsertable());
            this.getTemplatePersistenceData().setTemplate(newTemplate);
        }
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public void setTemplatePersistenceData(TemplatePersistenceData templatePersistenceData) {
        this.templatePersistenceData = templatePersistenceData;
    }
}

