/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.generic.adapter.wizard;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soda.devicekit.ui.generic.adapter.operation.GenericAdapterOperation;
import org.eclipse.soda.devicekit.ui.generic.adapter.wizard.GenericAdapterMessages;
import org.eclipse.soda.devicekit.ui.generic.adapter.wizard.GenericAdapterPage;
import org.eclipse.soda.devicekit.ui.generic.profile.operation.GenericProfileImplementationOperation;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitPage;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitWizard;
import org.eclipse.ui.INewWizard;

public class GenericAdapterWizard
extends DeviceKitWizard
implements INewWizard {
    protected DeviceKitPage page;

    public GenericAdapterWizard() {
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"generic_adapter_page.jpeg"));
    }

    public void addPages() {
        this.page = this.createPage();
        this.addPage((IWizardPage)this.page);
        this.addSpecPage(this.page.getTitle());
    }

    public DeviceKitPage createPage() {
        String adapter = GenericAdapterMessages.getInstance().getString("adapter");
        return new GenericAdapterPage(adapter);
    }

    protected boolean generateProfile(String profileType, String adapterName, Map variables) {
        Hashtable<String, String> profileMap = new Hashtable<String, String>(variables);
        profileMap.put("profiletype", profileType);
        profileMap.put("genericadapter", adapterName);
        profileMap.put("create.test", "false");
        profileMap.put("create.testagent", "false");
        profileMap.put("create.testcase", "false");
        return this.performFinish(new GenericProfileImplementationOperation(profileMap, this.getFinder()));
    }

    public IWorkspaceRunnable getOperation() {
        Map variables = this.page.getVariables();
        variables.put("create.test", "false");
        variables.put("create.testagent", "false");
        variables.put("create.testcase", "false");
        return new GenericAdapterOperation(variables);
    }

    public String getWizardTitle() {
        return GenericAdapterMessages.getInstance().getString("wizard_title");
    }

    public boolean performFinish() {
        boolean performResult = super.performFinish();
        Map variables = this.page.getVariables();
        String toGenerate = (String)variables.get("generate.profiles");
        if (toGenerate != null && toGenerate.equals("true")) {
            performResult = performResult && this.performGenerateProfiles();
        }
        return performResult;
    }

    protected boolean performGenerateProfiles() {
        String toGenerateBarcode;
        String toGenerateGpio;
        String toGenerateWrite;
        boolean performResult = true;
        Map variables = this.page.getVariables();
        String name = String.valueOf((String)variables.get("name")) + GenericAdapterMessages.getInstance().getString("adapter");
        String toGenerateInventory = (String)variables.get("inventory.profile");
        if (toGenerateInventory != null && toGenerateInventory.equals("true")) {
            boolean bl = performResult = performResult && this.generateProfile("GenericRfidInventoryProfile", name, variables);
        }
        if ((toGenerateWrite = (String)variables.get("write.profile")) != null && toGenerateWrite.equals("true")) {
            boolean bl = performResult = performResult && this.generateProfile("GenericRfidWriteProfile", name, variables);
        }
        if ((toGenerateGpio = (String)variables.get("gpio.profile")) != null && toGenerateGpio.equals("true")) {
            boolean bl = performResult = performResult && this.generateProfile("GenericGpioProfile", name, variables);
        }
        if ((toGenerateBarcode = (String)variables.get("barcode.profile")) != null && toGenerateBarcode.equals("true")) {
            performResult = performResult && this.generateProfile("GenericBarcodeProfile", name, variables);
        }
        return performResult;
    }
}

