/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.model;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.model.ITestSessionListener;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestResultEnum;
import org.eclipse.soda.devicekit.ui.testmanager.view.TestSynchronizationDialog;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.soda.dk.testcontroller.remote.rmi.RemoteControllerLocater;
import org.eclipse.soda.dk.testcontroller.service.ControllerLocaterService;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.service.DistributedTestSessionService;
import org.eclipse.soda.dk.testmanager.service.ScriptRunListenerService;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.eclipse.soda.dk.testmanager.service.TestStatisticsService;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestRunSession {
    public static final DateFormat ISODATEFORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
    IStorage fTestScript;
    private final String fTestRunName;
    final TestSynchronizationDialog testSyncService;
    private final IJavaProject fProject;
    ListenerList fSessionListeners;
    private Document fTestRoot;
    volatile int fStartedCount;
    volatile int fErrorCount;
    volatile int fFailureCount;
    volatile int fPassedCount;
    volatile int fTotalCount;
    volatile long fStartTime;
    volatile boolean fIsRunning;
    volatile boolean fIsStopped;
    TestManager fTestManager;
    private TestJob fTestJob;

    public TestRunSession(String testRunName, TestSynchronizationDialog testSyncService, IJavaProject project) {
        Assert.isNotNull((Object)testRunName);
        this.fProject = null;
        this.testSyncService = testSyncService;
        this.fTestScript = null;
        this.fTestRunName = testRunName;
        this.init();
    }

    public TestRunSession(IStorage testScript, TestSynchronizationDialog testSyncService, IJavaProject project) {
        Assert.isNotNull((Object)testScript);
        this.fTestScript = testScript;
        this.testSyncService = testSyncService;
        this.fProject = project;
        this.fTestRunName = testScript.getFullPath().removeFileExtension().lastSegment();
        this.init();
    }

    private static Document parse(String content) throws Exception {
        return TestRunSession.parse(new StringReader(content), null, null);
    }

    private static Document parse(Reader reader, ErrorHandler errorHandler, Object schemaSource) throws ParserConfigurationException, SAXException, IOException {
        Document document;
        try {
            Document doc;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            if (schemaSource != null) {
                factory.setValidating(true);
                try {
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSource);
                }
                catch (Exception exception) {
                    factory.setValidating(false);
                }
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (errorHandler != null) {
                builder.setErrorHandler(errorHandler);
            }
            document = doc = builder.parse(new InputSource(reader));
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return document;
    }

    public void addEndTime(Element element) {
        element.setAttribute("end", new Date().toString());
    }

    public Element addError(Element element, String message, String trace) {
        Element newElement = this.addElement(element, "error");
        if (trace != null) {
            this.addText(newElement, trace);
        }
        this.addTime(newElement);
        if (message != null) {
            newElement.setAttribute("message", message);
        }
        return newElement;
    }

    public Element addFailure(Element element, String message, String trace) {
        Element newElement = this.addElement(element, "failure");
        this.addTime(newElement);
        if (trace != null) {
            this.addText(newElement, trace);
        }
        if (message != null) {
            newElement.setAttribute("message", message);
        }
        return newElement;
    }

    public void addTestSessionListener(ITestSessionListener listener) {
        this.fSessionListeners.add((Object)listener);
    }

    public void addTime(Element element) {
        element.setAttribute("time", new Date().toString());
    }

    private Document createTestRoot() {
        try {
            Document doc = TestRunSession.parse("<validationTestReport xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"dktest.xsd\">\n</validationTestReport>");
            Element docElement = doc.getDocumentElement();
            docElement.setAttribute("name", this.fTestRunName);
            if (this.fProject != null) {
                docElement.setAttribute("project", this.fProject.getElementName());
            }
            return doc;
        }
        catch (Exception e) {
            TestManagerPlugin.log(e);
            return null;
        }
    }

    public Element[] getAllFailedTestElements() {
        Element root = this.getTestRoot();
        NodeList errorNodes = root.getElementsByTagName("error");
        NodeList failureNodes = root.getElementsByTagName("failure");
        Element[] all = new Element[errorNodes.getLength() + failureNodes.getLength()];
        int i = 0;
        int j = 0;
        while (j < errorNodes.getLength()) {
            all[i++] = (Element)errorNodes.item(j);
            ++j;
        }
        j = 0;
        while (j < failureNodes.getLength()) {
            all[i++] = (Element)failureNodes.item(j);
            ++j;
        }
        return all;
    }

    Document getDocument() {
        return this.fTestRoot;
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    public int getFailureCount() {
        return this.fFailureCount;
    }

    public String getIsoStartTime() {
        return ISODATEFORMAT.format(new Date(this.getStartTime()));
    }

    public int getPassedCount() {
        return this.fPassedCount;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public int getStartedCount() {
        return this.fStartedCount;
    }

    public int getTotalCount() {
        return this.fTotalCount;
    }

    private void init() {
        this.fSessionListeners = new ListenerList();
        this.fTestRoot = this.createTestRoot();
    }

    public IJavaProject getLaunchedProject() {
        return this.fProject;
    }

    public TestResultEnum getTestResult() {
        if (this.fTestRoot == null) {
            return TestResultEnum.UNDEFINED;
        }
        if (this.fErrorCount == 0) {
            return this.fFailureCount == 0 ? TestResultEnum.OK : TestResultEnum.FAILURE;
        }
        return TestResultEnum.ERROR;
    }

    public Element getTestRoot() {
        return this.fTestRoot.getDocumentElement();
    }

    public String getTestRunName() {
        return this.fTestRunName;
    }

    public boolean isRunning() {
        return this.fIsRunning;
    }

    public boolean isStarting() {
        return this.getStartTime() == 0L && this.fTestJob != null && !this.fTestJob.isCanceled();
    }

    public boolean isStopped() {
        if (this.fTestJob != null && this.fTestJob.isCanceled()) {
            this.stopTestRun();
        }
        return this.fIsStopped;
    }

    public void removeTestSessionListener(ITestSessionListener listener) {
        this.fSessionListeners.remove((Object)listener);
    }

    void reset() {
        this.fStartedCount = 0;
        this.fPassedCount = 0;
        this.fFailureCount = 0;
        this.fErrorCount = 0;
        this.fTotalCount = 0;
        this.fTestRoot = this.createTestRoot();
        this.fTestManager = new TestManager();
        this.fTestManager.setLocalControllerLocater((ControllerLocaterService)new RemoteControllerLocater());
    }

    /*
     * Unable to fully structure code
     */
    public void runTest() {
        block3: {
            this.reset();
            try {
                in = new InputStreamReader(this.fTestScript.getContents());
                testScript = this.fTestManager.parse((Reader)in);
                testScript.getAttributes().put("url", this.fTestRunName);
                this.fTestJob = new TestJob(this.fTestRunName, testScript);
                this.fTestJob.schedule();
                break block3;
            }
            catch (Exception e) {
                ++this.fErrorCount;
                message = TestManagerMessages.format(TestManagerMessages.TestRunSession_Test_start_error_dialog_message, this.fTestRunName);
                error = this.addError(this.getTestRoot(), message, e.getLocalizedMessage());
                listeners = this.fSessionListeners.getListeners();
                i = 0;
                ** while (i < listeners.length)
            }
lbl-1000:
            // 1 sources

            {
                listener = (ITestSessionListener)listeners[i];
                listener.sessionStarted();
                listener.activityFailed(error);
                listener.sessionEnded(0L);
                ++i;
                continue;
            }
lbl23:
            // 1 sources

            status = new Status(4, "org.eclipse.ui", 0, e.getLocalizedMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)TestManagerPlugin.getActiveWorkbenchShell(), (String)TestManagerMessages.TestRunSession_Test_start_error_dialog_title, (String)message, (IStatus)status);
        }
    }

    void setDocument(Document testRoot) {
        String pathName;
        this.fTestRoot = testRoot;
        String startTime = testRoot.getDocumentElement().getAttribute("startTime");
        if (startTime.length() > 0) {
            try {
                this.fStartTime = ISODATEFORMAT.parse(startTime).getTime();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if ((pathName = testRoot.getDocumentElement().getAttribute("testScript")).length() > 0) {
            IPath path = Path.fromPortableString((String)pathName);
            this.fTestScript = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
    }

    public void stopTestRun() {
        if (this.isRunning()) {
            this.fIsStopped = true;
            if (this.fTestJob != null) {
                this.fTestJob.interrupt();
            }
        }
    }

    public Element addElement(Element parent, String tagName, Object content) {
        Element newElement = this.addElement(parent, tagName);
        this.addText(newElement, content);
        return newElement;
    }

    public Element addElement(Element parent, String tagName) {
        Document doc = this.fTestRoot;
        Element newElement = doc.createElement(tagName);
        parent.appendChild(newElement);
        parent.appendChild(doc.createTextNode("\n"));
        return newElement;
    }

    public void addStartTime(Element element) {
        element.setAttribute("start", new Date().toString());
    }

    public Text addText(Element parent, Object content) {
        Text newText = this.fTestRoot.createTextNode(content.toString());
        parent.appendChild(newText);
        return newText;
    }

    private class TestJob
    extends Job {
        private TestScriptService testScript;
        private TestRunListener testReport;
        private DistributedTestSessionService distributedTestSession;
        private IProgressMonitor monitor;

        public TestJob(String name, TestScriptService testScript) {
            super(name);
            this.testScript = testScript;
            this.setUser(true);
        }

        public void interrupt() {
            this.cancel();
            TestRunSession.this.testSyncService.interrupt();
            if (this.distributedTestSession != null) {
                this.distributedTestSession.interrupt();
            }
        }

        public boolean isCanceled() {
            return this.monitor != null && this.monitor.isCanceled();
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.monitor = monitor;
            this.testReport = new TestRunListener(monitor);
            this.distributedTestSession = TestRunSession.this.fTestManager.createDistributedTestSession((TestSynchronizationService)TestRunSession.this.testSyncService, (TestRunListenerService)this.testReport);
            try {
                this.testScript.run(this.distributedTestSession, (ScriptRunListenerService)this.testReport, false);
            }
            catch (Exception e) {
                String message = TestManagerMessages.format(TestManagerMessages.TestRunSession_Test_run_failed_message, this.getName());
                return new Status(4, "org.eclipse.soda.devicekit.ui.testmanager", 4, message, (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    public class TestRunListener
    implements ScriptRunListenerService,
    TestRunListenerService {
        private boolean finished;
        private Map actionRuns;
        private Map testRuns;
        private Map testCaseRuns;
        private Set testCaseFailed;
        private IProgressMonitor monitor;

        public TestRunListener(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        private void addOptionalElement(Element parent, String tagName, Object content) {
            if (content != null) {
                Element newElement = TestRunSession.this.addElement(parent, tagName, content);
                this.notifyActivityStarted(newElement);
            }
        }

        private String getTestcaseKey(String runId, String testName) {
            String testcaseKey = String.valueOf(runId) + '/' + testName;
            return testcaseKey;
        }

        public boolean isFinished() {
            return this.finished;
        }

        private void notifyActivityEnded(Element activityRun) {
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).activityEnded(activityRun);
                ++i;
            }
        }

        private void notifyActivityFailed(Element activityRun, String trace) {
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).activityFailed(activityRun);
                ++i;
            }
        }

        private void notifyActivityStarted(Element activityRun) {
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).activityStarted(activityRun);
                ++i;
            }
        }

        public void scriptActionEnded(String actionId, String message) {
            Element actionRun = (Element)this.actionRuns.get(actionId);
            if (actionRun != null) {
                TestRunSession.this.addText(actionRun, message);
                TestRunSession.this.addEndTime(actionRun);
                this.notifyActivityEnded(actionRun);
            }
        }

        public void scriptActionError(String actionId, String message, String detail) {
            ++TestRunSession.this.fErrorCount;
            Element actionRun = (Element)this.actionRuns.get(actionId);
            if (actionRun != null) {
                TestRunSession.this.addError(actionRun, message, detail);
                this.notifyActivityFailed(actionRun, detail);
            }
        }

        public void scriptActionInfo(String actionId, String message) {
            ++TestRunSession.this.fStartedCount;
            this.monitor.worked(1);
            Element actionRun = (Element)this.actionRuns.get(actionId);
            if (actionRun != null) {
                Element info = TestRunSession.this.addElement(actionRun, "info");
                TestRunSession.this.addText(info, message);
                TestRunSession.this.addTime(info);
            }
        }

        public void scriptActionStarted(String parentActionId, String actionId, String message) {
            this.monitor.subTask(message);
            Element parent = parentActionId != null ? (Element)this.actionRuns.get(parentActionId) : TestRunSession.this.getTestRoot();
            if (parent != null) {
                Element actionRun = TestRunSession.this.addElement(parent, "actionRun");
                actionRun.setAttribute("id", actionId);
                TestRunSession.this.addText(actionRun, message);
                TestRunSession.this.addStartTime(actionRun);
                this.actionRuns.put(actionId, actionRun);
                this.notifyActivityStarted(actionRun);
            }
        }

        public void scriptRunEnded(TestStatisticsService testStatistics) {
            Element root = TestRunSession.this.getTestRoot();
            if (this.monitor.isCanceled()) {
                ++TestRunSession.this.fErrorCount;
                Element error = TestRunSession.this.addError(root, TestManagerMessages.TestRunSession_Interrupted, TestManagerMessages.TestRunSession_TestRunInterrupted);
                this.notifyActivityFailed(error, null);
            }
            Element stats = TestRunSession.this.addElement(root, "reportStatistics");
            this.addOptionalElement(stats, "scriptErrors", testStatistics.getValue("TEST_SCRIPT_ERROR_COUNT"));
            this.addOptionalElement(stats, "actionCount", testStatistics.getValue("CONFIGURATION_COUNT"));
            this.addOptionalElement(stats, "actionErrors", testStatistics.getValue("CONFIGURATION_ERROR_COUNT"));
            this.addOptionalElement(stats, "testCount", testStatistics.getValue("TEST_COUNT"));
            this.addOptionalElement(stats, "testErrors", testStatistics.getValue("TEST_ERROR_COUNT"));
            this.addOptionalElement(stats, "testcaseCount", testStatistics.getValue("TEST_CASE_COUNT"));
            this.addOptionalElement(stats, "testcaseErrors", testStatistics.getValue("TEST_CASE_ERROR_COUNT"));
            this.addOptionalElement(stats, "testcaseFailures", testStatistics.getValue("TEST_CASE_FAILED_COUNT"));
            this.notifyActivityEnded(stats);
            TestRunSession.this.fIsRunning = false;
            long elapsedTime = System.currentTimeMillis() - TestRunSession.this.fStartTime;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionEnded(elapsedTime);
                ++i;
            }
            this.actionRuns = null;
            this.testRuns = null;
            this.testCaseRuns = null;
            this.testCaseFailed = null;
        }

        public void scriptRunError(String message, String trace) {
            ++TestRunSession.this.fErrorCount;
            Element root = TestRunSession.this.getTestRoot();
            TestRunSession.this.addError(root, message, trace);
            this.notifyActivityFailed(root, trace);
        }

        public void scriptRunStarted(TestScriptService script) {
            int configActionCount = script.getTestStatistics().getCount("CONFIGURATION_COUNT");
            int testActionCount = script.getTestStatistics().getCount("TEST_COUNT");
            TestRunSession.this.fTotalCount = configActionCount + testActionCount;
            TestRunSession.this.fStartTime = System.currentTimeMillis();
            TestRunSession.this.getTestRoot().setAttribute("startTime", TestRunSession.this.getIsoStartTime());
            TestRunSession.this.getTestRoot().setAttribute("testScript", TestRunSession.this.fTestScript.getFullPath().toPortableString());
            TestRunSession.this.fIsRunning = true;
            this.actionRuns = Collections.synchronizedMap(new HashMap());
            this.testRuns = Collections.synchronizedMap(new HashMap());
            this.testCaseRuns = Collections.synchronizedMap(new HashMap());
            this.testCaseFailed = Collections.synchronizedSet(new HashSet());
            this.monitor.beginTask(TestManagerMessages.format(TestManagerMessages.TestRunSession_RunningScript, script.getAttributes().get("title")), TestRunSession.this.fTotalCount);
            Element root = TestRunSession.this.getTestRoot();
            this.addOptionalElement(root, "title", script.getAttributes().get("title"));
            this.addOptionalElement(root, "version", script.getAttributes().get("version"));
            this.addOptionalElement(root, "vendor", script.getAttributes().get("vendor"));
            this.addOptionalElement(root, "description", script.getAttributes().get("description"));
            this.addOptionalElement(root, "url", script.getAttributes().get("url"));
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionStarted();
                ++i;
            }
        }

        public void testEnded(String runId, String testName) {
            ++TestRunSession.this.fPassedCount;
            this.monitor.subTask(TestManagerMessages.format(TestManagerMessages.TestRunSession_TestRunId, runId));
            String testcaseKey = this.getTestcaseKey(runId, testName);
            Element testcaseRun = (Element)this.testCaseRuns.get(testcaseKey);
            if (testcaseRun != null) {
                TestRunSession.this.addEndTime(testcaseRun);
                this.notifyActivityEnded(testcaseRun);
            }
        }

        public void testError(String runId, String testName, String trace) {
            ++TestRunSession.this.fErrorCount;
            String testcaseKey = this.getTestcaseKey(runId, testName);
            this.testCaseFailed.add(testcaseKey);
            Element testcaseRun = (Element)this.testCaseRuns.get(testcaseKey);
            if (testcaseRun != null) {
                TestRunSession.this.addError(testcaseRun, null, trace);
                this.notifyActivityFailed(testcaseRun, trace);
            }
        }

        public void testFailed(String runId, String testName, String trace) {
            ++TestRunSession.this.fFailureCount;
            String testcaseKey = this.getTestcaseKey(runId, testName);
            this.testCaseFailed.add(testcaseKey);
            Element testcaseRun = (Element)this.testCaseRuns.get(testcaseKey);
            if (testcaseRun != null) {
                TestRunSession.this.addFailure(testcaseRun, null, trace);
                this.notifyActivityFailed(testcaseRun, trace);
            }
        }

        public void testRunEnded(String runId) {
            Element testRun = (Element)this.testRuns.get(runId);
            if (testRun != null) {
                TestRunSession.this.addEndTime(testRun);
                this.notifyActivityEnded(testRun);
            }
        }

        public void testRunError(String runId, String message, String detail) {
            ++TestRunSession.this.fErrorCount;
            Element testRun = (Element)this.testRuns.get(runId);
            if (testRun != null) {
                TestRunSession.this.addError(testRun, message, detail);
                this.notifyActivityFailed(testRun, detail);
            }
        }

        public void testRunStarted(String actionId, String runId) {
            this.monitor.subTask(TestManagerMessages.format(TestManagerMessages.TestRunSession_TestRunId, runId));
            Element actionRun = (Element)this.actionRuns.get(actionId);
            if (actionRun != null) {
                Element testRun = TestRunSession.this.addElement(actionRun, "testRun");
                this.testRuns.put(runId, testRun);
                testRun.setAttribute("id", runId);
                TestRunSession.this.addStartTime(testRun);
                this.notifyActivityStarted(testRun);
            }
        }

        public void testStarted(String runId, String testName) {
            this.monitor.subTask(TestManagerMessages.format(TestManagerMessages.TestRunSession_TestRunIdName, new Object[]{runId, testName}));
            Element testRun = (Element)this.testRuns.get(runId);
            if (testRun != null) {
                Element testcaseRun = TestRunSession.this.addElement(testRun, "testcaseRun");
                this.testCaseRuns.put(this.getTestcaseKey(runId, testName), testcaseRun);
                testcaseRun.setAttribute("testName", testName);
                TestRunSession.this.addStartTime(testcaseRun);
                this.notifyActivityStarted(testcaseRun);
            }
        }
    }
}

