/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.samples.wizard;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SwtDebugUtility {
    private static final Color[] COLORS = new Color[]{SwtDebugUtility.getSystemColor(3), SwtDebugUtility.getSystemColor(9), SwtDebugUtility.getSystemColor(7), SwtDebugUtility.getSystemColor(5), SwtDebugUtility.getSystemColor(13), SwtDebugUtility.getSystemColor(11), SwtDebugUtility.getSystemColor(4), SwtDebugUtility.getSystemColor(10), SwtDebugUtility.getSystemColor(8), SwtDebugUtility.getSystemColor(6), SwtDebugUtility.getSystemColor(14), SwtDebugUtility.getSystemColor(12)};
    private static final SwtDebugUtility INSTANCE = new SwtDebugUtility();

    private SwtDebugUtility() {
    }

    public static SwtDebugUtility getInstance() {
        return INSTANCE;
    }

    private static Color getSystemColor(int id) {
        Display device = Display.getDefault();
        Color color = device.getSystemColor(id);
        return color;
    }

    public static void setBackground(Control control, int id) {
        Color color = SwtDebugUtility.getSystemColor(id);
        control.setBackground(color);
    }

    private String createFormDataToolTip(StringBuffer buffer, FormData data) {
        buffer.append("FormData...");
        buffer.append("\r\n    bottom=");
        buffer.append(data.bottom);
        buffer.append("\r\n    height=");
        buffer.append(data.height);
        buffer.append("\r\n    left=");
        buffer.append(data.left);
        buffer.append("\r\n    right=");
        buffer.append(data.right);
        buffer.append("\r\n    top=");
        buffer.append(data.top);
        buffer.append("\r\n    width=");
        buffer.append(data.width);
        String tip = buffer.toString();
        return tip;
    }

    private String createGridDataToolTip(StringBuffer buffer, GridData gridData) {
        buffer.append("GridData...");
        buffer.append("\r\n    grabExcessHorizontalSpace=");
        buffer.append(gridData.grabExcessHorizontalSpace);
        buffer.append("\r\n    grabExcessVerticalSpace=");
        buffer.append(gridData.grabExcessVerticalSpace);
        buffer.append("\r\n    heightHint=");
        buffer.append(gridData.heightHint);
        buffer.append("\r\n    horizontalAlignment=");
        buffer.append(this.getAlignmentText(gridData.horizontalAlignment));
        buffer.append("\r\n    horizontalIndent=");
        buffer.append(gridData.horizontalIndent);
        buffer.append("\r\n    horizontalSpan=");
        buffer.append(gridData.horizontalSpan);
        buffer.append("\r\n    verticalAlignment=");
        buffer.append(this.getAlignmentText(gridData.verticalAlignment));
        buffer.append("\r\n    verticalSpan=");
        buffer.append(gridData.verticalSpan);
        buffer.append("\r\n    widthHint=");
        buffer.append(gridData.widthHint);
        String tip = buffer.toString();
        return tip;
    }

    private String createToolTip(Control control, int childIndex) {
        StringBuffer buffer = new StringBuffer(750);
        if (childIndex != 0) {
            buffer.append(childIndex);
            buffer.append(". ");
        }
        buffer.append(control);
        buffer.append(this.getHashCodeText(control));
        if (childIndex != 0) {
            buffer.append("\r\n  parent=");
            Composite parent = control.getParent();
            buffer.append(parent);
            buffer.append(this.getHashCodeText(parent));
        }
        buffer.append("\r\n  border width=");
        buffer.append(control.getBorderWidth());
        buffer.append("\r\n  bounds=");
        buffer.append(control.getBounds());
        buffer.append("\r\n  data=");
        buffer.append(control.getData());
        buffer.append("\r\n  font=");
        Font font = control.getFont();
        FontData[] fontData = font.getFontData();
        buffer.append(fontData[0]);
        buffer.append("\r\n  size=");
        buffer.append(control.getSize());
        buffer.append("\r\n  layout data=");
        Object layoutData = control.getLayoutData();
        if (layoutData != null) {
            if (layoutData instanceof GridData) {
                GridData gridData = (GridData)layoutData;
                this.createGridDataToolTip(buffer, gridData);
            } else if (layoutData instanceof FormData) {
                FormData formData = (FormData)layoutData;
                this.createFormDataToolTip(buffer, formData);
            } else {
                buffer.append(layoutData);
            }
        } else {
            buffer.append("null");
        }
        buffer.append("\r\n  style=");
        buffer.append(control.getStyle());
        String tip = buffer.toString();
        return tip;
    }

    public void decorate(Control control) {
        this.decorate(control, 0, 0);
    }

    private void decorate(Control control, int colorIndex, int childIndex) {
        int count = COLORS.length;
        int index = colorIndex;
        if (colorIndex == count) {
            index = 0;
        }
        Color color = COLORS[index];
        control.setBackground(color);
        String tip = this.createToolTip(control, childIndex);
        control.setToolTipText(tip);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                this.decorate(child, index + 1, i + 1);
                ++i;
            }
        }
    }

    private String getAlignmentText(int alignment) {
        String text = null;
        switch (alignment) {
            case 1: {
                text = "BEGINNING";
                break;
            }
            case 2: {
                text = "CENTER";
                break;
            }
            case 3: {
                text = "END";
                break;
            }
            case 4: {
                text = "FILL";
                break;
            }
            default: {
                text = Integer.toString(alignment);
            }
        }
        return text;
    }

    private String getHashCodeText(Object object) {
        long hashCode = object.hashCode();
        String result = String.valueOf('(') + Long.toHexString(hashCode) + ')';
        return result;
    }
}

