/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.visitor;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.preference.DeviceKitPreferenceInitializer;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;

public class Visitor
extends ASTVisitor
implements Comparator {
    protected String[] references = null;
    private long thisCount = 0L;
    private long superCount = 0L;
    private long throwCount = 0L;
    private String logMember = "";
    protected CompilationUnit compilationUnitNode;
    protected TypeDeclaration typeDeclarationNode;
    private String source = "";
    private int current = 0;
    private boolean pseudo = false;
    protected boolean copyrightFound = false;
    private StringWriter stringWriter = new StringWriter();
    private PrintWriter printWriter = null;
    protected boolean endOfStatement = false;
    int indentLevel = 0;
    boolean newLine = true;
    private String packageName = "";
    protected ICompilationUnit compilationUnit;

    public static int containsCopyright(String data) {
        int createYear = -1;
        int currentYear = Calendar.getInstance().get(1);
        String oldString = new String(data);
        StringTokenizer tokenizer = new StringTokenizer(oldString, " ,", true);
        String previousToken = "";
        while (tokenizer.hasMoreTokens()) {
            int temp;
            String createYearMaybe;
            String token = tokenizer.nextToken();
            String lcToken = token.toLowerCase();
            if ("copyright".equals(lcToken)) {
                createYear = 0;
            } else if (",".equals(token)) {
                try {
                    createYearMaybe = previousToken;
                    temp = Integer.parseInt(createYearMaybe);
                    if (temp <= currentYear && temp > 1980) {
                        createYear = temp;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ("All".equals(token) || "IBM".equals(token)) {
                if (createYear < 1980) {
                    try {
                        createYearMaybe = previousToken;
                        temp = Integer.parseInt(createYearMaybe);
                        if (temp <= currentYear && temp > 1980) {
                            createYear = temp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if ("(c)".equals(token) && createYear < 1980) {
                try {
                    tokenizer.nextToken();
                    createYearMaybe = tokenizer.nextToken();
                    temp = Integer.parseInt(createYearMaybe);
                    if (temp <= currentYear && temp > 1980) {
                        createYear = temp;
                    }
                }
                catch (Exception exception) {}
            }
            if (lcToken.endsWith("*/")) break;
            if (" ".equals(token) || ",".equals(token)) continue;
            previousToken = token;
        }
        return createYear;
    }

    public static int getCreateYear(IFile file) {
        block27: {
            IFileHistoryProvider fileHistoryProvider;
            RepositoryProvider repositoryProvider;
            int currentYear = Calendar.getInstance().get(1);
            try {
                InputStream is = file.getContents(true);
                String data = new String(Visitor.readData(is));
                int createYear = Visitor.containsCopyright(data);
                if (createYear > 1970 && createYear != currentYear) {
                    return createYear;
                }
            }
            catch (Exception exception) {}
            try {
                IFileState[] fileStates = file.getHistory((IProgressMonitor)new NullProgressMonitor());
                int i = fileStates.length - 1;
                while (i >= 0) {
                    try {
                        InputStream is2 = fileStates[i].getContents();
                        String data2 = new String(Visitor.readData(is2));
                        int createYear = Visitor.containsCopyright(data2);
                        if (createYear > 1970 && createYear < currentYear) {
                            return createYear;
                        }
                        is2.close();
                    }
                    catch (Exception exception) {}
                    --i;
                }
            }
            catch (Exception exception) {}
            IProject project = file.getProject();
            boolean isShared = RepositoryProvider.isShared((IProject)project);
            if (isShared && (repositoryProvider = RepositoryProvider.getProvider((IProject)project)) != null && (fileHistoryProvider = repositoryProvider.getFileHistoryProvider()) instanceof CVSFileHistoryProvider) {
                try {
                    IFileRevision[] fileRevisions;
                    IFileHistory fileHistory;
                    block26: {
                        Subscriber subscriber = repositoryProvider.getSubscriber();
                        SyncInfo syncInfo = subscriber.getSyncInfo((IResource)file);
                        IResourceVariant remote = syncInfo.getRemote();
                        if (remote instanceof RemoteFile) {
                            RemoteFile remoteFile = (RemoteFile)remote;
                            ICVSFolder remoteParent = remoteFile.getParent();
                            try {
                                CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(remoteParent, 1);
                                if (tags == null) break block26;
                                int i = 0;
                                while (i < tags.length) {
                                    ICVSRemoteResource remoteFileBranch = remoteFile.forTag(tags[i]);
                                    if (remoteFileBranch instanceof RemoteFile) {
                                        RemoteFile file3 = (RemoteFile)remoteFileBranch;
                                        InputStream is3 = file3.getContents();
                                        String data3 = new String(Visitor.readData(is3));
                                        try {
                                            is3.close();
                                        }
                                        catch (Exception exception) {}
                                        int createYear = Visitor.containsCopyright(data3);
                                        if (createYear > 1970 && createYear < currentYear) {
                                            return createYear;
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    if ((fileHistory = fileHistoryProvider.getFileHistoryFor((IResource)file, 0, (IProgressMonitor)new NullProgressMonitor())) == null || (fileRevisions = fileHistory.getFileRevisions()) == null) break block27;
                    int i = 0;
                    while (i < fileRevisions.length) {
                        try {
                            IStorage storage = fileRevisions[i].getStorage((IProgressMonitor)new NullProgressMonitor());
                            InputStream is4 = storage.getContents();
                            String data4 = new String(Visitor.readData(is4));
                            try {
                                is4.close();
                            }
                            catch (Exception exception) {}
                            int createYear = Visitor.containsCopyright(data4);
                            if (createYear > 1970 && createYear < currentYear) {
                                return createYear;
                            }
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return -1;
    }

    public static byte[] readData(InputStream fin) throws Exception {
        int size = fin.available();
        byte[] data = new byte[size];
        int index = 0;
        int sizeLeft = size;
        while (sizeLeft != 0) {
            index += fin.read(data, index, sizeLeft);
            sizeLeft = size - index;
        }
        fin.close();
        return data;
    }

    public String addBlanks(String data) {
        StringBuffer buffer = new StringBuffer();
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (!last && upper) {
                buffer.append(' ');
            }
            buffer.append(character);
            last = upper;
            ++i;
        }
        return buffer.toString();
    }

    public void check(FieldDeclaration node) {
        boolean check = true;
        if (this.logMember.endsWith("Device") || this.logMember.endsWith("DeviceService")) {
            check = false;
        }
        if (check) {
            int modifiers = node.getModifiers();
            Iterator it = node.fragments().iterator();
            while (it.hasNext()) {
                VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
                SimpleName fieldSimpleName = f.getName();
                String simple = fieldSimpleName.getIdentifier();
                if (Modifier.isStatic((int)modifiers)) {
                    if (Modifier.isFinal((int)modifiers)) {
                        if (simple.toUpperCase().equals(simple)) continue;
                        this.logWarning("Code", "static final field not uppercase " + simple);
                        continue;
                    }
                    if (Character.isUpperCase(simple.charAt(0))) continue;
                    this.logWarning("Code", "static field first char not uppercase " + simple);
                    continue;
                }
                if (!Character.isUpperCase(simple.charAt(0))) continue;
                this.logWarning("Code", "field first char not lowercase " + simple);
            }
        }
    }

    public void checkCopyright(ASTNode node) {
        String comment = this.getMissingComments(node, true);
        int createYear = Visitor.containsCopyright(comment);
        if (createYear < 1970 || createYear == Calendar.getInstance().get(1)) {
            createYear = this.getCreateYear();
        }
        String copyright = GeneratorTemplates.getCopyrightCodeString(GeneratorTemplates.getTemplateVariables(createYear));
        if (comment.length() > 0) {
            boolean printComment = true;
            if (!this.copyrightFound) {
                if (createYear == -1) {
                    try {
                        this.println(copyright);
                        printComment = false;
                        this.copyrightFound = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        this.println(copyright);
                        this.copyrightFound = true;
                        printComment = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (printComment) {
                this.printComment(comment);
            }
        } else if (createYear == -1) {
            try {
                this.println(copyright);
                this.copyrightFound = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int compare(Object arg0, Object arg1) {
        int type1;
        ASTNode body0 = (ASTNode)arg0;
        ASTNode body1 = (ASTNode)arg1;
        int type0 = body0.getNodeType();
        if (type0 == (type1 = body1.getNodeType())) {
            switch (type0) {
                case 23: {
                    FieldDeclaration field0 = (FieldDeclaration)arg0;
                    FieldDeclaration field1 = (FieldDeclaration)arg1;
                    int mod0 = field0.getModifiers();
                    int mod1 = field1.getModifiers();
                    if (Modifier.isStatic((int)mod0)) {
                        if (Modifier.isStatic((int)mod1)) {
                            if (Modifier.isFinal((int)mod0)) {
                                return -1;
                            }
                            if (Modifier.isFinal((int)mod1)) {
                                return 1;
                            }
                        }
                        return -1;
                    }
                    if (Modifier.isStatic((int)mod1)) {
                        return 1;
                    }
                    return 0;
                }
                case 31: {
                    MethodDeclaration method0 = (MethodDeclaration)arg0;
                    MethodDeclaration method1 = (MethodDeclaration)arg1;
                    int mod0 = method0.getModifiers();
                    int mod1 = method1.getModifiers();
                    if (method0.isConstructor()) {
                        if (!method1.isConstructor()) {
                            return -1;
                        }
                    } else if (method1.isConstructor()) {
                        return 1;
                    }
                    if (Modifier.isStatic((int)mod0)) {
                        if (!Modifier.isStatic((int)mod1)) {
                            return -1;
                        }
                    } else if (Modifier.isStatic((int)mod1)) {
                        return 1;
                    }
                    return method0.getName().getIdentifier().compareTo(method1.getName().getIdentifier());
                }
            }
        } else {
            switch (type0) {
                case 28: 
                case 55: {
                    return -1;
                }
                case 31: {
                    if (type1 == 23) {
                        return 1;
                    }
                }
                case 23: {
                    if (type1 != 28) break;
                    return 1;
                }
                default: {
                    throw new RuntimeException(Integer.toString(type0));
                }
            }
            return -1;
        }
        return 0;
    }

    public StringWriter createStringWriter() {
        return new StringWriter(40960);
    }

    public void generateJavadoc(FieldDeclaration node, Map table) {
        Object value;
        int tsize = table.size();
        this.println("\t/**");
        if (tsize == 0) {
            Type type = node.getType();
            String typeName = type.toString();
            ITypeBinding btype = type.resolveBinding();
            if (btype != null) {
                typeName = btype.getName();
            }
            if (!"void".equals(typeName)) {
                int modifiers = node.getModifiers();
                this.print("\t * Define the ");
                Iterator it = node.fragments().iterator();
                while (it.hasNext()) {
                    VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
                    SimpleName fieldSimpleName = f.getName();
                    String simple = fieldSimpleName.getIdentifier();
                    String betterName = this.parameterName(simple, false);
                    this.print(betterName);
                    if (it.hasNext()) {
                        this.print(", ");
                    }
                    if (Modifier.isStatic((int)modifiers)) {
                        if (Modifier.isFinal((int)modifiers)) {
                            if (simple.toUpperCase().equals(simple)) continue;
                            this.logWarning("Code", "static final field not upper case " + simple);
                            continue;
                        }
                        if (Character.isUpperCase(simple.charAt(0))) continue;
                        this.logWarning("Code", "static field first char not upper case " + simple);
                        continue;
                    }
                    if (!Character.isUpperCase(simple.charAt(0))) continue;
                    this.logWarning("Code", "field first char not lowercase " + simple);
                }
                this.print(" (");
                this.print(typeName);
                this.print(") ");
                if (Modifier.isStatic((int)modifiers) && Modifier.isFinal((int)modifiers)) {
                    this.print("constant.");
                } else {
                    this.print("field.");
                }
                this.println();
            }
        } else {
            int modifiers;
            List vector;
            int size;
            value = table.get("@lines");
            if (value instanceof List && (size = (vector = (List)value).size()) > 0) {
                int i = 0;
                while (i < size) {
                    this.print("\t ");
                    this.println(vector.get(i));
                    ++i;
                }
            }
            if (Modifier.isStatic((int)(modifiers = node.getModifiers()))) {
                Modifier.isFinal((int)modifiers);
            }
        }
        if ((value = table.get("@nooverride")) != null) {
            this.println(value);
        }
        if ((value = table.get("@noreference")) != null) {
            this.println(value);
        }
        if ((value = table.get("@category")) != null) {
            this.println(value);
        }
        if ((value = table.get("@since")) != null) {
            this.println(value);
        }
        this.println("\t */");
    }

    public void generateJavadoc(MethodDeclaration node, Map table) {
        String betterName;
        String propertyName = "";
        Type type = node.getReturnType2();
        String typeName = "void";
        if (type != null) {
            typeName = type.toString();
            ITypeBinding btype = type.resolveBinding();
            if (btype != null) {
                typeName = btype.getName();
            }
        }
        this.println("\t/**");
        SimpleName simpleMethodName = node.getName();
        String methodName = simpleMethodName.getIdentifier();
        int numberParameters = node.parameters().size();
        boolean firstFlag = false;
        Object value = table.get("@lines");
        if (value instanceof List) {
            List vector = (List)value;
            int size = vector.size();
            int outputCount = 0;
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    StringBuffer buffer;
                    boolean ok = true;
                    String outputLine = vector.get(i).toString();
                    if (outputLine.startsWith("* @return")) {
                        if (node.isConstructor()) {
                            ok = false;
                        }
                        if ("void".equals(typeName)) {
                            ok = false;
                        }
                        ok = false;
                    } else if (outputLine.startsWith("* @param")) {
                        ok = false;
                    } else if (outputLine.startsWith("* Gets the ")) {
                        buffer = new StringBuffer(64);
                        buffer.append("* Gets the ");
                        betterName = this.parameterName(methodName.substring(3), false);
                        buffer.append(betterName);
                        if (outputLine.toLowerCase().startsWith(buffer.toString().toLowerCase())) {
                            ok = false;
                        }
                    } else if (outputLine.startsWith("* Sets the ")) {
                        buffer = new StringBuffer(64);
                        buffer.append("* Sets the ");
                        betterName = this.parameterName(methodName.substring(3), false);
                        buffer.append(betterName);
                        if (outputLine.toLowerCase().startsWith(buffer.toString().toLowerCase())) {
                            ok = false;
                        }
                    }
                    if (outputLine.endsWith(">) parameter.")) {
                        ok = false;
                    }
                    if (ok) {
                        this.print("\t ");
                        this.println(outputLine);
                        ++outputCount;
                    }
                    ++i;
                }
                if (outputCount > 0) {
                    firstFlag = true;
                }
            }
        }
        if (!firstFlag) {
            if (node.isConstructor()) {
                if (numberParameters == 0) {
                    this.println("\t * Constructs an instance of this class.");
                } else {
                    this.print("\t * Constructs an instance of this class from the specified ");
                    this.generateParameterList(node);
                    if (numberParameters == 1) {
                        this.println(" parameter.");
                    } else {
                        this.println(" parameters.");
                    }
                }
            } else {
                boolean output = false;
                switch (numberParameters) {
                    case 0: {
                        String betterName2;
                        if (methodName.startsWith("get")) {
                            String betterName3;
                            if (typeName.equals("void")) break;
                            this.print("\t * Gets the ");
                            propertyName = betterName3 = this.parameterName(methodName.substring(3), false);
                            this.print(betterName3);
                            if (typeName.equals(methodName.substring(3))) {
                                this.println(" value.");
                            } else {
                                this.print(" (");
                                this.print(typeName);
                                this.println(") value.");
                            }
                            output = true;
                            break;
                        }
                        if (typeName.equals("boolean")) {
                            String betterName4;
                            if (methodName.startsWith("is")) {
                                String betterName5;
                                this.print("\t * Gets the ");
                                propertyName = betterName5 = this.parameterName(methodName.substring(2), false);
                                this.print(betterName5);
                                this.println(" (boolean) value.");
                                output = true;
                                break;
                            }
                            if (!methodName.startsWith("has")) break;
                            this.print("\t * Gets the ");
                            propertyName = betterName4 = this.parameterName(methodName.substring(3), false);
                            this.print(betterName4);
                            this.println(" (boolean) value.");
                            output = true;
                            break;
                        }
                        if (!methodName.startsWith("to")) break;
                        this.print("\t * Returns the ");
                        propertyName = betterName2 = this.parameterName(methodName.substring(2), false);
                        this.print(betterName2);
                        if (typeName.equals(methodName.substring(2))) {
                            this.println(" value.");
                        } else {
                            this.print(" (");
                            this.print(typeName);
                            this.println(") value.");
                        }
                        output = true;
                        break;
                    }
                    case 1: {
                        String betterName6;
                        if (!methodName.startsWith("set")) break;
                        this.print("\t * Sets the ");
                        propertyName = betterName6 = this.parameterName(methodName.substring(3), false);
                        this.print(betterName6);
                        this.println(" value.");
                        output = true;
                        break;
                    }
                }
                if (!output) {
                    this.print("\t * ");
                    String bmethod = this.methodName(methodName, true);
                    this.print(bmethod);
                    if (numberParameters > 0) {
                        this.print(" with the specified ");
                        this.generateParameterList(node);
                        if (numberParameters == 1) {
                            this.print(" parameter");
                        } else {
                            this.print(" parameters");
                        }
                    }
                    if (!"void".equals(typeName)) {
                        this.print(" and return the ");
                        this.print(typeName);
                        this.print(" result");
                    }
                    this.println('.');
                }
            }
        }
        value = table.get("@param");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            SimpleName parameterName = v.getName();
            value = table.get(parameterName.getIdentifier());
            int count = 0;
            if (value != null) {
                StringTokenizer tokenizer = new StringTokenizer(value.toString(), " ");
                count = tokenizer.countTokens();
            }
            if (count <= 3) {
                this.print("\t * @param ");
                Type ptype = v.getType();
                String ptypeName = ptype.toString();
                ITypeBinding brtype = ptype.resolveBinding();
                if (brtype != null) {
                    ptypeName = brtype.getName();
                }
                this.println(parameterName.getIdentifier());
                betterName = this.parameterName(parameterName.toString(), false);
                this.print("\t *\t\tThe ");
                this.print(betterName);
                this.print(" (<code>");
                this.print(ptypeName);
                this.print("</code>) parameter");
                this.print('.');
                this.println();
                continue;
            }
            this.print(' ');
            this.println(value);
        }
        value = table.get("@return");
        if (!node.isConstructor() && !"void".equals(typeName)) {
            if (value == null) {
                this.print("\t * @return ");
                if (propertyName.length() > 0) {
                    this.print("The ");
                    this.print(propertyName);
                    this.print(" (<code>");
                    this.print(typeName);
                    this.print("</code>) value");
                } else {
                    this.print("Results of the ");
                    String bmethod = this.methodName(methodName, false);
                    this.print(bmethod);
                    this.print(" (<code>");
                    this.print(typeName);
                    this.print("</code>) value");
                }
                this.print('.');
                this.println();
            } else {
                this.print(' ');
                this.println(value);
            }
        }
        value = table.get("@throws");
        if (!node.thrownExceptions().isEmpty()) {
            it = node.thrownExceptions().iterator();
            while (it.hasNext()) {
                Object throwDesc;
                Name n = (Name)it.next();
                String exceptionName = n.toString();
                IBinding etype = n.resolveBinding();
                if (etype != null) {
                    exceptionName = etype.getName();
                }
                if ((throwDesc = table.get(exceptionName)) != null) {
                    this.print(' ');
                    this.println(throwDesc.toString());
                    continue;
                }
                this.print("\t * @throws ");
                this.print(exceptionName);
                String betterName7 = this.addBlanks(exceptionName);
                this.print(' ');
                this.print(betterName7);
                this.print('.');
                this.println();
            }
        }
        if ((value = table.get("@see")) == null) {
            this.generateSee(node);
        }
        if ((value = table.get("@nooverride")) != null) {
            this.println(value);
        }
        if ((value = table.get("@noreference")) != null) {
            this.println(value);
        }
        if ((value = table.get("@category")) != null) {
            this.println(value);
        }
        if ((value = table.get("@since")) != null) {
            this.println(value);
        }
        this.println("\t */");
    }

    public void generateJavadoc(TypeDeclaration node, Map table) {
        List vector;
        int size;
        this.println("\t/**");
        Object value = table.get("@lines");
        if (value instanceof List && (size = (vector = (List)value).size()) > 0) {
            int i = 0;
            while (i < size) {
                this.print("\t ");
                this.println(vector.get(i));
                ++i;
            }
        }
        this.print("\t * @author ");
        this.println(DeviceKitPreferenceInitializer.getPreferenceString((String)"vendor"));
        this.print("\t * @version ");
        this.println(DeviceKitPreferenceInitializer.getPreferenceString((String)"version"));
        value = table.get("@nooverride");
        if (value != null) {
            this.println(value);
        }
        if ((value = table.get("@noreference")) != null) {
            this.println(value);
        }
        if ((value = table.get("@category")) != null) {
            this.println(value);
        }
        if ((value = table.get("@since")) != null) {
            this.println(value);
        }
        this.println("\t */");
    }

    public void generateParameterList(MethodDeclaration node) {
        int size = node.parameters().size();
        int i = 0;
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            SimpleName parameterName = v.getName();
            if (i > 0) {
                if (i == size - 1) {
                    this.print(" and ");
                } else {
                    this.print(", ");
                }
            }
            String betterName = this.parameterName(parameterName.toString(), false);
            this.print(betterName);
            ++i;
        }
    }

    public void generateSee(MethodDeclaration node) {
        TypeDeclaration type = this.getTypeDeclarationNode();
        SimpleName simpleMethodName = node.getName();
        String methodName = simpleMethodName.getIdentifier();
        String endingName = this.getEnding(methodName);
        List list = type.bodyDeclarations();
        int size = list.size();
        BodyDeclaration[] bd = new BodyDeclaration[size];
        list.toArray(bd);
        Arrays.sort(bd, this);
        int i = 0;
        while (i < size) {
            BodyDeclaration d = bd[i];
            if (d instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)d;
                if (!d.equals((Object)node) && !this.isPrivate(methodDeclaration.getModifiers())) {
                    SimpleName simpleMethodNameNode = methodDeclaration.getName();
                    String methodNameNode = simpleMethodNameNode.getIdentifier();
                    if (methodName.equals(methodNameNode)) {
                        this.print("\t * @see #");
                        this.generateSeeReference(methodDeclaration);
                        this.println();
                    } else if (endingName.length() > 0 && methodNameNode.endsWith(endingName)) {
                        this.print("\t * @see #");
                        this.generateSeeReference(methodDeclaration);
                        this.println();
                    }
                }
            }
            ++i;
        }
    }

    public void generateSeeReference(MethodDeclaration node) {
        SimpleName simpleMethodName = node.getName();
        String methodName = simpleMethodName.getIdentifier();
        this.print(methodName);
        this.print('(');
        int count = 0;
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            Type ptype = v.getType();
            String ptypeName = ptype.toString();
            ITypeBinding brtype = ptype.resolveBinding();
            if (brtype != null) {
                ptypeName = brtype.getName();
            }
            if (count > 0) {
                this.print(',');
            }
            this.print(ptypeName);
            ++count;
        }
        this.print(')');
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public CompilationUnit getCompilationUnitNode() {
        return this.compilationUnitNode;
    }

    public int getCreateYear() {
        if (this.getCompilationUnit() != null) {
            IFile file = (IFile)this.getCompilationUnit().getResource();
            return Visitor.getCreateYear(file);
        }
        return -1;
    }

    public int getCurrent() {
        return this.current;
    }

    public String getEnding(String data) {
        StringBuffer buffer = new StringBuffer();
        boolean found = false;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (found || upper) {
                buffer.append(character);
                found = true;
            }
            ++i;
        }
        return buffer.toString();
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    protected Map getJavadocLines(List list) {
        ArrayList<String> first = new ArrayList<String>();
        HashMap<String, Object> table = new HashMap<String, Object>();
        ArrayList<String> vector = new ArrayList<String>(20);
        int lineNumber = 0;
        boolean firstFlag = true;
        String lastLine = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String value;
            String type;
            int count;
            StringTokenizer tokenizerLine;
            String token = iterator.next().toString().trim();
            boolean add = true;
            if (token.equals("*") || token.equals("*/") || token.equals("/**")) {
                add = false;
            } else if (token.equals("* To change the template for this generated type comment go to") || token.equals("* Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments")) {
                add = false;
            } else if (token.startsWith("* @return") || token.startsWith("* @param") || token.startsWith("* @version") || token.startsWith("* @author") || token.startsWith("* @since") || token.startsWith("* @category") || token.startsWith("* @nooverride") || token.startsWith("* @noreference") || token.startsWith("* @throws")) {
                firstFlag = false;
                tokenizerLine = new StringTokenizer(token, " \t");
                count = tokenizerLine.countTokens();
                if (count > 2) {
                    tokenizerLine.nextToken();
                    type = tokenizerLine.nextToken();
                    value = tokenizerLine.nextToken();
                    table.put(type, token);
                    if ("@param".equals(type) || "@throws".equals(type)) {
                        table.put(value, token);
                    }
                }
                if (count <= 3 || token.startsWith("* @author") || token.startsWith("* @throws")) {
                    add = false;
                }
            } else if (token.startsWith("* @see")) {
                String seeReference;
                int index = token.indexOf(32, 4);
                add = false;
                if (index > 0 && !(seeReference = token.substring(index).trim()).startsWith("#")) {
                    add = true;
                }
            } else if (token.startsWith("* @value")) {
                add = false;
            } else if (lastLine.startsWith("* @return") || lastLine.startsWith("* @param") || lastLine.startsWith("* @version") || lastLine.startsWith("* @author") || lastLine.startsWith("* @since") || lastLine.startsWith("* @category") || lastLine.startsWith("* @nooverride") || lastLine.startsWith("* @noreference") || lastLine.startsWith("* @throws")) {
                tokenizerLine = new StringTokenizer(lastLine, " \t");
                count = tokenizerLine.countTokens();
                if (count > 2) {
                    tokenizerLine.nextToken();
                    type = tokenizerLine.nextToken();
                    value = tokenizerLine.nextToken();
                    table.put(type, String.valueOf(value) + ' ' + token.substring(1).trim());
                    if ("@param".equals(type)) {
                        Object current = table.get(value);
                        table.put(value, String.valueOf(String.valueOf(current)) + ' ' + token.substring(1).trim());
                    }
                }
                if (count <= 3) {
                    add = false;
                }
                add = false;
            } else if (token.endsWith(" method comment.")) {
                add = false;
            }
            if (add) {
                if (firstFlag) {
                    first.add(token);
                }
                vector.add(token);
                if (lineNumber == 0 && token.indexOf(46) == -1) {
                    this.logWarning("Javadoc", "Bad first javadoc line.");
                }
                ++lineNumber;
                continue;
            }
            lastLine = token;
        }
        if (vector.size() == 0) {
            return table;
        }
        table.put("@lines", vector);
        table.put("@first", first);
        return table;
    }

    protected String getMissingComments(ASTNode node, boolean update) {
        int current;
        String comment = "";
        int start = node.getStartPosition();
        if (start - (current = this.getCurrent()) > 5) {
            comment = this.getSource().substring(current, start);
        }
        if (update) {
            this.setCurrent(start + node.getLength());
        } else {
            this.setCurrent(start);
        }
        return comment;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public PrintWriter getPrintWriter() {
        if (this.printWriter == null) {
            this.stringWriter = this.createStringWriter();
            this.printWriter = new PrintWriter(this.stringWriter);
        }
        return this.printWriter;
    }

    public String getPropertyName(String name) {
        char[] characters = name.toCharArray();
        if (characters.length > 0) {
            characters[0] = Character.toLowerCase(characters[0]);
            return new String(characters);
        }
        return name;
    }

    public String[] getReferences() {
        return this.references;
    }

    public String getSource() {
        return this.source;
    }

    public StringWriter getStringWriter() {
        return this.stringWriter;
    }

    public long getSuperCount() {
        return this.superCount;
    }

    public long getThisCount() {
        return this.thisCount;
    }

    public long getThrowCount() {
        return this.throwCount;
    }

    public TypeDeclaration getTypeDeclarationNode() {
        return this.typeDeclarationNode;
    }

    public void indent() {
        ++this.indentLevel;
    }

    protected boolean isAbstract(int modifiers) {
        return Modifier.isAbstract((int)modifiers);
    }

    protected boolean isPrivate(int modifiers) {
        return Modifier.isPrivate((int)modifiers);
    }

    public boolean isPseudo() {
        return this.pseudo;
    }

    protected boolean isStatic(int modifiers) {
        return Modifier.isStatic((int)modifiers);
    }

    public void logWarning(String type, String message) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("Warning: ");
        buffer.append(type);
        buffer.append(' ');
        buffer.append(this.logMember);
        buffer.append(' ');
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    public String methodName(String data, boolean caps) {
        StringBuffer buffer = new StringBuffer(128);
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (!last && upper) {
                buffer.append(' ');
            }
            if (i > 0 || !caps) {
                buffer.append(Character.toLowerCase(character));
            } else {
                buffer.append(Character.toUpperCase(character));
            }
            last = upper;
            ++i;
        }
        return CodeUtilities.betterWords(buffer.toString(), 0);
    }

    public String parameterName(String data, boolean caps) {
        StringBuffer buffer = new StringBuffer(64);
        boolean last = true;
        int i = 0;
        while (i < data.length()) {
            char character = data.charAt(i);
            boolean upper = Character.isUpperCase(character);
            if (!last && upper) {
                buffer.append(' ');
            }
            if (character != '_') {
                if (i > 0 || !caps) {
                    buffer.append(Character.toLowerCase(character));
                } else {
                    buffer.append(Character.toUpperCase(character));
                }
            }
            last = upper;
            ++i;
        }
        return CodeUtilities.betterWords(buffer.toString(), 0);
    }

    public void print(char character) {
        this.printIndent();
        this.getPrintWriter().print(character);
        this.endOfStatement = false;
    }

    public void print(Object data) {
        this.printIndent();
        this.getPrintWriter().print(String.valueOf(data));
        this.endOfStatement = false;
    }

    public void print(String data) {
        this.printIndent();
        this.getPrintWriter().print(data);
        this.endOfStatement = false;
    }

    public void printComment(String data) {
        this.print(data);
    }

    public void printEndOfStatement() {
        this.print(';');
        this.endOfStatement = true;
    }

    public void printEndOfStatementLine() {
        this.print(';');
        this.endOfStatement = true;
    }

    public void printIndent() {
        if (this.newLine) {
            int i = 0;
            while (i < this.indentLevel) {
                this.printRaw('\t');
                ++i;
            }
            this.newLine = false;
        }
    }

    protected void printJavadoc(List list) {
        if (list.size() > 0) {
            this.println("/**");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String token = iterator.next().toString().trim();
                if (token.equals("*")) continue;
                this.printIndent();
                if (token.startsWith("*")) {
                    this.print(' ');
                }
                this.println(token);
            }
            this.println(" */");
        }
    }

    protected void printJavadoc(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.equals("*")) continue;
            this.printIndent();
            if (token.startsWith("*")) {
                this.print(' ');
            }
            this.println(token);
        }
    }

    public void printKeyword(String data) {
        this.print(data);
    }

    protected void printLiteral(String string) {
        this.print(string);
    }

    public void println() {
        this.printIndent();
        this.getPrintWriter().println();
        this.endOfStatement = false;
        this.newLine = true;
    }

    public void println(char data) {
        this.printIndent();
        this.getPrintWriter().println(data);
        this.endOfStatement = false;
        this.newLine = true;
    }

    public void println(Object data) {
        this.printIndent();
        this.getPrintWriter().println(String.valueOf(data));
        this.endOfStatement = false;
        this.newLine = true;
    }

    public void println(String data) {
        this.printIndent();
        this.getPrintWriter().println(data);
        this.endOfStatement = false;
        this.newLine = true;
    }

    protected void printMethod(String string) {
        this.print(string);
    }

    void printModifiers(int modifiers) {
        this.printIndent();
        if (Modifier.isPublic((int)modifiers)) {
            this.printKeyword("public ");
        } else if (Modifier.isProtected((int)modifiers)) {
            this.printKeyword("protected ");
        } else if (Modifier.isPrivate((int)modifiers)) {
            this.printKeyword("private ");
        }
        if (Modifier.isStatic((int)modifiers)) {
            this.printKeyword("static ");
        }
        if (Modifier.isAbstract((int)modifiers)) {
            this.printKeyword("abstract ");
        }
        if (Modifier.isFinal((int)modifiers)) {
            this.printKeyword("final ");
        }
        if (Modifier.isSynchronized((int)modifiers)) {
            this.printKeyword("synchronized ");
        }
        if (Modifier.isVolatile((int)modifiers)) {
            this.printKeyword("volatile ");
        }
        if (Modifier.isNative((int)modifiers)) {
            this.printKeyword("native ");
        }
        if (Modifier.isStrictfp((int)modifiers)) {
            this.printKeyword("strictfp ");
        }
        if (Modifier.isTransient((int)modifiers)) {
            this.printKeyword("transient ");
        }
    }

    public void printPackage(String data) {
        this.print(data);
    }

    public void printRaw(char character) {
        this.getPrintWriter().print(character);
        this.endOfStatement = false;
    }

    public void printSpace() {
        this.print(' ');
    }

    public void printType(String data) {
        this.print(data);
    }

    public void printType(String data, String packageName) {
        this.print(data);
    }

    protected void printVariable(String string) {
        this.print(string);
    }

    public void setCompilationUnit(ICompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public void setCompilationUnitNode(CompilationUnit unit) {
        this.compilationUnitNode = unit;
    }

    public void setCurrent(ASTNode node) {
        this.setCurrent(node.getStartPosition());
    }

    public void setCurrent(int start) {
        this.current = start;
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void setLogMember(MethodDeclaration node) {
        StringBuffer buffer = new StringBuffer(200);
        if (this.typeDeclarationNode != null) {
            buffer.append(this.typeDeclarationNode.getName().getIdentifier());
            buffer.append('.');
        }
        SimpleName simpleMethodName = node.getName();
        String methodName = simpleMethodName.getIdentifier();
        buffer.append(methodName);
        buffer.append('(');
        int index = 0;
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            Type ptype = v.getType();
            String ptypeName = ptype.toString();
            ITypeBinding brtype = ptype.resolveBinding();
            if (brtype != null) {
                ptypeName = brtype.getName();
            }
            if (index > 0) {
                buffer.append(',');
            }
            buffer.append(ptypeName);
            ++index;
        }
        buffer.append(')');
        this.logMember = buffer.toString();
    }

    public void setLogMember(TypeDeclaration node) {
        StringBuffer buffer = new StringBuffer(200);
        if (node != null) {
            buffer.append(node.getName().getIdentifier());
        }
        this.logMember = buffer.toString();
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setPseudo(boolean pseudo) {
        this.pseudo = pseudo;
    }

    public void setReferences(String[] set) {
        this.references = set;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setStringWriter(StringWriter stringWriter) {
        this.stringWriter = stringWriter;
    }

    public void setSuperCount(long superCount) {
        this.superCount = superCount;
    }

    public void setThisCount(long l) {
        this.thisCount = l;
    }

    public void setThrowCount(long l) {
        this.throwCount = l;
    }

    public void setTypeDeclarationNode(TypeDeclaration declaration) {
        this.typeDeclarationNode = declaration;
    }

    public String toString() {
        return this.getStringWriter().toString();
    }

    public void unindent() {
        --this.indentLevel;
    }

    protected boolean updateMissingComments(ASTNode node, boolean update) {
        int current;
        boolean result = false;
        int start = node.getStartPosition();
        if (start - (current = this.getCurrent()) > 5) {
            String comment = this.getSource().substring(current, start);
            if (comment.startsWith("/*") || comment.startsWith("\r\n/*")) {
                this.printComment(comment);
            } else {
                this.print(comment);
            }
            result = true;
        }
        if (update) {
            this.setCurrent(start + node.getLength());
        } else {
            this.setCurrent(start);
        }
        return result;
    }

    public void updateSuperCount() {
        ++this.superCount;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        this.print('{');
        Iterator it = node.bodyDeclarations().iterator();
        while (it.hasNext()) {
            BodyDeclaration b = (BodyDeclaration)it.next();
            b.accept((ASTVisitor)this);
        }
        this.print('}');
        return false;
    }

    public boolean visit(ArrayAccess node) {
        node.getArray().accept((ASTVisitor)this);
        this.print('[');
        node.getIndex().accept((ASTVisitor)this);
        this.print(']');
        return false;
    }

    public boolean visit(ArrayCreation node) {
        this.print("new ");
        ArrayType at = node.getType();
        int dims = at.getDimensions();
        Type elementType = at.getElementType();
        elementType.accept((ASTVisitor)this);
        Iterator it = node.dimensions().iterator();
        while (it.hasNext()) {
            this.print('[');
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            this.print(']');
            --dims;
        }
        int i = 0;
        while (i < dims) {
            this.print("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        this.print('{');
        boolean first = true;
        Iterator it = node.expressions().iterator();
        while (it.hasNext()) {
            if (!first) {
                this.print(", ");
            }
            first = false;
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        this.print('}');
        return false;
    }

    public boolean visit(ArrayType node) {
        node.getComponentType().accept((ASTVisitor)this);
        this.print("[]");
        return false;
    }

    public boolean visit(AssertStatement node) {
        this.printKeyword("assert ");
        node.getExpression().accept((ASTVisitor)this);
        if (node.getMessage() != null) {
            this.print(" : ");
            node.getMessage().accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept((ASTVisitor)this);
        this.printSpace();
        this.print(node.getOperator().toString());
        this.printSpace();
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Block node) {
        this.println(" {");
        this.indent();
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept((ASTVisitor)this);
        }
        this.unindent();
        this.printIndent();
        this.println('}');
        return false;
    }

    public boolean visit(BlockComment node) {
        return super.visit(node);
    }

    public boolean visit(BooleanLiteral node) {
        if (node.booleanValue()) {
            this.printKeyword("true");
        } else {
            this.printKeyword("false");
        }
        return false;
    }

    public boolean visit(BreakStatement node) {
        this.printKeyword("break");
        if (node.getLabel() != null) {
            this.print(' ');
            node.getLabel().accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(CastExpression node) {
        this.print('(');
        node.getType().accept((ASTVisitor)this);
        this.print(')');
        node.getExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(CatchClause node) {
        this.printKeyword("catch ");
        this.print('(');
        int modifiers = node.getException().getModifiers();
        if (!Modifier.isFinal((int)modifiers)) {
            this.printKeyword("final ");
        }
        node.getException().accept((ASTVisitor)this);
        this.print(") ");
        Block body = node.getBody();
        if (body != null) {
            int count = body.statements().size();
            if (count == 0) {
                this.println(" {");
                this.indent();
                this.println("/* ignore exception */");
                this.println("}");
            } else {
                body.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        this.print(node.getEscapedValue());
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.print('.');
        }
        this.printKeyword("new ");
        node.getType().accept((ASTVisitor)this);
        this.print('(');
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        if (node.getAnonymousClassDeclaration() != null) {
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(CompilationUnit node) {
        ImportDeclaration d;
        this.compilationUnitNode = node;
        if (node.getPackage() != null) {
            node.getPackage().accept((ASTVisitor)this);
        }
        Iterator it = node.imports().iterator();
        while (it.hasNext()) {
            d = (ImportDeclaration)it.next();
            d.accept((ASTVisitor)this);
        }
        it = node.types().iterator();
        while (it.hasNext()) {
            d = (TypeDeclaration)it.next();
            d.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept((ASTVisitor)this);
        this.print("?");
        node.getThenExpression().accept((ASTVisitor)this);
        this.print(":");
        node.getElseExpression().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        this.print("this(");
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.println(");");
        return false;
    }

    public boolean visit(ContinueStatement node) {
        this.printKeyword("continue");
        if (node.getLabel() != null) {
            this.print(' ');
            node.getLabel().accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(DoStatement node) {
        this.printKeyword("do ");
        node.getBody().accept((ASTVisitor)this);
        this.printKeyword(" while ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.println(");");
        return false;
    }

    public boolean visit(EmptyStatement node) {
        this.logWarning("Code", "Empty statement");
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(FieldAccess node) {
        node.getExpression().accept((ASTVisitor)this);
        this.print('.');
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        boolean comments = false;
        this.check(node);
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        if (node.getJavadoc() != null) {
            Map table = this.getJavadocLines(node.getJavadoc().tags());
            this.generateJavadoc(node, table);
        } else if (!comments) {
            this.generateJavadoc(node, new HashMap());
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept((ASTVisitor)this);
        this.print(' ');
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(ForStatement node) {
        Expression e;
        Iterator it;
        this.printKeyword("for ");
        this.print('(');
        if (node.initializers().size() > 0) {
            it = node.initializers().iterator();
            while (it.hasNext()) {
                e = (Expression)it.next();
                e.accept((ASTVisitor)this);
            }
            if (!this.endOfStatement) {
                this.printEndOfStatement();
                this.print(' ');
            }
        } else {
            this.printEndOfStatement();
            this.print(' ');
        }
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
        }
        this.printEndOfStatement();
        this.print(' ');
        it = node.updaters().iterator();
        while (it.hasNext()) {
            e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        this.print(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(IfStatement node) {
        this.printKeyword("if ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(") ");
        node.getThenStatement().accept((ASTVisitor)this);
        Statement elseStatement = node.getElseStatement();
        if (elseStatement != null) {
            if (elseStatement instanceof Block) {
                Block block = (Block)elseStatement;
                int size = block.statements().size();
                if (size > 0) {
                    this.printKeyword(" else ");
                    node.getElseStatement().accept((ASTVisitor)this);
                }
            } else {
                this.printKeyword(" else ");
                node.getElseStatement().accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        if (!this.copyrightFound) {
            this.checkCopyright((ASTNode)node);
        }
        this.printKeyword("import ");
        if (node.isOnDemand()) {
            Name name = node.getName();
            if (name.isSimpleName()) {
                this.printPackage(((SimpleName)name).getIdentifier());
            } else {
                name.accept((ASTVisitor)this);
            }
            this.print(".*");
        } else {
            Name name = node.getName();
            if (name.isSimpleName()) {
                this.printType(((SimpleName)name).getIdentifier());
            } else {
                this.printPackage(((QualifiedName)name).getQualifier().toString());
                this.print('.');
                this.printType(((QualifiedName)name).getName().getIdentifier());
            }
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(InfixExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.print(' ');
        this.print(node.getOperator().toString());
        this.print(' ');
        node.getRightOperand().accept((ASTVisitor)this);
        Iterator it = node.extendedOperands().iterator();
        while (it.hasNext()) {
            this.print(node.getOperator().toString());
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(Initializer node) {
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        if (node.getJavadoc() != null) {
            node.getJavadoc().accept((ASTVisitor)this);
        }
        this.printModifiers(node.getModifiers());
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        node.getLeftOperand().accept((ASTVisitor)this);
        this.printKeyword(" instanceof ");
        node.getRightOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(Javadoc node) {
        this.printIndent();
        this.printJavadoc(node.tags());
        return false;
    }

    public boolean visit(LabeledStatement node) {
        node.getLabel().accept((ASTVisitor)this);
        this.print(": ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(LineComment node) {
        return super.visit(node);
    }

    public boolean visit(MethodDeclaration node) {
        TypeDeclaration type;
        ASTNode parent;
        long thisCount = this.getThisCount();
        long throwCount = this.getThrowCount();
        long superCount = this.getSuperCount();
        boolean setMethod = false;
        this.setLogMember(node);
        boolean comments = false;
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        if (node.getJavadoc() != null) {
            Map table = this.getJavadocLines(node.getJavadoc().tags());
            this.generateJavadoc(node, table);
        } else if (!comments) {
            this.generateJavadoc(node, new HashMap());
        }
        int modifiers = node.getModifiers();
        if (node.isConstructor() && Modifier.isPublic((int)modifiers) && (parent = node.getParent()) instanceof TypeDeclaration && Modifier.isAbstract((int)(type = (TypeDeclaration)parent).getModifiers())) {
            modifiers = modifiers ^ 1 | 4;
        }
        this.printModifiers(modifiers);
        if (!node.isConstructor()) {
            node.getReturnType2().accept((ASTVisitor)this);
            this.print(' ');
        }
        node.getName().accept((ASTVisitor)this);
        String methodName = node.getName().getIdentifier();
        if (methodName.startsWith("set")) {
            if (node.parameters().size() == 1) {
                String propertyName;
                SingleVariableDeclaration v = (SingleVariableDeclaration)node.parameters().get(0);
                String name = v.getName().getIdentifier();
                if (!name.equals(propertyName = this.getPropertyName(methodName.substring(3)))) {
                    this.logWarning("Code", "Bad set parameter name " + name + " should be " + propertyName);
                }
                setMethod = true;
            }
        } else if (methodName.startsWith("get")) {
            node.parameters().size();
        }
        this.print('(');
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            v.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        boolean throwsFlag = false;
        if (!node.thrownExceptions().isEmpty()) {
            throwsFlag = true;
            this.printKeyword(" throws ");
            Iterator it2 = node.thrownExceptions().iterator();
            while (it2.hasNext()) {
                Name n = (Name)it2.next();
                n.accept((ASTVisitor)this);
                if (!it2.hasNext()) continue;
                this.print(", ");
            }
            this.print(' ');
        }
        boolean abstractFlag = false;
        Block body = node.getBody();
        if (body == null) {
            this.printEndOfStatementLine();
            abstractFlag = true;
        } else if (this.isPseudo()) {
            this.println(" {");
            this.println("   /* No Source */}");
        } else if (body.statements().size() == 0) {
            if (node.isConstructor()) {
                if (node.parameters().size() == 0) {
                    this.println(" {");
                    this.indent();
                    this.println("super();");
                    this.println("}");
                } else {
                    body.accept((ASTVisitor)this);
                }
            } else {
                this.println(" {");
                this.indent();
                this.println("/* do nothing */");
                this.println("}");
            }
        } else {
            body.accept((ASTVisitor)this);
        }
        if (this.typeDeclarationNode != null) {
            abstractFlag = this.typeDeclarationNode.isInterface();
        }
        if (!abstractFlag) {
            if (!this.isStatic(node.getModifiers()) && !this.isAbstract(node.getModifiers()) && setMethod && thisCount == this.getThisCount() && superCount == this.getSuperCount()) {
                this.logWarning("Code", "No references to this or super in method.");
            }
            if (!throwsFlag && throwCount != this.getThrowCount()) {
                this.logWarning("Code", "Missing throws on method declaration.");
            }
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.print('.');
        }
        node.getName().accept((ASTVisitor)this);
        this.print('(');
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        return false;
    }

    public boolean visit(NullLiteral node) {
        this.print("null");
        return false;
    }

    public boolean visit(NumberLiteral node) {
        this.print(node.getToken());
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        String packageName;
        String comment = this.getMissingComments((ASTNode)node, true);
        this.printKeyword("package ");
        Name name = node.getName();
        if (name instanceof SimpleName) {
            packageName = ((SimpleName)name).getIdentifier();
            this.setPackageName(packageName);
            this.printPackage(packageName);
        } else {
            if (name instanceof QualifiedName) {
                packageName = ((QualifiedName)name).getFullyQualifiedName();
                this.setPackageName(packageName);
            }
            name.accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        if (comment.length() > 0) {
            int createYear = Visitor.containsCopyright(comment);
            if (createYear > -1) {
                try {
                    this.println(GeneratorTemplates.getCopyrightCodeString(GeneratorTemplates.getTemplateVariables(createYear)));
                    this.copyrightFound = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.println(comment);
            }
        }
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(')');
        return false;
    }

    public boolean visit(PostfixExpression node) {
        node.getOperand().accept((ASTVisitor)this);
        this.print(node.getOperator().toString());
        return false;
    }

    public boolean visit(PrefixExpression node) {
        this.print(node.getOperator().toString());
        node.getOperand().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(PrimitiveType node) {
        this.printKeyword(node.getPrimitiveTypeCode().toString());
        return false;
    }

    public boolean visit(QualifiedName node) {
        Name qname = node.getQualifier();
        qname.accept((ASTVisitor)this);
        this.print('.');
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.printKeyword("return");
        if (node.getExpression() != null) {
            this.print(' ');
            node.getExpression().accept((ASTVisitor)this);
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(SimpleName node) {
        IPackageBinding packageBinding;
        ITypeBinding typeBinding = node.resolveTypeBinding();
        if (typeBinding != null && (packageBinding = typeBinding.getPackage()) != null) {
            this.printType(node.getIdentifier(), packageBinding.getName());
            return false;
        }
        IBinding binding = node.resolveBinding();
        if (binding != null) {
            switch (binding.getKind()) {
                case 4: {
                    this.printMethod(binding.getName());
                    return false;
                }
                case 3: {
                    this.printVariable(node.getIdentifier());
                    return false;
                }
            }
        }
        this.print(node.getIdentifier());
        return false;
    }

    public boolean visit(SimpleType node) {
        ITypeBinding type = node.getName().resolveTypeBinding();
        if (type != null && !type.isTopLevel()) {
            this.printType(type.getDeclaringClass().getName());
            this.print('.');
            this.printType(type.getName());
        } else if (type != null) {
            this.printType(type.getName());
        } else {
            this.printType(String.valueOf(node.getName()));
        }
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept((ASTVisitor)this);
        this.print(' ');
        node.getName().accept((ASTVisitor)this);
        if (node.getInitializer() != null) {
            this.print("=");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(StringLiteral node) {
        this.printLiteral(node.getEscapedValue());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        this.updateSuperCount();
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            this.print('.');
        }
        this.printKeyword("super");
        this.print('(');
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.println(");");
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        this.updateSuperCount();
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.print('.');
        }
        this.printKeyword("super.");
        node.getName().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        this.updateSuperCount();
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.print('.');
        }
        this.print("super.");
        node.getName().accept((ASTVisitor)this);
        this.print('(');
        Iterator it = node.arguments().iterator();
        while (it.hasNext()) {
            Expression e = (Expression)it.next();
            e.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        return false;
    }

    public boolean visit(SwitchCase node) {
        if (node.isDefault()) {
            this.printKeyword("default");
        } else {
            this.printKeyword("case ");
            node.getExpression().accept((ASTVisitor)this);
        }
        this.print(": ");
        return false;
    }

    public boolean visit(SwitchStatement node) {
        this.printKeyword("switch ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(") ");
        this.print('{');
        Iterator it = node.statements().iterator();
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            s.accept((ASTVisitor)this);
        }
        this.print('}');
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        this.printKeyword("synchronized ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(ThisExpression node) {
        if (node.getQualifier() != null) {
            node.getQualifier().accept((ASTVisitor)this);
            this.print('.');
        }
        this.printKeyword("this");
        ++this.thisCount;
        return false;
    }

    public boolean visit(ThrowStatement node) {
        this.printKeyword("throw ");
        node.getExpression().accept((ASTVisitor)this);
        this.printEndOfStatementLine();
        ++this.throwCount;
        return false;
    }

    public boolean visit(TryStatement node) {
        this.print("try ");
        node.getBody().accept((ASTVisitor)this);
        this.print(' ');
        Iterator it = node.catchClauses().iterator();
        while (it.hasNext()) {
            CatchClause cc = (CatchClause)it.next();
            cc.accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            this.print(" finally ");
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        this.setLogMember(node);
        this.typeDeclarationNode = node;
        if (!this.copyrightFound) {
            this.checkCopyright((ASTNode)node);
        }
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        Javadoc javadoc = node.getJavadoc();
        if (javadoc != null) {
            Map table = this.getJavadocLines(javadoc.tags());
            this.generateJavadoc(node, table);
        } else {
            this.generateJavadoc(node, new HashMap());
        }
        this.printModifiers(node.getModifiers());
        this.printKeyword(node.isInterface() ? "interface " : "class ");
        node.getName().accept((ASTVisitor)this);
        this.print(' ');
        if (node.getSuperclassType() != null) {
            this.printKeyword("extends ");
            node.getSuperclassType().accept((ASTVisitor)this);
            this.print(' ');
        }
        if (!node.superInterfaceTypes().isEmpty()) {
            this.printKeyword(node.isInterface() ? "extends " : "implements ");
            Iterator it = node.superInterfaceTypes().iterator();
            while (it.hasNext()) {
                Type n = (Type)it.next();
                n.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.print(", ");
            }
            this.print(' ');
        }
        this.println(" {");
        this.indent();
        List list = node.bodyDeclarations();
        int size = list.size();
        ASTNode[] bd = new ASTNode[size];
        list.toArray(bd);
        Arrays.sort(bd, this);
        int i = 0;
        while (i < size) {
            ASTNode d = bd[i];
            if (i == 0) {
                this.setCurrent(d.getStartPosition());
            }
            d.accept((ASTVisitor)this);
            ++i;
        }
        this.unindent();
        this.println();
        this.printIndent();
        this.println("}");
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        node.getDeclaration().accept((ASTVisitor)this);
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(TypeLiteral node) {
        Type type = node.getType();
        type.accept((ASTVisitor)this);
        this.printKeyword(".class");
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept((ASTVisitor)this);
        this.print(' ');
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        node.getName().accept((ASTVisitor)this);
        int i = 0;
        while (i < node.getExtraDimensions()) {
            this.print("[]");
            ++i;
        }
        if (node.getInitializer() != null) {
            this.print(" = ");
            node.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        this.printModifiers(node.getModifiers());
        node.getType().accept((ASTVisitor)this);
        this.print(' ');
        Iterator it = node.fragments().iterator();
        while (it.hasNext()) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)it.next();
            f.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.printEndOfStatementLine();
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.printKeyword("while ");
        this.print('(');
        node.getExpression().accept((ASTVisitor)this);
        this.print(") ");
        node.getBody().accept((ASTVisitor)this);
        return false;
    }
}

