/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionItemElement;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class UsbElement
extends ConnectionItemElement
implements IConnectionItem {
    private String vendorId;
    private String productId;
    private String usagePage;
    private String usage;

    public UsbElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_USB;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ArrayList<ConfigurationField> list = new ArrayList<ConfigurationField>();
        list.add(new ConfigurationField("int", "DEFAULT_PRODUCTID", this.getProductId()));
        list.add(new ConfigurationField("int", "DEFAULT_USAGE", this.getUsage()));
        list.add(new ConfigurationField("int", "DEFAULT_USAGEPAGE", this.getUsagePage()));
        list.add(new ConfigurationField("int", "DEFAULT_VENDORID", this.getVendorId()));
        ConfigurationField[] pairs = new ConfigurationField[list.size()];
        list.toArray(pairs);
        return pairs;
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_USB_SERVICE));
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "usb";
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public String getProductId() {
        if (this.productId == null) {
            this.productId = "-1";
        }
        return this.productId;
    }

    public Map getProperties() {
        HashMap<String, String> table = new HashMap<String, String>();
        if (this.getVendorId() != null) {
            table.put("vendorid", this.getVendorId());
        }
        if (this.getProductId() != null) {
            table.put("productid", this.getProductId());
        }
        if (this.getUsagePage() != null) {
            table.put("usagepage", this.getUsagePage());
        }
        if (this.getUsage() != null) {
            table.put("usage", this.getUsage());
        }
        return table;
    }

    public int getTagCode() {
        return 51;
    }

    public String getUsage() {
        if (this.usage == null) {
            this.usage = "-1";
        }
        return this.usage;
    }

    public String getUsagePage() {
        if (this.usagePage == null) {
            this.usagePage = "-1";
        }
        return this.usagePage;
    }

    public String getVendorId() {
        if (this.vendorId == null) {
            this.vendorId = "-1";
        }
        return this.vendorId;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("vendorid".equals(childNodeName)) {
            this.setVendorId(ParserUtilities.extractData(childNode));
        } else if ("productid".equals(childNodeName)) {
            this.setProductId(ParserUtilities.extractData(childNode));
        } else if ("usagepage".equals(childNodeName)) {
            this.setUsagePage(ParserUtilities.extractData(childNode));
        } else if ("usage".equals(childNodeName)) {
            this.setUsage(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void setUsagePage(String usagePage) {
        this.usagePage = usagePage;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }
}

