/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class DataElement
extends TagElement {
    public DataElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        String value = this.getTextData();
        int index = -1;
        if (value != null) {
            index = value.indexOf(47, 0);
        }
        if (index == -1) {
            return DeviceKitGenerationConstants.CLASS_TRANSFORM_INT_SCALE;
        }
        return DeviceKitGenerationConstants.CLASS_TRANSFORM_SCALE;
    }

    public int getTagCode() {
        return 76;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("data".equals(childNodeName)) {
            this.handleData(childNode);
        } else if ("enum".equals(childNodeName)) {
            this.handleEnum(childNode);
        }
        super.handleChild(childNode);
    }

    protected void handleData(Node node) {
        DataElement pe = new DataElement(node, this);
        this.addChild(pe);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addData(pe.getId(), pe);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleEnum(Node node) {
        EnumElement element = new EnumElement(node, this);
        this.addChild(element);
    }
}

