/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.NewCodeGenerator;
import org.eclipse.soda.devicekit.generator.model.TransportFactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportServiceElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.soda.devicekit.util.KeyValuePair;
import org.eclipse.soda.devicekit.util.Nls;

public class DkTransportGenerator
extends AbstractDkGenerator {
    private boolean connection = false;
    TransportElement fTransport;
    JavaFileModel fTransportModel;
    private boolean initWithMethods = false;
    private boolean isLazy = false;
    private String pack;
    private boolean response = false;
    private boolean tunnel = false;

    protected DkTransportGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap());
    }

    protected DkTransportGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map properties) {
        super(model, generatedInfo, properties);
    }

    protected void codeBACreateService(IType ba) {
        KeyValuePair parameter;
        String[] comment = new String[]{};
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        String contents = this.getBACreateServiceContents();
        if (this.fTransport.getTransportServiceChildren().size() > 0) {
            comment = new String[]{"Creates the transport service to be registered with the OSGi system.", "", "@param transport The transport to be used when creating this transport service.", "@return Object The transport service", "@see " + this.getMainFqn()};
            parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE), "transport");
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        } else {
            comment = new String[]{"Creates the transport service to be registered with the OSGi system.", "", "@param connection The connection service to be used when creating this transport service.", "@return Object The transport service", "@see " + this.getMainFqn()};
            parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE), "connection");
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        }
        this.codeMethod(ba, "createService", comment, returnType, 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    private void codeBAExportedServiceNamesField(IType ba) {
        String bundle = this.fTransport.getBundleName();
        StringBuffer fieldComment = new StringBuffer(64);
        fieldComment.append("Defines the service name(s) to be registered by the " + bundle + " bundle.\n");
        String[] services = this.fTransport.getImplementedInterfaces();
        int indentation = 0;
        if (services.length > 0) {
            fieldComment.append(this.getHtmlHelper().startTable(0));
            ++indentation;
            int i = 0;
            while (i < services.length) {
                fieldComment.append(this.getHtmlHelper().getTableRow(indentation, services[i]));
                ++i;
            }
            fieldComment.append(this.getHtmlHelper().endTable(--indentation));
        }
        StringBuffer value = new StringBuffer(64);
        this.fBundleActivatorModel.addImport(this.getServiceFqn());
        this.getManifestModel().addImportPackage(this.getServicePackage());
        value.append("\n\t" + this.getServiceClass() + '.' + "SERVICE_NAME");
        int i = 0;
        while (i < services.length) {
            value.append(',');
            String curr = services[i];
            this.fBundleActivatorModel.addImport(curr);
            String currPack = DeviceKitUtilities.extractPackage(curr);
            this.getManifestModel().addImportPackage(currPack);
            if (curr.equals(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE)) {
                value.append("\n\t" + this.quote(curr));
            } else {
                value.append("\n\t" + DeviceKitUtilities.stripPackage(curr) + '.' + "SERVICE_NAME");
            }
            ++i;
        }
        this.codeBAExportedServiceNamesField(ba, value.toString(), fieldComment.toString());
    }

    protected void codeBAFields(IType ba) {
        super.codeBAFields(ba);
        this.codeBADeviceCategoryField(ba);
    }

    protected void codeBAGetDefaultConnection(IType ba) {
        if (this.connection) {
            String comment = Nls.format(DeviceKitGenerator.getResource("DkTransportGenerator.ba.get.default.connection.comment1"), new Object[]{this.getMainFqn(), "getDefaultConnection"});
            String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
            String contents = this.getBAGetDefaultConnectionContents();
            this.codeMethod(ba, "getDefaultConnection", comment, returnType, 1L, contents);
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        }
    }

    protected void codeBAGetExportedServiceNames(IType ba) {
        this.codeBAExportedServiceNamesField(ba);
        StringBuffer buffer = new StringBuffer(64);
        String bundle = this.fTransport.getBundleName();
        buffer.append("Return the exported service name(s) to be registered by the " + bundle + " bundle.\n");
        buffer.append("\n@return String[] The transport's service names.\n");
        this.codeBAGetExportedServiceNames(ba, buffer.toString());
    }

    protected void codeBAGetImportedServiceNames(IType ba) {
        this.codeBAGetImportedServiceNames(this.fTransport.getBundleName(), ba);
    }

    protected void codeBAGetInterestServiceName(IType ba) {
        String serv;
        TagElement tService;
        if (this.tunnel && (tService = (TagElement)this.fTransport.getTransportServiceChildren().get(0)) != null && (serv = tService.getAttribute("service")) != null) {
            String comment = Nls.format(DeviceKitGenerator.getResource("DkTransportGenerator.ba.get.interest.service.name.comment1"), serv);
            String contents = this.getBAGetInterestServiceNameContents(serv);
            this.codeMethod(ba, "getInterestServiceName", comment, "String", 1L, contents);
        }
    }

    protected void codeBAGetMatchDeviceClasses(IType ba) {
        String transport = this.getMainClassName();
        if (transport.endsWith("Transport")) {
            int index = transport.lastIndexOf("Transport");
            transport = transport.substring(0, index);
        }
        this.codeBAMatchingDevicesField(ba, this.quote(transport));
        String comment = Nls.format(DeviceKitGenerator.getResource("DkTransportGenerator.ba.get.match.device.classes.comment1"), transport);
        this.codeBAGetMatchingDevicesMethod(ba, comment);
    }

    protected void codeBAMethods(IType ba) {
        super.codeBAMethods(ba);
        this.codeBACreateService(ba);
        this.codeBAGetInterestServiceName(ba);
        this.codeBAGetExportedServiceNames(ba);
        this.codeBAGetImportedServiceNames(ba);
    }

    protected void codeConnectionDefaults(IType service) {
        List connChildren = this.fTransport.getConnectionChildren();
        int i = 0;
        while (i < connChildren.size()) {
            TagElement item = (TagElement)connChildren.get(i);
            ConfigurationField[] fields = item.getConfigurationOptions();
            this.codeConfigurationFieldDefaults(fields, item, service);
            ++i;
        }
    }

    protected void codeConstructors(IType transport) {
        String name = this.getMainClassName();
        String comment = "Constructs a new instance of the " + this.getMainClassName() + " class.";
        String returnType = null;
        this.codeMethod(transport, name, comment, returnType, 1L, "super();\n");
    }

    protected void codeFields(IType transport) {
        this.codeClassNameField(transport, this.getMainFqn());
    }

    private void codeGetDefaultConnection(IType transport) {
        String connectionService;
        String returnType = connectionService = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        String[] comment = new String[]{"Gets the default connection.", "", "@return " + connectionService + " The default connection used by this transport."};
        String contents = this.getGetDefaultConnectionContents(transport);
        this.codeMethod(transport, "getDefaultConnection", comment, returnType, 1L, contents);
        this.fTransportModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
    }

    private void codeGetDefaultResponseTimeOut(IType transport) {
        String[] comment = new String[]{"Gets the default response timeout.", "", "@return int The default response timeout."};
        String contents = this.getGetDefaultResponseTimeOutContents();
        this.codeMethod(transport, "getDefaultResponseTimeout", comment, "long", 1L, contents);
    }

    private void codeGetDefaultTransport(IType transport) {
        TagElement tService = (TagElement)this.fTransport.getTransportServiceChildren().get(0);
        String transportServiceName = null;
        String[] comment = new String[]{"Gets the default TransportService for this device.", "", Nls.format("@return {0} The default TransportService.", new Object[]{DeviceKitUtilities.stripPackage(transportServiceName)})};
        if (tService != null) {
            transportServiceName = tService.getAttribute("service");
        }
        if (transportServiceName == null) {
            transportServiceName = DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE;
        }
        if (!transportServiceName.endsWith("Service")) {
            transportServiceName = String.valueOf(transportServiceName) + "Service";
        }
        if (transportServiceName.indexOf(46) != -1) {
            this.fTransportModel.addImport(transportServiceName);
        }
        String returnType = DeviceKitUtilities.stripPackage(transportServiceName);
        String contents = this.getGetDefaultTransportContents(transportServiceName);
        this.codeMethod(transport, "getDefaultTransport", comment, returnType, 1L, contents);
    }

    protected void codeGetRetryTime(IType transport) {
        if (this.fTransport.getRetryTime() != null) {
            String[] comment = new String[]{"Gets the retry time.", "return long The retry time"};
            String contents = this.getGetRetryTimeContents();
            this.codeMethod(transport, "getRetryTime", comment, "long", 1L, contents);
        }
    }

    protected void codeMethods(IType transport) {
        this.codeProcessInput(transport);
        this.codeWrite(transport);
        this.codeSetUp(transport);
        if (this.connection) {
            this.codeGetDefaultConnection(transport);
            if (this.response) {
                this.codeGetDefaultResponseTimeOut(transport);
            }
        }
        if (this.tunnel) {
            this.codeGetDefaultTransport(transport);
        }
    }

    private void codeProcessInput(IType transport) {
        if (!this.tunnel && this.getMethodProperty("processInput")) {
            String[] comment = new String[]{"Perform the processInput action method.", "", "@param bytes byte[]", "@param length int", "@return int", "@throws Exception", "@see #processInput()"};
            String contents = this.getProcessInputContents();
            KeyValuePair parameter1 = new KeyValuePair("byte[]", "bytes");
            KeyValuePair parameter2 = new KeyValuePair("int", "length");
            KeyValuePair[] parameters = new KeyValuePair[]{parameter1, parameter2};
            String exception = DeviceKitGenerationConstants.CLASS_EXCEPTION;
            this.codeMethodNoMetaData(transport, "processInput", comment, "int", 4L, contents, parameters, new String[]{exception});
        }
    }

    protected void codeServiceFields(IType service) {
        super.codeServiceFields(service);
        this.codeConnectionDefaults(service);
        this.codeCustomParameterServiceFields(service);
        this.codeParameterServiceFields(service);
    }

    protected void codeSetUp(IType transport) {
        String contents = this.getSetUpContents(transport);
        TransportElement element = this.getTransportElement();
        List parameters = element.getAllChildrenWithTagCode(46);
        String retryTime = element.getRetryTime();
        String noActivityTimeout = element.getNoActivityTimeout();
        String transmitRetries = element.getTransmitRetries();
        String comment = this.getSetUpComment(parameters, retryTime, noActivityTimeout, transmitRetries);
        this.codeMethod(transport, "setup", comment, "void", 1L, contents);
    }

    private void codeWrite(IType transport) {
        if (this.getMethodProperty("write")) {
            String[] comment = new String[]{"Perform the write action method.", "", "@param message <code>MessageService</code>", "@throws Exception", "@see #send(MessageService)"};
            String messageServiceFqn = DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE;
            KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(messageServiceFqn), "message");
            this.fTransportModel.addImport(messageServiceFqn);
            this.getManifestModel().addImportPackage(DeviceKitUtilities.extractPackage(messageServiceFqn));
            this.fTransportModel.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
            String exception = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_EXCEPTION);
            String contents = this.getWriteContents();
            this.codeMethodNoMetaData(transport, "write", comment, "void", 4L, contents, new KeyValuePair[]{parameter}, new String[]{exception});
            this.fTransportModel.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
        }
    }

    private String createDefaultConnectionMethod(NewCodeGenerator gen, IType transport, IConnectionItem connectionItem) {
        String name = this.getDefaultConnectionMethodName(connectionItem);
        String returnType = this.getDefaultConnectionServiceName(connectionItem);
        String connectionPackage = DeviceKitUtilities.extractPackage(((TagElement)((Object)connectionItem)).getType());
        this.buildModel.addPackage(connectionPackage);
        this.buildModel.addPackage(String.valueOf(connectionPackage) + ".service");
        String[] comment = new String[]{"Gets the default " + connectionItem.getConnectionType() + " connection.", "", "@return " + returnType + " The default " + connectionItem.getConnectionType() + " connection used by this transport."};
        String contents = this.getDefaultConnectionMethodContents(gen, connectionItem);
        this.codeMethod(transport, name, comment, returnType, 1L, contents);
        this.fTransportModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        return name;
    }

    protected IType createTransportType() throws Exception {
        String transportClass = this.getMainClassName();
        String transportPackage = this.getMainPackage();
        this.fTransportModel.setComment(this.getCopyright());
        this.fTransportModel.setPackage(transportPackage);
        this.fTransportModel.addImport(this.getServiceFqn());
        IType transport = this.createClass(this.fTransportModel, transportPackage, transportClass, this.getSourceFolderName());
        if (this.getTransportElement().isAbstract()) {
            transport.setIdentifiers(65L);
        }
        transport.setComment(this.getMainClassComment());
        this.fTransportModel.addImport(this.fTransport.getSuperClass());
        String superClass = DeviceKitUtilities.stripPackage(this.fTransport.getSuperClass());
        transport.setSuperClass(superClass);
        String[] interfaces = this.fTransport.getImplementedInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].equals(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE)) {
                transport.addSuperInterface(interfaces[i]);
            } else {
                this.fTransportModel.addImport(interfaces[i]);
                transport.addSuperInterface(DeviceKitUtilities.stripPackage(interfaces[i]));
            }
            ++i;
        }
        this.fTransportModel.addImport(this.getServiceFqn());
        transport.addSuperInterface(DeviceKitUtilities.stripPackage(this.getServiceClass()));
        String messageServiceFqn = DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE;
        this.getManifestModel().addImportPackage(DeviceKitUtilities.extractPackage(messageServiceFqn));
        return transport;
    }

    protected TransportElement findTransportElement() {
        List children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (9 == ((TagElement)children.get(i)).getTagCode()) {
                return (TransportElement)children.get(i);
            }
            ++i;
        }
        i = 0;
        while (i < children.size()) {
            if (97 == ((TagElement)children.get(i)).getTagCode()) {
                return (TransportElement)children.get(i);
            }
            ++i;
        }
        return null;
    }

    protected void generateSpecificClass() throws Exception {
        IType transport = this.createTransportType();
        this.codeConstructors(transport);
        this.codeFields(transport);
        this.codeMethods(transport);
        this.generateMessageClass(this.isLazy(), this.initializeWithMethods());
        this.generateCustomMainItems();
    }

    protected String getBACreateServiceContents() {
        String type = this.fTransport.getType();
        String superclass = this.fTransport.getSuperClass();
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("final ");
        this.fBundleActivatorModel.addImport(superclass);
        buffer.append(DeviceKitUtilities.stripPackage(superclass));
        buffer.append(" transport = new ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        this.fBundleActivatorModel.addImport(type);
        buffer.append("();\n");
        if (this.connection) {
            buffer.append("transport.setConnection(");
            buffer.append("connection");
            buffer.append(");\n");
        } else if (this.tunnel) {
            buffer.append("tranpsort.setTransport(");
            buffer.append("transportService");
            buffer.append(");\n");
        }
        buffer.append("return transport;\n");
        return buffer.toString();
    }

    protected String getBAGetDefaultConnectionContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return");
        buffer.append(' ');
        buffer.append(String.valueOf(this.getMainClassName()) + '.' + "getDefaultConnection" + "();");
        this.fTransportModel.addImport(this.getMainFqn());
        return buffer.toString();
    }

    protected String getBAGetInterestServiceNameContents(String service) {
        String tservice = service;
        if (tservice.indexOf(46) != -1) {
            this.fBundleActivatorModel.addImport(tservice);
        }
        if (!tservice.endsWith("Service")) {
            tservice = String.valueOf(tservice) + "Service";
        }
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return ");
        buffer.append(DeviceKitUtilities.stripPackage(tservice));
        buffer.append(".SERVICE_NAME;");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        return "";
    }

    protected String getBundleActivatorComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append("<p>The transport bundle activator class creates and registers the " + this.getMainClassName() + " transport.\n");
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected String getCommonClassComment() {
        Map properties;
        StringBuffer buffer = new StringBuffer(256);
        Map[] propertiesArray = this.getProperties();
        buffer.append("<p>The Device Kit properties CONNECTION_KEYS and default values.\n");
        int indentation = 0;
        buffer.append(this.getHtmlHelper().startTable(indentation));
        ++indentation;
        int i = 0;
        while (i < propertiesArray.length) {
            properties = propertiesArray[i];
            if (properties.size() > 0) {
                buffer.append(" \n");
                Iterator iterator = properties.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String key2 = key;
                    if (!key2.startsWith(this.getMainClassName().toLowerCase())) {
                        key2 = String.valueOf(this.getMainClassName().toLowerCase()) + '.' + key2;
                    }
                    String[] dataEntries = new String[]{key2, (String)properties.get(key)};
                    buffer.append(this.getHtmlHelper().getTableRow(indentation, dataEntries));
                }
            }
            ++i;
        }
        --indentation;
        indentation = 0;
        buffer.append(this.getHtmlHelper().endTable(indentation));
        i = 0;
        while (i < propertiesArray.length) {
            properties = propertiesArray[i];
            buffer.append(" \n");
            String[] xmp = new String[properties.size()];
            int count = 0;
            Iterator iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String key2 = key;
                if (!key2.startsWith(this.getMainClassName().toLowerCase())) {
                    key2 = String.valueOf(this.getMainClassName().toLowerCase()) + '.' + key2;
                }
                xmp[count++] = String.valueOf(key2) + '=' + (String)properties.get(key);
            }
            buffer.append(this.getHtmlHelper().getExample(indentation, xmp));
            buffer.append(" \n");
            ++i;
        }
        String importedServices = this.getImportedServiceComment();
        buffer.append(importedServices);
        if (importedServices.length() > 0) {
            buffer.append(" \n");
        }
        String exportedServices = this.getExportedServiceComment();
        buffer.append(exportedServices);
        if (exportedServices.length() > 0) {
            buffer.append(" \n");
        }
        buffer.append(super.getCommonClassComment());
        return buffer.toString();
    }

    protected String getConfLong() {
        StringBuffer buffer = new StringBuffer(32);
        String type = this.fTransport.getType();
        if (this.getTransportConfigurationKey() == null) {
            buffer.append(String.valueOf(DeviceKitUtilities.stripPackage(type)) + ".getDefaultResponseTimeout()");
        } else {
            buffer.append("getLong(");
            buffer.append(this.quote(String.valueOf(this.getTransportConfigurationKey()) + ".responsetimeout"));
            buffer.append(", ");
            buffer.append(String.valueOf(DeviceKitUtilities.stripPackage(type)) + ".getDefaultResponseTimeout()");
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String getConnection() {
        NewCodeGenerator generator = new NewCodeGenerator(this.getMainFqn(), this.getMessageFqn(), this.getServiceFqn());
        String result = generator.getNewCode(1, this.fTransport);
        List imports = generator.getImports();
        int i = 0;
        while (i < imports.size()) {
            String importedItem = (String)imports.get(i);
            this.fBundleActivatorModel.addImport(importedItem);
            String importedPack = DeviceKitUtilities.extractPackage(importedItem);
            this.getManifestModel().addImportPackage(importedPack);
            ++i;
        }
        return result;
    }

    protected String getDefaultConnectionMethodContents(NewCodeGenerator generator, IConnectionItem connectionItem) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("return ");
        buffer.append(generator.getNewCode(0, (TagElement)((Object)connectionItem)));
        buffer.append(";\n");
        return buffer.toString();
    }

    protected String getDefaultConnectionMethodName(IConnectionItem connectionItem) {
        String methodName = "getDefault";
        String connectionName = this.getDefaultConnectionName(connectionItem);
        methodName = String.valueOf(methodName) + connectionName;
        return methodName;
    }

    public String getDefaultConnectionName(IConnectionItem connectionItem) {
        String implementation = connectionItem.getType();
        String methodName = CoreUtility.stripPackage(implementation);
        return methodName;
    }

    protected String getDefaultConnectionServiceName(IConnectionItem connectionItem) {
        String methodName = this.getDefaultConnectionName(connectionItem);
        if ("ConnectionConnection".equals(methodName)) {
            methodName = "Connection";
        }
        methodName = String.valueOf(methodName) + "Service";
        return methodName;
    }

    protected String getDeviceCategory() {
        return DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
    }

    protected String getExportedServiceComment() {
        StringBuffer buffer = new StringBuffer(64);
        List exports = this.getExportedServices();
        if (exports.size() > 0) {
            buffer.append("<p>The list of exported services:\n");
            int i = 0;
            while (i < exports.size()) {
                buffer.append("@see " + exports.get(i) + "\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    protected List getExportedServices() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getServiceFqn());
        result.add(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        return result;
    }

    protected String getGetDefaultConnectionContents(IType transport) {
        NewCodeGenerator gen = new NewCodeGenerator(this.getMainFqn(), this.getMessageFqn(), this.getServiceFqn());
        List connChildren = this.fTransport.getConnectionChildren();
        StringBuffer buffer = new StringBuffer(128 * connChildren.size());
        IConnectionItem defaultConnection = (IConnectionItem)connChildren.get(0);
        if (connChildren.size() > 1) {
            buffer.append("final String type = ");
            String tag = defaultConnection.getConnectionConstant();
            buffer.append(this.getConfString((TagElement)((Object)defaultConnection), "connection", tag));
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(this.getConfigurationKey(this.getMainElement())) + ".connection", defaultConnection.getConnectionType());
            buffer.append(";\n");
            int i = 1;
            while (i < connChildren.size()) {
                IConnectionItem item = (IConnectionItem)connChildren.get(i);
                buffer.append('\t');
                if (i > 1) {
                    buffer.append("\n\t} else ");
                }
                buffer.append("if (type.equals(");
                String typeName = item.getConnectionConstant();
                buffer.append(typeName);
                EscPropertiesModel.getModel(this).addProperty(String.valueOf(this.getConfigurationKey(this.getMainElement())) + ".connection", item.getConnectionType());
                buffer.append(")) {\n");
                buffer.append("\t\treturn ");
                String methodName = this.createDefaultConnectionMethod(gen, transport, item);
                buffer.append(methodName);
                buffer.append("()");
                buffer.append(";\n");
                buffer.append('\n');
                ++i;
            }
            buffer.append("}\n");
        } else {
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(this.getConfigurationKey(this.getMainElement())) + ".connection", this.unquote("none"));
        }
        buffer.append(" return ");
        String methodName = this.createDefaultConnectionMethod(gen, transport, defaultConnection);
        buffer.append(methodName);
        buffer.append("()");
        buffer.append(";\n");
        buffer.append('\n');
        List imports = gen.getImports();
        int i = 0;
        while (i < imports.size()) {
            String importedItem = (String)imports.get(i);
            this.fTransportModel.addImport(importedItem);
            String importedPack = DeviceKitUtilities.extractPackage(importedItem);
            this.getManifestModel().addImportPackage(importedPack);
            ++i;
        }
        return buffer.toString();
    }

    protected String getGetDefaultResponseTimeOutContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return ");
        String rt = this.getTransportElement().getResponseTimeout();
        buffer.append(this.getConfLong(this.getMainElement(), "responsetimeout", rt));
        buffer.append(";\n");
        return buffer.toString();
    }

    protected String getGetDefaultTransportContents(String transportServiceName) {
        StringBuffer buffer = new StringBuffer(64);
        if (this.fTransport.getTransportServiceChildren().size() > 0) {
            TransportServiceElement te = (TransportServiceElement)this.fTransport.getTransportServiceChildren().get(0);
            if (transportServiceName == null) {
                buffer.append("return null;");
            } else {
                String implementation = te.getAttribute("implementation");
                if (implementation == null) {
                    implementation = transportServiceName;
                }
                buffer.append("return (");
                buffer.append(DeviceKitUtilities.stripPackage(transportServiceName));
                buffer.append(") loadService(");
                buffer.append(DeviceKitUtilities.stripPackage(transportServiceName));
                buffer.append(".SERVICE_NAME, \"");
                buffer.append(implementation);
                buffer.append("\");");
            }
        } else {
            buffer.append("return null;");
        }
        return buffer.toString();
    }

    protected String getGetRetryTimeContents() {
        String retryTime = this.fTransport.getRetryTime();
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return getLong(");
        buffer.append(this.quote(String.valueOf(this.getConfigurationKey(this.fTransport)) + ".retrytime"));
        buffer.append(", ");
        buffer.append(retryTime);
        buffer.append(");");
        return buffer.toString();
    }

    protected String getImportedServiceComment() {
        StringBuffer buffer = new StringBuffer(64);
        List imports = this.getImportedServices();
        if (imports.size() > 0) {
            buffer.append("<p>The list of imported services:\n");
            int i = 0;
            while (i < imports.size()) {
                buffer.append("@see " + imports.get(i) + "\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    protected List getImportedServices() {
        return this.getServices();
    }

    protected String getMainClassComment() {
        StringBuffer buffer = new StringBuffer(128);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected MainTagElement getMainElement() {
        return this.getTransportElement();
    }

    public JavaFileModel getMainModel() {
        return this.fTransportModel;
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    protected List getManifestExportPackages() {
        List vector = super.getManifestExportPackages();
        vector.add(DeviceKitUtilities.extractPackage(this.fTransport.getType()));
        vector.add(this.getServicePackage());
        return vector;
    }

    protected List getManifestImportPackages() {
        int i;
        List vector = super.getManifestImportPackages();
        String[] imports = null;
        if (this.fTransportModel != null) {
            imports = this.fTransportModel.getImports();
            i = 0;
            while (i < imports.length) {
                if (!this.inThisBundle(imports[i])) {
                    vector.add(DeviceKitUtilities.extractPackage(imports[i]));
                }
                ++i;
            }
        }
        if (this.fServiceModel != null) {
            imports = this.fServiceModel.getImports();
            i = 0;
            while (i < imports.length) {
                if (!this.inThisBundle(imports[i])) {
                    vector.add(DeviceKitUtilities.extractPackage(imports[i]));
                }
                ++i;
            }
        }
        if (this.fBundleActivatorModel != null) {
            imports = this.fBundleActivatorModel.getImports();
            i = 0;
            while (i < imports.length) {
                if (!this.inThisBundle(imports[i])) {
                    vector.add(DeviceKitUtilities.extractPackage(imports[i]));
                }
                ++i;
            }
        }
        vector.add(DeviceKitGenerationConstants.PACKAGE_CONNECTION_BUNDLE);
        vector.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE));
        vector.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_CONSTANTS));
        return vector;
    }

    protected String getMetaDataProperties() {
        TransportFactoryMetaDataBuilder builder = new TransportFactoryMetaDataBuilder(this, 0);
        return builder.getMetaDataPropertiesContents();
    }

    protected Map getOsgiProperties(JavaFileModel model) {
        Map table = super.getOsgiProperties(model);
        table.put("org.osgi.service.device.Constants.DRIVER_ID", this.quote(this.fTransport.getBundleName()));
        table.put("org.osgi.service.device.Constants.DEVICE_CATEGORY", this.quote(this.getDeviceCategory()));
        String trans = this.getMainClassName();
        if (trans.endsWith("Transport")) {
            int index = trans.lastIndexOf("Transport");
            trans = trans.substring(0, index);
        }
        table.put("org.eclipse.soda.dk.connection.bundle.ServiceBundle.DEVICE_CLASS", this.quote(trans));
        table.put("org.osgi.framework.Constants.SERVICE_RANKING", this.quote("" + this.getDefaultRanking()));
        String pid = this.getServiceClass();
        if (pid != null) {
            model.addImport(this.getServiceFqn());
            table.put("org.osgi.framework.Constants.SERVICE_PID", String.valueOf(pid) + ".SERVICE_NAME");
        }
        return table;
    }

    protected String getPriority() {
        return null;
    }

    protected String getProcessInputContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return");
        buffer.append(' ');
        buffer.append("super");
        buffer.append('.');
        buffer.append("processInput");
        buffer.append('(');
        buffer.append("bytes");
        buffer.append(", ");
        buffer.append("length");
        buffer.append(')');
        buffer.append(';');
        return buffer.toString();
    }

    public Map[] getProperties() {
        return this.fTransport.getTransportProperties();
    }

    protected String getServiceFileComment() {
        StringBuffer buffer = new StringBuffer(128);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(Nls.format(DeviceKitGenerator.getResource("DkTransportGenerator.service.class.comment1"), this.getMainClassName()));
        buffer.append(" \n");
        buffer.append(this.getImportedServiceComment());
        buffer.append(" \n");
        buffer.append(this.getExportedServiceComment());
        buffer.append(" \n");
        buffer.append(super.getCommonClassComment());
        return buffer.toString();
    }

    protected String[] getServiceInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        List exportedService = this.fTransport.getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < exportedService.size()) {
            if (((TagElement)exportedService.get(i)).getTextData() != null) {
                result.add(((TagElement)exportedService.get(i)).getTextData());
            }
            ++i;
        }
        String[] serviceInterfaces = new String[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            serviceInterfaces[i2] = (String)result.get(i2);
            ++i2;
        }
        return serviceInterfaces;
    }

    protected List getServices() {
        String service;
        ArrayList<String> result = new ArrayList<String>();
        if (this.fTransport != null && (service = this.fTransport.getAttribute("service")) != null) {
            if (service.indexOf(46) == -1) {
                String p = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                service = String.valueOf(p) + '.' + service;
            }
            result.add(service);
        }
        return result;
    }

    protected String getSetUpComment(List parameters, String retryTime, String noActivityTimeout, String transmitRetries) {
        String tretryTime = retryTime;
        String ttransmitRetries = transmitRetries;
        String tnoActivityTimeout = noActivityTimeout;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Sets user-defined variables to use in the test.\n");
        buffer.append('\n');
        buffer.append("<p>User defined properties and default values.\n");
        int indentation = 0;
        buffer.append(this.getHtmlHelper().startTable(indentation));
        ++indentation;
        int i = 0;
        while (i < parameters.size()) {
            String defValue;
            CustomParameterElement element = (CustomParameterElement)parameters.get(i);
            String key = element.getAttribute("name");
            String key2 = key;
            if (!key2.startsWith(this.getMainClassName().toLowerCase())) {
                key2 = String.valueOf(this.getMainClassName().toLowerCase()) + '.' + key2;
            }
            if ((defValue = element.getAttribute("defaultvalue")) == null) {
                defValue = "";
            }
            String[] dataEntries = new String[]{key2, defValue};
            buffer.append(this.getHtmlHelper().getTableRow(indentation, dataEntries));
            ++i;
        }
        if (tretryTime == null) {
            tretryTime = "RETRY_TIME_DEFAULT";
        }
        buffer.append(this.getHtmlHelper().getTableRow(indentation, new String[]{"retrytime", tretryTime}));
        if (ttransmitRetries == null) {
            ttransmitRetries = "TRANSMIT_RETRIES_DEFAULT";
        }
        buffer.append(this.getHtmlHelper().getTableRow(indentation, new String[]{"transmitretries", ttransmitRetries}));
        if (tnoActivityTimeout == null) {
            tnoActivityTimeout = "NO_ACTIVITY_TIMEOUT_DEFAULT";
        }
        buffer.append(this.getHtmlHelper().getTableRow(indentation, new String[]{"noactivitytimeout", tnoActivityTimeout}));
        buffer.append(this.getHtmlHelper().endTable(--indentation));
        buffer.append(" \n");
        if (parameters.size() > 0) {
            String[] xmp = new String[parameters.size()];
            int count = 0;
            int i2 = 0;
            while (i2 < parameters.size()) {
                String defValue;
                CustomParameterElement element = (CustomParameterElement)parameters.get(i2);
                String key = element.getAttribute("name");
                String key2 = key;
                if (!key2.startsWith(this.getMainClassName().toLowerCase())) {
                    key2 = String.valueOf(this.getMainClassName().toLowerCase()) + '.' + key2;
                }
                if ((defValue = element.getAttribute("defaultvalue")) == null) {
                    defValue = "";
                }
                xmp[count++] = String.valueOf(key2) + '=' + defValue;
                ++i2;
            }
            buffer.append(this.getHtmlHelper().getExample(indentation, xmp));
        }
        buffer.append("\n@see org.eclipse.soda.dk.transport.Transport#setup()\n");
        return buffer.toString();
    }

    protected String getSetUpContents(IType transport) {
        TransportElement element = this.getTransportElement();
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("super.setup();\n");
        List parameters = element.getAllChildrenWithTagCode(46);
        int size = parameters.size();
        if (size > 0) {
            EscPropertiesModel.getModel(this).addComment("Define custom transport configuration parameters");
            int i = 0;
            while (i < parameters.size()) {
                CustomParameterElement parameter = (CustomParameterElement)parameters.get(i);
                ConfigurationField field = new ConfigurationField(parameter);
                this.processConfiguration(field, buffer, transport);
                ++i;
            }
        }
        EscPropertiesModel.getModel(this).addComment("Define transport configuration parameters");
        String configKey = this.getConfigurationKey(element);
        String retryTime = element.getRetryTime();
        String defaultValue = null;
        String defaultValueConstant = "1000";
        if (retryTime != null) {
            defaultValue = retryTime;
            defaultValueConstant = retryTime;
        } else {
            defaultValue = "getRetryTime()";
        }
        buffer.append("setRetryTime(");
        buffer.append(this.getConfLong(element, "retrytime", defaultValue));
        buffer.append(");\n");
        if (configKey != null) {
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + "retrytime".toLowerCase(), defaultValueConstant);
        }
        String priority = element.getPriority();
        defaultValue = null;
        defaultValueConstant = "-1";
        if (priority != null) {
            defaultValue = priority;
            defaultValueConstant = priority;
        } else {
            defaultValue = "getPriority()";
        }
        buffer.append("setPriority(");
        buffer.append(this.getConfInt(element, "priority", defaultValue));
        buffer.append(");\n");
        if (configKey != null) {
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + "priority".toLowerCase(), defaultValueConstant);
        }
        String notificationPriority = element.getNotificationPriority();
        defaultValue = null;
        defaultValueConstant = "-1";
        if (notificationPriority != null) {
            defaultValue = notificationPriority;
            defaultValueConstant = notificationPriority;
        } else {
            defaultValue = "getNotificationPriority()";
        }
        buffer.append("setNotificationPriority(");
        buffer.append(this.getConfInt(element, "notificationpriority", defaultValue));
        buffer.append(");\n");
        if (configKey != null) {
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + "notificationpriority".toLowerCase(), defaultValueConstant);
        }
        String transmitRetries = element.getTransmitRetries();
        defaultValue = null;
        defaultValueConstant = "0";
        if (transmitRetries != null) {
            defaultValue = transmitRetries;
            defaultValueConstant = transmitRetries;
        } else {
            defaultValue = "getTransmitRetries()";
        }
        buffer.append("setTransmitRetries(");
        buffer.append(this.getConfInt(element, "transmitretries", defaultValue));
        buffer.append(");\n");
        if (configKey != null) {
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + "transmitretries".toLowerCase(), defaultValueConstant);
        }
        String noActivityTimeout = element.getNoActivityTimeout();
        defaultValueConstant = "10000";
        if (noActivityTimeout != null) {
            defaultValue = noActivityTimeout;
            defaultValueConstant = noActivityTimeout;
        } else {
            defaultValue = "getNoActivityTimeout()";
        }
        buffer.append("setNoActivityTimeout(");
        buffer.append(this.getConfLong(element, "noactivitytimeout", defaultValue));
        if (configKey != null) {
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + "noactivitytimeout".toLowerCase(), defaultValueConstant);
        }
        buffer.append(");\n");
        return buffer.toString();
    }

    protected String getTransport() {
        return "";
    }

    protected String getTransportConfigurationKey() {
        String key = this.fTransport.getAttribute("bundle");
        if (key != null && key.length() > 0) {
            return key.toLowerCase();
        }
        TagElement parent = this.fTransport.getParent();
        if (parent != null && (key = parent.getAttribute("bundle")) != null && key.length() > 0) {
            return key.toLowerCase();
        }
        key = this.fTransport.getKey();
        if (key != null && key.length() > 0) {
            return key.toLowerCase();
        }
        return null;
    }

    protected TransportElement getTransportElement() {
        return this.fTransport;
    }

    protected String getTransportStyle() {
        StringBuffer buffer = new StringBuffer(64);
        String priority = this.getPriority();
        if (priority != null && priority.length() > 0) {
            buffer.append("(short)");
            buffer.append(priority);
        } else {
            buffer.append(DeviceKitUtilities.stripPackage(this.fTransport.getType()));
            this.fBundleActivatorModel.addImport(this.fTransport.getType());
            buffer.append(".getDefaultStyle()");
        }
        return buffer.toString();
    }

    protected String getType() {
        return "transport";
    }

    protected String getWriteContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("super");
        buffer.append('.');
        buffer.append("write");
        buffer.append('(');
        buffer.append("message");
        buffer.append(')');
        buffer.append(';');
        return buffer.toString();
    }

    protected void initialize() {
        TransportElement element = this.findTransportElement();
        this.setTransportElement(element);
        this.setPackageBase(element.getPackageBase());
        this.setMainTagElement(element);
        String className = DeviceKitUtilities.getClassNameFromTagElement(element);
        this.setMainClassName(className);
        String transportClass = this.getMainClassName();
        this.fTransportModel = new JavaFileModel(transportClass);
        this.pack = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
        this.setMainPackage(this.pack);
        if (element.getConnectionChildren().size() > 0) {
            this.connection = true;
            if (element.getResponseTimeout() != null) {
                this.response = true;
            }
        } else if (element.getTransportServiceChildren().size() > 0) {
            this.tunnel = true;
        }
        this.getManifestModel().addImportPackage(DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT));
        String lazyString = element.getAttribute("lazy");
        if (lazyString == null || "false".equals(lazyString)) {
            this.setIsLazy(false);
        } else {
            this.setIsLazy(true);
        }
        String initMethodString = element.getAttribute("createmethod");
        if (initMethodString == null || "false".equals(initMethodString)) {
            this.setInitializeWithMethods(false);
        } else {
            this.setInitializeWithMethods(true);
        }
        super.initialize();
    }

    private boolean initializeWithMethods() {
        return this.initWithMethods;
    }

    protected boolean inThisBundle(String string) {
        String packageOnly = DkUtilities.extractPackage(string);
        if (super.inThisBundle(packageOnly)) {
            return true;
        }
        return packageOnly.equals(this.getMessagePackage());
    }

    protected boolean isAbstract() {
        return this.getTransportElement().isAbstract();
    }

    private boolean isLazy() {
        return this.isLazy;
    }

    private void processConfiguration(ConfigurationField field, StringBuffer buffer, IType transport) {
        String defaultValue;
        CustomParameterElement parameter = field.getCustomParameterElement();
        MainTagElement element = this.getMainElement();
        String configKey = this.getConfigurationKey(element);
        field.setQualifiedName("");
        String name = parameter.getAttribute("name");
        String capName = DeviceKitUtilities.capitalizeFirstLetter(name);
        parameter.getAttribute("type");
        String key = name;
        String defaultValueContents = "get" + capName + "()";
        String contents = NewCodeGenerator.getConfiguration(field, element, key, defaultValueContents);
        buffer.append("set" + capName + '(' + contents + ");\n");
        if (parameter.getAttribute("access") == null || parameter.getAttribute("access").equals("true")) {
            this.codeParameterAccess(field, transport, element);
        }
        if ((defaultValue = parameter.getAttribute("defaultvalue")) != null && configKey != null) {
            String fullKey = (String.valueOf(configKey) + '.' + name).toLowerCase();
            EscPropertiesModel.getModel(this).addProperty(fullKey, defaultValue);
        }
    }

    public List save(boolean keepCustom, IProgressMonitor progressMonitor) throws Exception {
        List superResult = super.save(progressMonitor);
        ArrayList<Object> result = new ArrayList<Object>();
        this.fTransportModel.setSaver(this.getSaver());
        this.fTransportModel.setSortOrder(3L);
        Object transport = this.fTransportModel.save(progressMonitor);
        if (transport != null) {
            result.add(transport);
        }
        return DeviceKitUtilities.mergeLists(result, superResult);
    }

    public List save(IProgressMonitor progressMonitor) throws Exception {
        return this.save(false, progressMonitor);
    }

    private void setInitializeWithMethods(boolean init) {
        this.initWithMethods = init;
    }

    private void setIsLazy(boolean lazy) {
        this.isLazy = lazy;
    }

    protected void setTransportElement(TransportElement transport) {
        this.fTransport = transport;
    }
}

