/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.metadata.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedTypeInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.MetaDataInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.TypeInformation;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;

public class GeneratedInfo
implements IGeneratorModel {
    private List allTypes = new ArrayList();

    public TypeInformation addTypeInformation(String packageName, String typeName, String dkmlVersion, String project) {
        TypeInformation typeInfo = this.getTypeInformation(packageName, typeName);
        if (typeInfo == null) {
            typeInfo = new GeneratedTypeInformation(packageName, typeName, dkmlVersion);
            this.allTypes.add(typeInfo);
            typeInfo.setProject(project);
        } else if (typeInfo.getProject() == null) {
            typeInfo.setProject(project);
        }
        return typeInfo;
    }

    private XmlModel createXmlModel() {
        XmlModel model = new XmlModel(".dkmetadata");
        IXmlElement rootElement = model.add("dk-meta");
        List sortedTypes = this.sort(this.allTypes);
        int i = 0;
        while (i < sortedTypes.size()) {
            String projectName;
            TypeInformation info = (TypeInformation)sortedTypes.get(i);
            IXmlElement typeElement = rootElement.add("type");
            typeElement.addAttribute("package", info.getPackageName());
            typeElement.addAttribute("name", info.getTypeName());
            typeElement.addAttribute("created", info.getTimeStamp());
            typeElement.addAttribute("created-pretty", info.getPrettyTimeStamp());
            String dkmlVerison = info.getDkmlVersion();
            if (dkmlVerison != null) {
                typeElement.addAttribute("version", dkmlVerison);
            }
            if ((projectName = info.getProject()) != null) {
                typeElement.addAttribute("project-name", projectName);
            }
            MetaDataInformation[] fields = this.sort(info.getFields());
            int j = 0;
            while (j < fields.length) {
                if (!fields[j].isOld()) {
                    IXmlElement fieldElement = typeElement.add("field");
                    fieldElement.addAttribute("key", fields[j].getKey());
                    fieldElement.addAttribute("created", fields[j].getTimeStamp());
                    fieldElement.addAttribute("created-pretty", fields[j].getPrettyTimeStamp());
                    fieldElement.addAttribute("version", fields[j].getDkmlVersion());
                }
                ++j;
            }
            MetaDataInformation[] methods = this.sort(info.getMethods());
            int j2 = 0;
            while (j2 < methods.length) {
                if (!methods[j2].isOld()) {
                    IXmlElement methodElement = typeElement.add("method");
                    methodElement.addAttribute("key", methods[j2].getKey());
                    methodElement.addAttribute("created", methods[j2].getTimeStamp());
                    methodElement.addAttribute("created-pretty", methods[j2].getPrettyTimeStamp());
                    methodElement.addAttribute("version", methods[j2].getDkmlVersion());
                }
                ++j2;
            }
            ++i;
        }
        return model;
    }

    public String getContents() {
        XmlModel model = this.createXmlModel();
        return model.getContents();
    }

    public TypeInformation getTypeInformation(String packageName, String typeName) {
        TypeInformation[] types = this.getTypes();
        int i = 0;
        while (i < types.length) {
            TypeInformation info = types[i];
            if (info.getPackageName().equals(packageName) && info.getTypeName().equals(typeName)) {
                return info;
            }
            ++i;
        }
        return null;
    }

    public TypeInformation[] getTypes() {
        TypeInformation[] result = new TypeInformation[this.allTypes.size()];
        this.allTypes.toArray(result);
        return result;
    }

    public void prepareOldElement(String defaultCmlVersion) {
        int i = 0;
        while (i < this.allTypes.size()) {
            GeneratedTypeInformation typeInfo = (GeneratedTypeInformation)this.allTypes.get(i);
            typeInfo.prepareOldElements(defaultCmlVersion);
            ++i;
        }
    }

    private List sort(List original) {
        ArrayList<MetaDataInformation> sortedList = new ArrayList<MetaDataInformation>();
        int i = 0;
        while (i < original.size()) {
            MetaDataInformation currInfo = (MetaDataInformation)original.get(i);
            if (i == 0) {
                sortedList.add(currInfo);
            } else {
                String currTypeKey = currInfo.getKey();
                int j = sortedList.size();
                while (j > 0) {
                    MetaDataInformation previousInfo = (MetaDataInformation)sortedList.get(j - 1);
                    String prevoiusKey = previousInfo.getKey();
                    if (currTypeKey.compareToIgnoreCase(prevoiusKey) >= 0) break;
                    --j;
                }
                if (j >= sortedList.size()) {
                    sortedList.add(currInfo);
                } else {
                    sortedList.add(j, currInfo);
                }
            }
            ++i;
        }
        return sortedList;
    }

    private MetaDataInformation[] sort(MetaDataInformation[] original) {
        List<MetaDataInformation> list = Arrays.asList(original);
        List sorted = this.sort(list);
        sorted.toArray(original);
        return original;
    }
}

