/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.ant;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.model.ant.AntModel;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;

public class JUnitSaver
implements IFileSaver {
    private IJavaProject project;

    public JUnitSaver(IJavaProject project) {
        this.project = project;
    }

    private IFolder getSaveFolder() {
        try {
            IResource[] resources = this.project.getProject().members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFolder && resources[i].getName().toLowerCase().indexOf("junit") > 0) {
                    return (IFolder)resources[i];
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public Object organize(IGeneratorModel object, IProgressMonitor progressMonitor) throws Exception {
        return null;
    }

    public Object save(AntModel model, IProgressMonitor progressMonitor) throws Exception {
        SubProgressMonitor subMonitor;
        block5: {
            IFile iFile;
            subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
            try {
                IFolder folder = this.getSaveFolder();
                if (folder == null) break block5;
                subMonitor.subTask(String.valueOf(model.getProjectName()) + '/' + model.getFileName());
                IFile file = folder.getFile(model.getFileName());
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(model.getContents().getBytes()), false, (IProgressMonitor)subMonitor);
                } else {
                    file.setContents((InputStream)new ByteArrayInputStream(model.getContents().getBytes()), true, true, (IProgressMonitor)subMonitor);
                }
                iFile = file;
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                subMonitor.done();
                throw throwable;
            }
            subMonitor.done();
            return iFile;
        }
        Object var6_8 = null;
        subMonitor.done();
        return null;
    }

    public Object save(IGeneratorModel object, IProgressMonitor progressMonitor) throws Exception {
        if (object instanceof AntModel) {
            return this.save((AntModel)object, progressMonitor);
        }
        return null;
    }
}

