/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;

public class DeviceKitUtilities {
    public static final int[] primes = new int[]{1, 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217};

    public static byte[] andMask(byte[] from, byte[] to) {
        if (from != null) {
            if (to != null) {
                if (from.length < to.length) {
                    byte[] result = new byte[from.length];
                    int j = 0;
                    while (j < from.length) {
                        result[j] = (byte)(to[j] & from[j]);
                        ++j;
                    }
                    return result;
                }
                byte[] result = new byte[to.length];
                int j = 0;
                while (j < to.length) {
                    result[j] = (byte)(to[j] & from[j]);
                    ++j;
                }
                return result;
            }
            byte[] result = new byte[from.length];
            int j = 0;
            while (j < from.length) {
                result[j] = from[j];
                ++j;
            }
            return result;
        }
        return to;
    }

    public static String capitalizeFirstLetter(String word) {
        StringBuffer buff = new StringBuffer();
        char c = word.charAt(0);
        c = Character.toUpperCase(c);
        buff.append(c);
        int i = 1;
        while (i < word.length()) {
            buff.append(word.charAt(i));
            ++i;
        }
        return buff.toString();
    }

    public static boolean caresAboutRate(TagElement element) {
        if (element instanceof ControlItem) {
            if (element.isChildOfCode(8)) {
                return element.getTagCode() == 1 || element.getTagCode() == 2;
            }
            if (element.isChildOfCode(18)) {
                return element.getTagCode() == 3 || element.getTagCode() == 2;
            }
        }
        return false;
    }

    public static final String character(String original) {
        StringBuffer buffer = new StringBuffer(original.length() + 2);
        buffer.append('\'');
        buffer.append(original);
        buffer.append('\'');
        return buffer.toString();
    }

    protected static String codeByte(byte value, String format) {
        StringBuffer buffer = new StringBuffer();
        if (value > 127 || value < -1) {
            buffer.append("(byte)");
        }
        if ("hex".equals(format) && (value > 9 || value < -1)) {
            buffer.append("0x");
            buffer.append(Integer.toHexString(value & 0xFF));
            return buffer.toString();
        }
        buffer.append(Integer.toString(value));
        return buffer.toString();
    }

    public static byte[] complement(byte[] original) {
        if (original != null) {
            int i = 0;
            while (i < original.length) {
                original[i] = ~original[i];
                ++i;
            }
        }
        return original;
    }

    public static String convertByteArrayToString(byte[] array, String format) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("new byte[]{");
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(DeviceKitUtilities.codeByte(array[i], format));
                ++i;
            }
        }
        buffer.append('}');
        return buffer.toString();
    }

    public static String[] convertStringToArray(String original) {
        return DeviceKitUtilities.convertStringToArray(original, "\n");
    }

    public static String[] convertStringToArray(String original, String delimiters) {
        if (original == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(original, delimiters, false);
        String[] result = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            result[count++] = st.nextToken();
        }
        return result;
    }

    public static String[] convertStringToArrayComments(String original) {
        return DeviceKitUtilities.convertStringToArrayComments(original, "\n");
    }

    public static String[] convertStringToArrayComments(String original, String delimiters) {
        if (original == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(original, delimiters, false);
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.length() > 100) {
                StringTokenizer tokenizer = new StringTokenizer(line, ".", false);
                while (tokenizer.hasMoreTokens()) {
                    String sentence = tokenizer.nextToken();
                    list.add(String.valueOf(sentence.trim()) + '.');
                }
                continue;
            }
            list.add(line.trim());
        }
        String[] result = new String[list.size()];
        result = list.toArray(result);
        return result;
    }

    public static String extractPackage(String fqn) {
        int index = fqn.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fqn.substring(0, index);
    }

    public static int gcd(int a, int b) {
        int ta = a;
        int tb = b;
        if (ta < 0) {
            ta = -ta;
        }
        if (tb < 0) {
            tb = -tb;
        }
        int r = tb;
        if (ta < tb) {
            r = ta;
            ta = tb;
        }
        while (r != 0) {
            tb = ta;
            ta = r;
            r = tb % ta;
        }
        if (ta == 0) {
            return 1;
        }
        return ta;
    }

    public static long gcd(long a, long b) {
        long ta = a;
        long tb = b;
        if (ta < 0L) {
            ta = -ta;
        }
        if (tb < 0L) {
            tb = -tb;
        }
        long r = tb;
        if (ta < tb) {
            r = ta;
            ta = tb;
        }
        while (r != 0L) {
            tb = ta;
            ta = r;
            r = tb % ta;
        }
        if (ta == 0L) {
            return 1L;
        }
        return ta;
    }

    public static String getClassNameFromTagElement(TagElement element) {
        String result = element.getAttribute("implementation");
        if (result != null) {
            return result;
        }
        return element.getId();
    }

    public static String getPackageFromClassName(String className, String packageBase) {
        StringBuffer buffer = new StringBuffer();
        if (packageBase != null && packageBase.length() > 0) {
            buffer.append(packageBase);
            buffer.append(".");
        }
        char[] chars = className.toCharArray();
        boolean lastLower = true;
        int i = 0;
        while (i < chars.length) {
            if (Character.isUpperCase(chars[i])) {
                if (i > 0) {
                    if (lastLower) {
                        buffer.append('.');
                    } else if (i + 1 < chars.length && Character.isLowerCase(chars[i + 1])) {
                        buffer.append('.');
                    }
                }
                lastLower = false;
            } else {
                lastLower = true;
            }
            if (chars[i] != ' ') {
                buffer.append(chars[i]);
            }
            ++i;
        }
        return buffer.toString().toLowerCase();
    }

    public static String getPackageFromUserName(String name, String packageBase) {
        if (name.startsWith(packageBase)) {
            return name;
        }
        int index = name.indexOf(46);
        if (index >= 0) {
            if (packageBase == null || packageBase.length() == 0) {
                return name;
            }
            return String.valueOf(packageBase) + '.' + name;
        }
        StringBuffer buffer = new StringBuffer();
        if (packageBase != null && packageBase.length() > 0) {
            buffer.append(packageBase);
            buffer.append(".");
        }
        char[] chars = name.toCharArray();
        boolean lastLower = true;
        int i = 0;
        while (i < chars.length) {
            if (Character.isUpperCase(chars[i])) {
                if (i > 0) {
                    if (lastLower) {
                        buffer.append('.');
                    } else if (i + 1 < chars.length && Character.isLowerCase(chars[i + 1])) {
                        buffer.append('.');
                    }
                }
                lastLower = false;
            } else {
                lastLower = true;
            }
            buffer.append(chars[i]);
            ++i;
        }
        return buffer.toString().toLowerCase();
    }

    public static int getPrime(int value) {
        int i = 0;
        while (i < primes.length) {
            if (value + 1 < primes[i]) {
                return primes[i];
            }
            ++i;
        }
        return value;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStringFromStream(InputStream stream) throws Exception {
        if (stream == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        byte[] bytes = new byte[1024];
        try {
            int read = stream.read(bytes);
            while (read > 0) {
                byte[] bytes2 = new byte[read];
                System.arraycopy(bytes, 0, bytes2, 0, read);
                String temp = new String(bytes2);
                buffer.append(temp);
                read = stream.read(bytes);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        stream.close();
        return buffer.toString();
    }

    public static String getYear() {
        return Integer.toString(Calendar.getInstance().get(1));
    }

    public static byte[] growByteArray(byte[] current, int length) {
        return DeviceKitUtilities.growByteArray(current, length, (byte)-1);
    }

    public static byte[] growByteArray(byte[] current, int length, byte filler) {
        byte[] newArray = new byte[length];
        System.arraycopy(current, 0, newArray, 0, current.length);
        int i = current.length;
        while (i < newArray.length) {
            newArray[i] = filler;
            ++i;
        }
        return newArray;
    }

    public static boolean isEqualString(String s1, String s2) {
        if (s1 == null || s2 == null || s1.trim().length() != s2.trim().length()) {
            return false;
        }
        int i = 0;
        while (i < s1.length()) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static long lcm(long a, long b) {
        long gcd = DeviceKitUtilities.gcd(a, b);
        long lcm = a * b / gcd;
        return lcm;
    }

    public static String makeFirstCharUpper(String string) {
        if (string.length() > 0) {
            String upper = string.substring(0, 1).toUpperCase();
            upper = String.valueOf(upper) + string.substring(1, string.length());
            return upper;
        }
        return string;
    }

    public static String makeString(String[] source, int bufferSize) {
        if (bufferSize < 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(bufferSize);
        int i = 0;
        while (i < source.length) {
            buffer.append(source[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static List mergeLists(List v1, List v2) {
        int i = 0;
        while (i < v2.size()) {
            v1.add(v2.get(i));
            ++i;
        }
        return v1;
    }

    public static byte[] orMask(byte[] from, byte[] to) {
        if (from != null) {
            if (to != null) {
                if (from.length < to.length) {
                    byte[] result = new byte[from.length];
                    int j = 0;
                    while (j < from.length) {
                        result[j] = (byte)(to[j] | from[j]);
                        ++j;
                    }
                    return result;
                }
                byte[] result = new byte[to.length];
                int j = 0;
                while (j < to.length) {
                    result[j] = (byte)(to[j] | from[j]);
                    ++j;
                }
                return result;
            }
            byte[] result = new byte[from.length];
            int j = 0;
            while (j < from.length) {
                result[j] = from[j];
                ++j;
            }
            return result;
        }
        return to;
    }

    public static final String quote(String original) {
        StringBuffer buffer = new StringBuffer(original.length() + 2);
        buffer.append('\"');
        buffer.append(original);
        buffer.append('\"');
        return buffer.toString();
    }

    public static String removeLastOccurence(String source, String removeString) {
        int index = source.lastIndexOf(removeString);
        if (index == -1) {
            return source;
        }
        return source.substring(0, index);
    }

    public static final boolean sameStream(InputStream stream1, InputStream stream2) throws IOException {
        int value1 = stream1.read();
        int value2 = stream2.read();
        while (value1 != -1 && value2 != -1) {
            if (value1 != value2) {
                return false;
            }
            value1 = stream1.read();
            value2 = stream2.read();
        }
        return value1 == value2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean sameStreamNoException(InputStream stream1, InputStream stream2) {
        try {
            boolean bl;
            try {
                bl = DeviceKitUtilities.sameStream(stream1, stream2);
                Object var2_3 = null;
            }
            catch (Exception exception) {}
            try {
                stream1.close();
                stream2.close();
                return bl;
            }
            catch (IOException iOException) {}
            return bl;
            Object var2_5 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            try {}
            catch (IOException iOException) {}
            stream1.close();
            stream2.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return false;
        }
        stream1.close();
        stream2.close();
        return false;
    }

    public static String stripPackage(String type) {
        int index = type.lastIndexOf(".");
        if (index == -1) {
            return type;
        }
        return type.substring(index + 1, type.length());
    }

    public static byte[] xorMask(byte[] from, byte[] to) {
        if (from != null) {
            if (to != null) {
                if (from.length < to.length) {
                    byte[] result = new byte[from.length];
                    int j = 0;
                    while (j < from.length) {
                        result[j] = (byte)(to[j] ^ from[j]);
                        ++j;
                    }
                    return result;
                }
                byte[] result = new byte[to.length];
                int j = 0;
                while (j < to.length) {
                    result[j] = (byte)(to[j] ^ from[j]);
                    ++j;
                }
                return result;
            }
            byte[] result = new byte[from.length];
            int j = 0;
            while (j < from.length) {
                result[j] = from[j];
                ++j;
            }
            return result;
        }
        return to;
    }
}

