/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.ConfigurationModel;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TcpipServerElement;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class UdpServerElement
extends TcpipServerElement
implements IConnectionItem {
    String packetSize;

    public UdpServerElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_UDP_SERVICE;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ConfigurationModel model = ConfigurationModel.getConnection("udpserver");
        return model.getConfigurationFields();
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_UDP_SERVICE));
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "udpserver";
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public String getPacketSize() {
        if (this.packetSize == null) {
            this.packetSize = "1";
        }
        return this.packetSize;
    }

    public Map getProperties() {
        HashMap<String, String> table = new HashMap<String, String>();
        if (this.getLocalHost() != null) {
            table.put("localhost", this.getLocalHost());
        }
        if (this.getLocalPort() != null) {
            table.put("localport", this.getLocalPort());
        }
        if (this.getPacketSize() != null) {
            table.put("packetsize", this.getPacketSize());
        }
        if (this.getRemoteHost() != null) {
            table.put("remotehost", this.getRemoteHost());
        }
        if (this.getRemotePort() != null) {
            table.put("remoteport", this.getRemotePort());
        }
        return table;
    }

    public int getTagCode() {
        return 135;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("packetsize".equals(childNodeName)) {
            this.setPacketSize(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    protected void setPacketSize(String packetSize) {
        this.packetSize = packetSize;
    }
}

