/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.StringTokenizer;
import org.eclipse.soda.devicekit.generator.model.elements.BytesItem;
import org.eclipse.soda.devicekit.generator.model.elements.DkgElementsMessages;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.BinaryOuputStream;
import org.eclipse.soda.devicekit.util.Nls;
import org.w3c.dom.Node;

public class NibblesElement
extends BytesItem {
    public NibblesElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public void append(BinaryOuputStream byteArrayOutputStream) {
        String cdata = this.getTextData();
        if (cdata == null) {
            cdata = "";
        }
        cdata = cdata.replace('\n', ' ');
        cdata = cdata.replace('\r', ' ');
        int length = this.getBitLengthValue(0);
        String format = this.getFormat();
        if ("ascii".equals(format)) {
            byte[] bytes = cdata.getBytes();
            byteArrayOutputStream.write(bytes, 0, bytes.length);
        } else {
            int base = this.getBase();
            StringTokenizer tokenizer = new StringTokenizer(cdata, " ,\t\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (base == 16) {
                    int i = 0;
                    while (i < token.length()) {
                        byteArrayOutputStream.writeNibble(this.nibbleCdata(token.substring(i, i + 1)));
                        ++i;
                    }
                    continue;
                }
                byteArrayOutputStream.writeNibble(this.nibbleCdata(token));
            }
        }
        if (length > 0) {
            int size;
            int i = size = byteArrayOutputStream.getLength();
            while (i < length) {
                byteArrayOutputStream.writeBinary(0);
                ++i;
            }
        }
    }

    public byte[] bytes() {
        String string = this.getTextData();
        if (string == null) {
            string = "";
        }
        return this.bytesCdata(string);
    }

    public byte[] bytesCdata(String cdata) {
        int length = this.getBitLengthValue(0);
        int requestedLength = length + 7 >> 3;
        BinaryOuputStream byteArrayOutputStream = length == 0 ? new BinaryOuputStream() : new BinaryOuputStream(requestedLength);
        this.append(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public int getTagCode() {
        return 25;
    }

    public int nibbleCdata(String cdata) {
        int base = this.getBase();
        try {
            short value;
            if (base == 0 || base == 10) {
                value = Byte.decode(cdata).shortValue();
            } else {
                value = Short.parseShort(cdata, base);
                if ((value & 0xFFF0) != 0) {
                    throw this.error(String.valueOf(Nls.format(DkgElementsMessages.getString("NibblesElement.error.invalid.nibble"), cdata)) + this.toString());
                }
            }
            return (byte)value;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.error(String.valueOf(Nls.format(DkgElementsMessages.getString("NibblesElement.error.invalid.byte"), cdata)) + this.toString());
        }
    }
}

