/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.metadata.DeviceKitMetaDataException;
import org.eclipse.soda.devicekit.generator.metadata.model.FieldInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.MethodInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.TypeInformation;

public class GeneratedTypeInformation
extends TypeInformation {
    private List methods = new ArrayList();
    private List fields = new ArrayList();

    public GeneratedTypeInformation(String packageName, String typeName, String dkmlVersion) {
        super(packageName, typeName, dkmlVersion);
    }

    public FieldInformation addFieldInformation(String fieldKey, Object data, String dkmlVersion) throws DeviceKitMetaDataException {
        FieldInformation info = this.getField(fieldKey);
        if (info != null) {
            info.markOld(false);
        } else {
            info = new FieldInformation(fieldKey, data, dkmlVersion);
            this.fields.add(info);
        }
        return info;
    }

    public MethodInformation addMethodInformation(String methodKey, Object data, String dkmlVersion) throws DeviceKitMetaDataException {
        MethodInformation info = this.getMethod(methodKey);
        if (info != null) {
            info.markOld(false);
        } else {
            info = new MethodInformation(methodKey, data, dkmlVersion);
            this.methods.add(info);
        }
        return info;
    }

    public FieldInformation[] getFields() {
        FieldInformation[] fis = new FieldInformation[this.fields.size()];
        this.fields.toArray(fis);
        return fis;
    }

    public MethodInformation[] getMethods() {
        MethodInformation[] mis = new MethodInformation[this.methods.size()];
        this.methods.toArray(mis);
        return mis;
    }

    public void prepareOldElements(String defaultCmlVersion) {
        int i = 0;
        while (i < this.fields.size()) {
            FieldInformation fi = (FieldInformation)this.fields.get(i);
            fi.markOld(true);
            if (fi.getDkmlVersion() == null) {
                fi.setDkmlVersion(defaultCmlVersion);
            }
            ++i;
        }
        i = 0;
        while (i < this.methods.size()) {
            MethodInformation mi = (MethodInformation)this.methods.get(i);
            mi.markOld(true);
            if (mi.getDkmlVersion() == null) {
                mi.setDkmlVersion(defaultCmlVersion);
            }
            ++i;
        }
    }
}

