/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.model.java;

import org.eclipse.soda.devicekit.generator.internal.model.java.JgfUtilities;
import org.eclipse.soda.devicekit.generator.model.java.IJavaElement;
import org.eclipse.soda.devicekit.generator.utilty.BitField;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;

public abstract class JavaElement
implements IJavaElement {
    private String[] fComment;
    private long fIdentifiers;
    private String fName;
    private int fFileType;
    private boolean generated = false;

    protected JavaElement(String name) {
        this.fName = name;
    }

    public String[] getComment() {
        return this.fComment;
    }

    public int getFileType() {
        return this.fFileType;
    }

    public String getIdentifiers() {
        return JgfUtilities.getIdentifierString(this.fIdentifiers);
    }

    public String getName() {
        return this.fName;
    }

    public boolean hasIdentifier(short identifier) {
        BitField bf = new BitField(this.fIdentifiers);
        return bf.isSet(identifier);
    }

    public boolean isClass() {
        return this.fFileType == 1;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isInterface() {
        return this.fFileType == 0;
    }

    public void setComment(String comment) {
        this.setComment(DkUtilities.convertStringToArray(comment));
    }

    public void setComment(String[] comment) {
        this.fComment = comment;
    }

    public void setFileType(int fileType) {
        this.fFileType = fileType;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public void setIdentifiers(long identifiers) {
        this.fIdentifiers = identifiers;
    }
}

