/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.model.elements.AsciiMessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.StringMessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.Utf8MessageElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class WriteCommandElement
extends TagElement {
    private String fRate;

    public WriteCommandElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getRate() {
        return this.fRate;
    }

    public int getTagCode() {
        return 45;
    }

    protected void handleAsciiMessage(Node node) {
        String messageId;
        AsciiMessageElement me = new AsciiMessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
        if (this.getId() != null && (messageId = this.getIdForMessage(this.getId(), me)) != null) {
            me.setAttribute("id", messageId);
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("rate".equals(childNodeName)) {
            this.setRate(ParserUtilities.extractData(childNode));
        } else if ("message".equals(childNodeName)) {
            this.handleMessage(childNode);
        } else if ("stringmessage".equals(childNodeName)) {
            this.handleStringMessage(childNode);
        } else if ("utf8message".equals(childNodeName)) {
            this.handleUtf8Message(childNode);
        } else if ("asciimessage".equals(childNodeName)) {
            this.handleAsciiMessage(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleMessage(Node node) {
        String messageId;
        MessageElement me = new MessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
        if (this.getId() != null && (messageId = this.getIdForMessage(this.getId(), me)) != null) {
            me.setAttribute("id", messageId);
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleStringMessage(Node node) {
        String messageId;
        StringMessageElement me = new StringMessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
        if (this.getId() != null && (messageId = this.getIdForMessage(this.getId(), me)) != null) {
            me.setAttribute("id", messageId);
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    protected void handleUtf8Message(Node node) {
        String messageId;
        Utf8MessageElement me = new Utf8MessageElement(node, this);
        this.addChild(me);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
        if (this.getId() != null && (messageId = this.getIdForMessage(this.getId(), me)) != null) {
            me.setAttribute("id", messageId);
            try {
                TagElement.collection.addMessage(me.getId(), me);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    public void setRate(String rate) {
        this.fRate = rate;
    }
}

