/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkAdapterGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkProfileGenerator
extends DkAdapterGenerator {
    private AdapterElement targetAdapter = null;

    public DkProfileGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkProfileGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map table, int bundleType) {
        super(model, generatedInfo, table, bundleType);
    }

    protected void codeAdapterField(IType device) {
        AdapterElement adapter = this.getTargetAdapter();
        if (adapter != null) {
            String type = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE);
            this.fDeviceModel.addImport(DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE);
            this.codeField(device, "adapter", type, 2L, "", "");
        }
    }

    protected void codeAdapterMethods(IType device) {
        boolean needed;
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("return ");
        AdapterElement adapter = this.getTargetAdapter();
        boolean bl = needed = adapter != null;
        if (needed) {
            String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE);
            this.codeMethod(device, "getAdapter", "", returnType, 1L, "return this.adapter;", new KeyValuePair[0], null);
            KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE), "adapter");
            this.codeMethod(device, "setAdapter", "", "void", 1L, "this.adapter = adapter;", new KeyValuePair[]{parameter}, null);
            buffer.append("true;");
        } else {
            buffer.append("false;");
        }
        if (needed || !this.isAbstract()) {
            this.codeMethod(device, "isAdapterNeeded", "", "boolean", 1L, buffer.toString());
        }
    }

    protected void codeFields(IType device) {
        super.codeFields(device);
        this.codeAdapterField(device);
    }

    protected void codeInterestFilterField(IType device) {
    }

    protected void codeMethods(IType device) throws Exception {
        super.codeMethods(device);
        this.codeAdapterMethods(device);
    }

    protected void codeServiceFields(IType service) {
        super.codeServiceFields(service);
        List parents = this.getDevice().getAllChildrenWithTagCode(83);
        String name = this.getMainClassName();
        if (parents.size() > 0) {
            TagElement parent = (TagElement)parents.get(0);
            List profileRefs = parent.getAllChildrenWithTagCode(86);
            int j = 0;
            while (j < profileRefs.size()) {
                TagElement profileRef = (TagElement)profileRefs.get(j);
                if (profileRef.getIdRaw() != null) {
                    String className = profileRef.getClassNameFull();
                    name = DeviceKitUtilities.stripPackage(className);
                }
                ++j;
            }
        }
        this.codeDeviceServiceKeyField(service, "Status", String.valueOf(name) + "/Status", 2, new StringBuffer(1024), false, false, true);
        this.codeDeviceServiceKeyField(service, "Configuration", String.valueOf(name) + "/Configuration", 2, new StringBuffer(1024), false, false, true);
        this.codeDeviceServiceKeyField(service, "Capabilities", String.valueOf(name) + "/Capabilities", 2, new StringBuffer(1024), false, false, true);
        this.codeDeviceServiceKeyField(service, "Metrics", String.valueOf(name) + "/Metrics", 2, new StringBuffer(1024), false, false, true);
        if (this.getMainElement().isMultiplex()) {
            this.codeDeviceServiceKeyField(service, "Channels", String.valueOf(name) + "/Channels", 2, new StringBuffer(1024), false, false, true);
            this.codeDeviceServiceKeyField(service, "ChannelChanged", String.valueOf(name) + "/ChannelChanged", 2, new StringBuffer(1024), false, false, true);
            this.codeDeviceServiceKeyField(service, "OpenChannel", String.valueOf(name) + "/OpenChannel", 2, new StringBuffer(1024), false, false, true);
            this.codeDeviceServiceKeyField(service, "CloseChannel", String.valueOf(name) + "/CloseChannel", 2, new StringBuffer(1024), false, false, true);
        }
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_PROFILE_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_PROFILE_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_PROFILE_BUNDLE_ACTIVATOR;
    }

    protected List getParentElements() {
        return this.getMainElement().getAllChildrenWithTagCode(83);
    }

    public String getServiceClassParent() {
        return DeviceKitGenerationConstants.CLASS_PROFILE_SERVICE;
    }

    protected String[] getServiceInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getServiceClassParent());
        this.fServiceModel.addImport(this.getServiceClassParent());
        List exportedService = this.getDevice().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < exportedService.size()) {
            if (((TagElement)exportedService.get(i)).getTextData() != null) {
                result.add(((TagElement)exportedService.get(i)).getTextData());
            }
            ++i;
        }
        List parents = this.getDevice().getAllChildrenWithTagCode(83);
        int i2 = 0;
        while (i2 < parents.size()) {
            TagElement parent = (TagElement)parents.get(i2);
            List profileRefs = parent.getAllChildrenWithTagCode(86);
            int j = 0;
            while (j < profileRefs.size()) {
                TagElement profileRef = (TagElement)profileRefs.get(j);
                if (profileRef.getIdRaw() != null) {
                    String serviceName = profileRef.getServiceNameFull();
                    this.fServiceModel.addImport(serviceName);
                    result.add(DeviceKitUtilities.stripPackage(serviceName));
                }
                ++j;
            }
            ++i2;
        }
        String[] serviceInterfaces = new String[result.size()];
        int i3 = 0;
        while (i3 < result.size()) {
            serviceInterfaces[i3] = (String)result.get(i3);
            ++i3;
        }
        return serviceInterfaces;
    }

    public AdapterElement getTargetAdapter() {
        return this.targetAdapter;
    }

    protected void initialize() {
        List services = this.getRootElement().getAllChildrenWithTagCode(74);
        ProfileElement profile = (ProfileElement)services.get(0);
        this.setDevice(profile);
        List devices = profile.getAllChildrenWithTagCode(8);
        if (devices.size() > 0) {
            TagElement device = (TagElement)devices.get(0);
            this.setTargetDevice(device);
        }
        this.setMainTagElement(profile);
        String className = DeviceKitUtilities.getClassNameFromTagElement(profile);
        this.setMainClassName(className);
        List adapters = this.getMainElement().getAllChildrenWithTagCode(72);
        if (adapters.size() > 0) {
            AdapterElement adapaterService = (AdapterElement)adapters.get(0);
            this.setTargetAdapter(adapaterService);
        }
        this.setPackageBase(profile.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        if (profile.getAttribute("lazy") == null || "false".equals(profile.getAttribute("lazy"))) {
            this.setLazy(false);
        } else {
            this.setLazy(true);
        }
        if (profile.hasChildWithTagCode(45)) {
            this.setInitializeMeasurements(true);
        } else {
            this.setInitializeMeasurements(false);
        }
        String initWithMethod = profile.getAttribute("createmethod");
        if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
            this.setInitializeWithMethod(true);
        } else {
            this.setInitializeWithMethod(false);
        }
        this.setupExportedPackages();
        this.initializeGet();
        this.getBuildModel().addAdditionalBundles(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE));
        this.getBuildModel().addAdditionalBundles(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_PROFILE));
    }

    public void setTargetAdapter(AdapterElement targetAdapater) {
        this.targetAdapter = targetAdapater;
    }

    protected List getManifestImportPackages() {
        String devicePackage;
        List importPackages = super.getManifestImportPackages();
        if (!importPackages.contains(devicePackage = DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE))) {
            importPackages.add(devicePackage);
        }
        List parents = this.getDevice().getAllChildrenWithTagCode(83);
        int i = 0;
        while (i < parents.size()) {
            TagElement parent = (TagElement)parents.get(i);
            List profileRefs = parent.getAllChildrenWithTagCode(86);
            int j = 0;
            while (j < profileRefs.size()) {
                String className;
                String packageName;
                TagElement profileRef = (TagElement)profileRefs.get(j);
                if (profileRef.getIdRaw() != null && !importPackages.contains(packageName = DeviceKitUtilities.extractPackage(className = profileRef.getClassNameFull()))) {
                    importPackages.add(packageName);
                }
                ++j;
            }
            ++i;
        }
        return importPackages;
    }
}

