/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml.parse;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.editor.dkml.parse.AttributeHolder;
import org.eclipse.soda.devicekit.editor.dkml.parse.CommentHolder;
import org.eclipse.soda.devicekit.editor.dkml.parse.TagHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DkmlTagManager {
    private Document document;
    private List top = new ArrayList();
    private StringBuffer buff = new StringBuffer();

    public DkmlTagManager(Document document) {
        this.document = document;
        NodeList children = document.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            TagHolder holder = this.parse(children.item(i));
            if (holder != null) {
                this.top.add(holder);
            }
            ++i;
        }
        this.parse(document);
    }

    public void addChild(TagHolder parent, TagHolder newTag) {
        this.addChild(parent, newTag, -1);
    }

    public void addChild(TagHolder parent, TagHolder newTag, int index) {
        int i = 0;
        while (i < this.top.size()) {
            TagHolder curr = (TagHolder)this.top.get(i);
            if (curr.equals(parent)) {
                curr.addChild(newTag);
                return;
            }
            List children = curr.getChildren();
            int j = 0;
            while (j < children.size()) {
                if (this.addChild((TagHolder)children.get(j), parent, newTag, index)) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean addChild(TagHolder current, TagHolder parent, TagHolder newTag, int index) {
        if (current.equals(parent)) {
            current.addChild(newTag, index);
            return true;
        }
        List children = current.getChildren();
        int j = 0;
        while (j < children.size()) {
            if (this.addChild((TagHolder)children.get(j), parent, newTag, index)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public TagHolder findFileHolder(String name, TagHolder holder) {
        List children = holder.getChildren();
        int i = 0;
        while (i < children.size()) {
            TagHolder child = (TagHolder)children.get(i);
            TagHolder cholder = this.findFileHolder(name, child);
            if (cholder != null) {
                return cholder;
            }
            ++i;
        }
        return null;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getFileContents(String name) {
        TagHolder holder = this.getFileHolder(name);
        if (holder == null) {
            return null;
        }
        return holder.toString();
    }

    protected TagHolder getFileHolder(String name) {
        int i = 0;
        while (i < this.top.size()) {
            TagHolder holder = this.findFileHolder(name, (TagHolder)this.top.get(i));
            if (holder != null) {
                return holder;
            }
            ++i;
        }
        return null;
    }

    public List getTop() {
        return this.top;
    }

    private TagHolder parse(Node node) {
        if (node.getNodeType() == 8) {
            CommentHolder holder = new CommentHolder(node.getNodeValue());
            return holder;
        }
        String data = node.getNodeValue();
        String name = node.getNodeName();
        ArrayList<TagHolder> tagChildren = new ArrayList<TagHolder>();
        ArrayList<AttributeHolder> attributes = new ArrayList<AttributeHolder>();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            if (cNode.getNodeType() != 3) {
                TagHolder cHolder = this.parse(cNode);
                if (cHolder != null) {
                    tagChildren.add(cHolder);
                }
            } else if (data == null) {
                data = cNode.getNodeValue();
            }
            ++i;
        }
        NamedNodeMap attributeNodes = node.getAttributes();
        if (attributeNodes != null) {
            int i2 = 0;
            while (i2 < attributeNodes.getLength()) {
                Node aNode = attributeNodes.item(i2);
                String aName = aNode.getNodeName();
                String aValue = aNode.getNodeValue();
                AttributeHolder aHolder = new AttributeHolder(aName, aValue, aNode);
                attributes.add(aHolder);
                ++i2;
            }
        }
        TagHolder holder = new TagHolder(name, attributes, tagChildren, node, data);
        int i3 = 0;
        while (i3 < tagChildren.size()) {
            ((TagHolder)tagChildren.get(i3)).setParent(holder);
            ++i3;
        }
        return holder;
    }

    public void print() {
        int i = 0;
        while (i < this.top.size()) {
            TagHolder holder = (TagHolder)this.top.get(i);
            this.print(holder, 0);
            ++i;
        }
        System.out.println(this.buff.toString());
    }

    private void print(String s) {
        this.buff.append(s);
    }

    private void print(TagHolder holder, int level) {
        int i = 0;
        while (i < level) {
            this.print("\t");
            ++i;
        }
        if (holder.isComment()) {
            this.print("Comment: " + holder.getComment());
        } else {
            this.print("Tag: " + holder.getName() + ' ');
            List atttributes = holder.getAttributes();
            if (atttributes.size() > 0) {
                this.print("  Atts: ");
                int i2 = 0;
                while (i2 < atttributes.size()) {
                    AttributeHolder aHolder = (AttributeHolder)atttributes.get(i2);
                    this.print("(name=" + aHolder.getName() + " value=" + aHolder.getValue() + ") ");
                    ++i2;
                }
            }
            this.print("Data=" + holder.getData());
            this.print("\n");
            List children = holder.getChildren();
            int i3 = 0;
            while (i3 < children.size()) {
                TagHolder child = (TagHolder)children.get(i3);
                this.print(child, level + 1);
                ++i3;
            }
        }
    }

    public void replaceTopHolder(TagHolder holder) {
        int i = 0;
        while (i < this.top.size()) {
            TagHolder current = (TagHolder)this.top.get(i);
            if (!(current instanceof CommentHolder)) {
                this.top.set(i, holder);
                return;
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        List v = this.getTop();
        int i = 0;
        while (i < v.size()) {
            TagHolder h = (TagHolder)v.get(i);
            buffer.append(h.toString());
            ++i;
        }
        return buffer.toString();
    }
}

