/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.util.List;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormPage;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;

public class OverviewPage
extends DeviceKitFormPage {
    public OverviewPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite parent = this.setup(managedForm, 1);
        DeviceKitTagModel dkFileModel = this.getTagModel();
        if (dkFileModel != null) {
            try {
                MainTagElement element = dkFileModel.getMainElement();
                if (element != null) {
                    String name = element.getAnyId();
                    String version = element.getVersion();
                    String provider = element.getProvider();
                    String id = element.getProjectId();
                    String description = element.getDescription();
                    String vendor = element.getVendor();
                    Section generalSection = this.createSection(this.getToolkit(), parent, "general", 3, true);
                    Composite container = (Composite)generalSection.getClient();
                    this.createText(this.getToolkit(), container, "name", name, false);
                    this.createText(this.getToolkit(), container, "version", version, false);
                    this.createText(this.getToolkit(), container, "provider", provider, true);
                    this.createText(this.getToolkit(), container, "vendor", vendor, true);
                    this.createText(this.getToolkit(), container, "description", description, true);
                    managedForm.addPart((IFormPart)new SectionPart(generalSection));
                    Section projectSection = this.createSection(this.getToolkit(), parent, "project", 3, true);
                    projectSection.setExpanded(false);
                    Composite projectContainer = (Composite)projectSection.getClient();
                    this.createText(this.getToolkit(), projectContainer, "id", id, false);
                    boolean bundle = element.isBundle();
                    String bundleString = String.valueOf(id) + ".bundle";
                    this.createCheckboxAndText(this.getToolkit(), projectContainer, "bundle", bundle, bundleString, false);
                    boolean dsBundle = element.isDsBundle();
                    String dsString = String.valueOf(id) + ".dsbundle";
                    this.createCheckboxAndText(this.getToolkit(), projectContainer, "ds", dsBundle, dsString, false);
                    boolean managedBundle = element.isManagedBundle();
                    String managedString = String.valueOf(id) + ".managed";
                    this.createCheckboxAndText(this.getToolkit(), projectContainer, "managed", managedBundle, managedString, false);
                    boolean factoryBundle = element.isManagedFactoryBundle();
                    String factoryString = String.valueOf(id) + ".factory";
                    this.createCheckboxAndText(this.getToolkit(), projectContainer, "factory", factoryBundle, factoryString, false);
                    managedForm.addPart((IFormPart)new SectionPart(projectSection));
                    List specs = element.getAllChildrenWithTagCode(64);
                    int i = 0;
                    while (i < specs.size()) {
                        Section specSection = this.createSection(this.getToolkit(), parent, "spec", 3, true);
                        Composite specContainer = (Composite)specSection.getClient();
                        SpecElement specElement = (SpecElement)specs.get(i);
                        String specTitle = specElement.getSpecTitle();
                        this.createText(this.getToolkit(), specContainer, "specification.title", specTitle, true);
                        String specDate = specElement.getSpecDate();
                        this.createText(this.getToolkit(), specContainer, "specification.date", specDate, true);
                        String specUrl = specElement.getSpecUrl();
                        this.createText(this.getToolkit(), specContainer, "specification.url", specUrl, true);
                        String specVendor = specElement.getSpecVendor();
                        this.createText(this.getToolkit(), specContainer, "specification.vendor", specVendor, true);
                        String specVersion = specElement.getSpecVersion();
                        this.createText(this.getToolkit(), specContainer, "specification.version", specVersion, true);
                        String specComment = specElement.getSpecComment();
                        this.createText(this.getToolkit(), specContainer, "specification.comment", specComment, true);
                        specSection.setExpanded(false);
                        managedForm.addPart((IFormPart)new SectionPart(specSection));
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

