/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.util.List;
import org.eclipse.soda.devicekit.editor.dkml.parse.AttributeHolder;
import org.eclipse.soda.devicekit.editor.dkml.parse.TagHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DkmlTagUtil {
    private static String findElement(NodeList level, String element) {
        int i = 0;
        while (i < level.getLength()) {
            Node node = level.item(i);
            if (node.getNodeName().equals(element)) {
                return node.getNodeValue();
            }
            String val = DkmlTagUtil.findElement(node.getChildNodes(), element);
            if (val != null && val.length() > 0) {
                return val;
            }
            ++i;
        }
        return null;
    }

    public static String getAttribute(Node node, String key) {
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node att = attributes.item(i);
            if (att.getNodeName().equals(key)) {
                return att.getNodeValue();
            }
            ++i;
        }
        return "";
    }

    public static String getAttribute(TagHolder holder, String key) {
        List attributes = holder.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            AttributeHolder att = (AttributeHolder)attributes.get(i);
            if (att.getName().equals(key)) {
                return att.getValue();
            }
            ++i;
        }
        return "";
    }

    public static String getElement(Document document, String element) {
        NodeList level = document.getChildNodes();
        String val = DkmlTagUtil.findElement(level, element);
        return val;
    }

    public static boolean isValidText(String text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c < ' ') {
                return false;
            }
            if (c > '~' && c < '\u00a0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void print(Document document) {
        System.out.println(document.toString());
        int i = 0;
        while (i < document.getChildNodes().getLength()) {
            Node node = document.getChildNodes().item(i);
            System.out.println(node.toString());
            DkmlTagUtil.print(node.getChildNodes());
            ++i;
        }
    }

    private static void print(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            System.out.println(node.toString());
            DkmlTagUtil.print(node.getChildNodes());
            ++i;
        }
    }

    public static void sort(String[] names) {
        int length = names.length;
        int i = 0;
        while (i < length - 1) {
            int j = 0;
            while (j < length - i - 1) {
                if (names[j + 1].compareTo(names[j]) < 0) {
                    String tmp = names[j];
                    names[j] = names[j + 1];
                    names[j + 1] = tmp;
                }
                ++j;
            }
            ++i;
        }
    }
}

