/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml.schema;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.editor.dkml.DkmlTagUtil;
import org.eclipse.soda.devicekit.editor.dkml.messages.Messages;
import org.eclipse.soda.devicekit.editor.dkml.parse.AttributeHolder;
import org.eclipse.soda.devicekit.editor.dkml.parse.TagHolder;
import org.eclipse.soda.devicekit.editor.dkml.schema.Choice;
import org.eclipse.soda.devicekit.editor.dkml.schema.ChoiceElement;
import org.eclipse.soda.devicekit.editor.dkml.schema.ComplexTypeHolder;
import org.eclipse.soda.devicekit.editor.dkml.schema.DkmlSchema;
import org.eclipse.soda.devicekit.editor.dkml.schema.IComplexTypeElement;
import org.eclipse.soda.devicekit.editor.dkml.schema.Restriction;
import org.eclipse.soda.devicekit.editor.dkml.schema.SchemaAttributeHolder;
import org.eclipse.soda.devicekit.editor.dkml.schema.SchemaElement;
import org.eclipse.soda.devicekit.editor.dkml.schema.SchemaTypeHolder;
import org.eclipse.soda.devicekit.editor.dkml.schema.Sequence;
import org.eclipse.soda.devicekit.editor.dkml.schema.SequenceElement;
import org.eclipse.soda.devicekit.editor.dkml.schema.SimpleContent;
import org.eclipse.soda.devicekit.editor.dkml.schema.SimpleTypeHolder;

public class DkmlSchemaUtil {
    private DkmlSchema schema;

    public DkmlSchemaUtil(DkmlSchema schema) {
        this.schema = schema;
    }

    private int calculateIndex(String name, String[] schemaChildren, List currentChildren, int index) {
        int i;
        String sib;
        int currSiblingIndex;
        for (currSiblingIndex = index + 1; currSiblingIndex <= schemaChildren.length - 1; ++currSiblingIndex) {
            sib = schemaChildren[currSiblingIndex];
            i = 0;
            while (i < currentChildren.size()) {
                if (((TagHolder)currentChildren.get(i)).getName().equals(sib)) {
                    return i;
                }
                ++i;
            }
        }
        for (currSiblingIndex = index - 1; currSiblingIndex >= 0; --currSiblingIndex) {
            sib = schemaChildren[currSiblingIndex];
            i = 0;
            while (i < currentChildren.size()) {
                if (((TagHolder)currentChildren.get(i)).getName().equals(sib)) {
                    return i + 1;
                }
                ++i;
            }
        }
        return 0;
    }

    protected TagHolder createHolder(ChoiceElement element) {
        String type = element.getType();
        SchemaTypeHolder typeObj = (SchemaTypeHolder)this.schema.getCmlType(type);
        String name = element.getName();
        if (typeObj == null) {
            return new TagHolder(name);
        }
        List sattributes = typeObj.getAttributes();
        ArrayList<AttributeHolder> attributes = new ArrayList<AttributeHolder>();
        int i = 0;
        while (i < sattributes.size()) {
            SchemaAttributeHolder saholder = (SchemaAttributeHolder)sattributes.get(i);
            if (!saholder.getName().equals(Messages.getString("IDREF"))) {
                attributes.add(new AttributeHolder(saholder.getName(), ""));
            }
            ++i;
        }
        TagHolder holder = new TagHolder(name, attributes);
        return holder;
    }

    protected TagHolder createHolder(SequenceElement element) {
        String type = element.getType();
        String name = element.getName();
        SchemaTypeHolder typeObj = (SchemaTypeHolder)this.schema.getCmlType(type);
        if (typeObj == null) {
            return new TagHolder(name);
        }
        List sattributes = typeObj.getAttributes();
        ArrayList<AttributeHolder> attributes = new ArrayList<AttributeHolder>();
        int i = 0;
        while (i < sattributes.size()) {
            SchemaAttributeHolder saholder = (SchemaAttributeHolder)sattributes.get(i);
            if (!saholder.getName().equals(Messages.getString("IDREF"))) {
                attributes.add(new AttributeHolder(saholder.getName(), ""));
            }
            ++i;
        }
        TagHolder holder = new TagHolder(name, attributes);
        return holder;
    }

    public TagHolder createNewTagHolder(String parentName, String tag) {
        SchemaTypeHolder sType = (SchemaTypeHolder)this.schema.getCmlType(String.valueOf(parentName) + Messages.getString("TYPE_STRING"));
        List children = sType.getChildren();
        int i = 0;
        while (i < children.size()) {
            SimpleContent sc;
            IComplexTypeElement element = (IComplexTypeElement)children.get(i);
            int type = element.getElementType();
            if (type == 2) {
                Sequence sequence = (Sequence)element;
                if (sequence.containsElement(tag)) {
                    SchemaElement se = sequence.getElement(tag);
                    String tagType = se.getType();
                    return this.determineType(tag, tagType);
                }
            } else if (type == 1) {
                Choice choice = (Choice)element;
                if (choice.containsElement(tag)) {
                    SchemaElement ce = choice.getElement(tag);
                    String tagType = ce.getType();
                    return this.determineType(tag, tagType);
                }
            } else if (type == 3 && (sc = (SimpleContent)element).containsElement(tag)) {
                String tagType = sc.getType();
                return this.determineType(tag, tagType);
            }
            ++i;
        }
        return new TagHolder(tag);
    }

    private TagHolder determineType(String tag, String tagType) {
        if (tagType.equals(Messages.getString("INTEGER"))) {
            return new TagHolder(tag, new ArrayList(), new ArrayList(), null, "0");
        }
        if (tagType.equals(Messages.getString("STRING"))) {
            return new TagHolder(tag, new ArrayList(), new ArrayList(), null, "");
        }
        if (tagType.equals(Messages.getString("UNSIGNEDINT"))) {
            return new TagHolder(tag, new ArrayList(), new ArrayList(), null, "0");
        }
        SchemaTypeHolder dkmlType = (SchemaTypeHolder)this.schema.getCmlType(tagType);
        if (dkmlType != null) {
            if (dkmlType.getType() == 0) {
                Restriction res = ((SimpleTypeHolder)dkmlType).getRestriction();
                if (res != null && res.getBase() != null) {
                    return this.determineType(tag, res.getBase());
                }
                return new TagHolder(tag);
            }
            ComplexTypeHolder cth = (ComplexTypeHolder)dkmlType;
            List children = cth.getChildren();
            int i = 0;
            while (i < children.size()) {
                if (children.get(i) instanceof SimpleContent) {
                    return this.determineType(tag, ((SimpleContent)children.get(i)).getType());
                }
                ++i;
            }
        }
        return new TagHolder(tag);
    }

    public int getChildInsertIndex(String name, TagHolder parent) {
        String[] vChildren = this.getValidChildrenNames(parent, false, false);
        List currentChildren = parent.getChildren();
        int index = -1;
        int i = 0;
        while (i < vChildren.length) {
            if (vChildren[i].equals(name)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == vChildren.length) {
            index = -1;
        }
        switch (index) {
            case -1: 
            case 0: {
                return index;
            }
        }
        return this.calculateIndex(name, vChildren, currentChildren, index);
    }

    private int getChoiceNumber(TagHolder holder, List possibleChildren) {
        int count = 0;
        List currChildren = holder.getChildren();
        int i = 0;
        while (i < possibleChildren.size()) {
            ChoiceElement ce = (ChoiceElement)possibleChildren.get(i);
            String name = ce.getName();
            int j = 0;
            while (j < currChildren.size()) {
                TagHolder cth = (TagHolder)currChildren.get(j);
                if (name.equals(cth.getName())) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    private int getCount(String name, TagHolder holder) {
        if (holder.isComment()) {
            return 0;
        }
        List children = holder.getChildren();
        int count = 0;
        int i = 0;
        while (i < children.size()) {
            TagHolder child = (TagHolder)children.get(i);
            if (child.getName().equals(name)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String[] getValidAttributeNames(TagHolder holder) {
        SchemaTypeHolder schemaType = (SchemaTypeHolder)this.schema.getCmlType(String.valueOf(holder.getName()) + Messages.getString("TYPE_STRING"));
        if (schemaType == null) {
            return new String[0];
        }
        List attributes = schemaType.getAttributes();
        List currAtts = holder.getAttributes();
        int size = 0;
        if (currAtts.size() < attributes.size()) {
            size = attributes.size() - currAtts.size();
        }
        String[] vAttributes = new String[size];
        int currIndex = 0;
        int i = 0;
        while (i < attributes.size()) {
            String att = ((SchemaAttributeHolder)attributes.get(i)).getName();
            boolean exists = false;
            int j = 0;
            while (j < currAtts.size()) {
                AttributeHolder ah = (AttributeHolder)currAtts.get(j);
                if (att.equals(ah.getName())) {
                    exists = true;
                    break;
                }
                ++j;
            }
            if (!exists) {
                vAttributes[currIndex] = att;
                ++currIndex;
            }
            ++i;
        }
        return vAttributes;
    }

    public List getValidChildren(TagHolder holder, boolean trim) {
        ArrayList validChildren = new ArrayList();
        String cName = String.valueOf(holder.getName()) + Messages.getString("TYPE_STRING");
        SchemaTypeHolder sHolder = (SchemaTypeHolder)this.schema.getCmlType(cName);
        if (sHolder == null) {
            return validChildren;
        }
        List sChildren = sHolder.getChildren();
        int i = 0;
        while (i < sChildren.size()) {
            IComplexTypeElement element = (IComplexTypeElement)sChildren.get(i);
            int type = element.getElementType();
            if (type == 2) {
                Sequence sequence = (Sequence)element;
                this.handleSequence(sequence, validChildren, holder, trim);
            } else if (type == 1) {
                Choice choice = (Choice)element;
                this.handleChoice(choice, validChildren, holder, trim);
            } else if (type == 3) {
                SimpleContent sc = (SimpleContent)element;
                this.handleSimpleContent(sc, validChildren, holder);
            }
            ++i;
        }
        return validChildren;
    }

    public String[] getValidChildrenNames(TagHolder selectedItem) {
        return this.getValidChildrenNames(selectedItem, false);
    }

    public String[] getValidChildrenNames(TagHolder selectedItem, boolean sort) {
        return this.getValidChildrenNames(selectedItem, sort, true);
    }

    public String[] getValidChildrenNames(TagHolder selectedItem, boolean sort, boolean trim) {
        List validChildren = this.getValidChildren(selectedItem, trim);
        String[] ch = new String[validChildren.size()];
        int i = 0;
        while (i < ch.length) {
            TagHolder h = (TagHolder)validChildren.get(i);
            ch[i] = h.getName();
            ++i;
        }
        if (sort) {
            DkmlTagUtil.sort(ch);
        }
        return ch;
    }

    private void handleChoice(Choice choice, List validChildren, TagHolder holder, boolean trim) {
        List possibleChildren = choice.getElements();
        int currentNumber = 0;
        if (choice.getMaxOccurs() != -2) {
            currentNumber = this.getChoiceNumber(holder, possibleChildren);
        }
        int i = 0;
        while (i < possibleChildren.size()) {
            TagHolder h;
            ChoiceElement ce = (ChoiceElement)possibleChildren.get(i);
            if (trim) {
                if ((choice.getMaxOccurs() == -2 || currentNumber < choice.getMaxOccurs()) && this.includeElement(ce, holder) && (h = this.createHolder(ce)) != null) {
                    validChildren.add(h);
                }
            } else {
                h = this.createHolder(ce);
                if (h != null) {
                    validChildren.add(h);
                }
            }
            ++i;
        }
    }

    private void handleSequence(Sequence sequence, List validChildren, TagHolder holder, boolean trim) {
        List possibleChildren = sequence.getElements();
        int i = 0;
        while (i < possibleChildren.size()) {
            Object seobj = possibleChildren.get(i);
            if (seobj instanceof SequenceElement) {
                TagHolder h;
                SequenceElement se = (SequenceElement)seobj;
                if (trim) {
                    if (this.includeElement(se, holder) && (h = this.createHolder(se)) != null) {
                        validChildren.add(h);
                    }
                } else {
                    h = this.createHolder(se);
                    if (h != null) {
                        validChildren.add(h);
                    }
                }
            } else if (seobj instanceof Choice) {
                Choice ch = (Choice)seobj;
                this.handleChoice(ch, validChildren, holder, trim);
            }
            ++i;
        }
    }

    private void handleSimpleContent(SimpleContent sc, List validChildren, TagHolder holder) {
    }

    public boolean includeElement(SchemaElement element, TagHolder holder) {
        int currCount;
        String name = element.getName();
        int max = element.getMaxOccurs();
        if (max == -2) {
            return true;
        }
        if (max == -1) {
            max = 1;
        }
        return (currCount = this.getCount(name, holder)) < max;
    }

    public boolean validate(DkmlSchema schema, TagHolder holder) {
        return true;
    }
}

