/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitSourcePage;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitTemplateProposal;
import org.eclipse.soda.devicekit.generator.feature.DeviceKitTemplateContent;
import org.eclipse.soda.devicekit.generator.templates.GeneratorContextType;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.swt.graphics.Image;

public class DeviceKitCompletionProcessor
extends TemplateCompletionProcessor
implements ICompletionListener {
    private char[] completionProposalAutoActivationCharacters = new char[]{'<', '=', '!', '\"'};
    private IContentAssistant assistant;
    private DeviceKitSourcePage deviceKitSourcePage;

    public DeviceKitCompletionProcessor(DeviceKitSourcePage deviceKitSourcePage) {
        this.setDeviceKitSourcePage(deviceKitSourcePage);
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.assistant = null;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.assistant = event.assistant;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IFile file;
        String filename = "dkml";
        if (this.getDeviceKitSourcePage() != null && (file = this.getDeviceKitSourcePage().getFile()) != null && (filename = file.getName()).endsWith(".xml")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        DeviceKitTemplateContent context = new DeviceKitTemplateContent((TemplateContextType)new GeneratorContextType());
        Template[] templates = GeneratorTemplates.templateStore.getTemplates("org.eclipse.soda.devicekit.generator.templates." + filename);
        try {
            int startOffset = offset - 1;
            int count = 1;
            boolean ok = true;
            while (ok) {
                char character = viewer.getDocument().getChar(startOffset);
                if (character == '<') {
                    ok = false;
                    break;
                }
                ++count;
                if (--startOffset == 0) {
                    ok = false;
                    break;
                }
                if (count <= 40) continue;
                count = 1;
                ok = false;
                break;
            }
            Region region = new Region(startOffset, count);
            String currentContent = viewer.getDocument().get(startOffset, count);
            Image image = null;
            if (currentContent.length() > 1) {
                String match = currentContent.substring(1);
                ArrayList<DeviceKitTemplateProposal> list = new ArrayList<DeviceKitTemplateProposal>();
                int i = 0;
                while (i < templates.length) {
                    Template template = templates[i];
                    String name = template.getName();
                    if (name.startsWith(match)) {
                        DeviceKitTemplateProposal deviceKitTemplateProposal = new DeviceKitTemplateProposal(template, (TemplateContext)context, (IRegion)region, image);
                        list.add(deviceKitTemplateProposal);
                    }
                    ++i;
                }
                int size = list.size();
                if (size > 0) {
                    ICompletionProposal[] completionProposals = new ICompletionProposal[size];
                    completionProposals = list.toArray(completionProposals);
                    return completionProposals;
                }
            }
            ICompletionProposal[] completionProposals = new ICompletionProposal[templates.length];
            int i = 0;
            while (i < templates.length) {
                Template template = templates[i];
                DeviceKitTemplateProposal deviceKitTemplateProposal = new DeviceKitTemplateProposal(template, (TemplateContext)context, (IRegion)region, image);
                completionProposals[i] = deviceKitTemplateProposal;
                ++i;
            }
            return completionProposals;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        ContextInformation contextInformation = new ContextInformation("Context Display String", "Information Display String");
        IContextInformation[] contextInformations = new IContextInformation[]{contextInformation};
        return contextInformations;
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        DeviceKitTemplateContent context = new DeviceKitTemplateContent((TemplateContextType)new GeneratorContextType());
        return context;
    }

    public IContentAssistant getAssistant() {
        return this.assistant;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.completionProposalAutoActivationCharacters;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return new GeneratorContextType();
    }

    public DeviceKitSourcePage getDeviceKitSourcePage() {
        return this.deviceKitSourcePage;
    }

    protected Image getImage(Template template) {
        return null;
    }

    protected Template[] getTemplates(String contextTypeId) {
        System.out.println("contextTypeId " + contextTypeId);
        return null;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public void setAssistant(IContentAssistant assistant) {
        this.assistant = assistant;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] completionProposalAutoActivationCharacters) {
        this.completionProposalAutoActivationCharacters = completionProposalAutoActivationCharacters;
    }

    public void setDeviceKitSourcePage(DeviceKitSourcePage deviceKitSourcePage) {
        this.deviceKitSourcePage = deviceKitSourcePage;
    }
}

