/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util.test;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.service.log.LogService;

public class LogUtilityTestCase
extends AbstractSatTestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.test.LogUtilityTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public LogUtilityTestCase(String name) {
        super(name);
    }

    public void test_getLog() {
        LogUtility utility = LogUtility.getInstance();
        LogService logService = utility.getLog();
        Assert.assertNotNull((Object)logService);
    }

    public void test_setLog() {
        LogUtility utility = LogUtility.getInstance();
        LogService currentLogService = utility.getLog();
        utility.setLog(null);
        LogService log = utility.getLog();
        Assert.assertNotNull((Object)log);
        utility.setLog(currentLogService);
        LogService expected = currentLogService;
        LogService actual = utility.getLog();
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public void test_setLoggingLevel() {
        int currentLoggingLevel = LogUtility.getLoggingLevel();
        LogUtility.setLoggingLevel((int)1);
        int expectedLevel = 1;
        int actualLevel = LogUtility.getLoggingLevel();
        Assert.assertEquals((int)expectedLevel, (int)actualLevel);
        boolean isLogging = LogUtility.isLoggingError();
        Assert.assertTrue((boolean)isLogging);
        LogUtility.setLoggingLevel((int)2);
        expectedLevel = 2;
        actualLevel = LogUtility.getLoggingLevel();
        Assert.assertEquals((int)expectedLevel, (int)actualLevel);
        isLogging = LogUtility.isLoggingWarning();
        Assert.assertTrue((boolean)isLogging);
        LogUtility.setLoggingLevel((int)3);
        expectedLevel = 3;
        actualLevel = LogUtility.getLoggingLevel();
        Assert.assertEquals((int)expectedLevel, (int)actualLevel);
        isLogging = LogUtility.isLoggingInfo();
        Assert.assertTrue((boolean)isLogging);
        LogUtility.setLoggingLevel((int)4);
        expectedLevel = 4;
        actualLevel = LogUtility.getLoggingLevel();
        Assert.assertEquals((int)expectedLevel, (int)actualLevel);
        isLogging = LogUtility.isLoggingDebug();
        Assert.assertTrue((boolean)isLogging);
        LogUtility.setLoggingLevel((int)currentLoggingLevel);
    }
}

