/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleManifestUtilityTestCase
extends AbstractServiceTestCase {
    private static final BundleManifestUtility UTILITY = BundleManifestUtility.getInstance();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.util.test.BundleManifestUtilityTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BundleManifestUtilityTestCase(String name) {
        super(name);
    }

    private String createPackageList() {
        char semicolon = ';';
        char comma = ',';
        char quote = '\"';
        char equals = '=';
        String version = "version" + equals + quote + "1.0.0" + quote;
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("org.dummy.foo.one").append(comma);
        buffer.append("org.dummy.foo.two").append(comma);
        buffer.append("org.dummy.foo.three").append(semicolon);
        buffer.append(version).append(comma);
        buffer.append("org.dummy.foo.four").append(semicolon);
        buffer.append(version).append(comma);
        buffer.append("org.dummy.foo.five").append(comma);
        buffer.append("org.dummy.foo.six");
        String value = buffer.toString();
        return value;
    }

    public void test_getBundleActivator() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.junit.internal.bundle.Activator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String expected = clazz.getName();
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleActivator(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleCategory() {
        String expected = "Unit Test";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleCategory(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleClasspath() {
        String expected = ".";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleClasspath(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleContactAddress() {
        String expected = "license@eclipse.org";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleContactAddress(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleCopyright() {
        String expected = "Copyright (c) 2001, 2007 IBM Corporation and others.";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleCopyright(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleDescription() {
        String expected = "Unit tests for org.eclipse.soda.sat.core";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleDescription(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleDocUrl() {
        String expected = "www.eclipse.org";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleDocUrl(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleLocalization() {
        String expected = "bundle";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleLocalization(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleManifestVersion() {
        String expected = "2";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleManifestVersion(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleName() {
        String expected = "SAT Core JUnit Tests (Incubation)";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleName(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleNativeCode() {
        Object expected = null;
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleNativeCode(bundle);
        Assert.assertEquals(expected, (Object)actual);
    }

    public void test_getBundleRequiredExecutionEnvironments() {
        String[] expected = new String[]{"OSGi/Minimum-1.1"};
        Bundle bundle = this.getBundle();
        String[] actual = UTILITY.getBundleRequiredExecutionEnvironments(bundle);
        Assert.assertEquals((int)expected.length, (int)actual.length);
    }

    public void test_getBundleSymbolicName() {
        String expected = "org.eclipse.soda.sat.core.junit";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleSymbolicName(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleUpdateLocation() {
        String expected = ".";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleUpdateLocation(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleVendor() {
        String expected = "Eclipse.org";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleVendor(bundle);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void test_getBundleVersion() {
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getBundleVersion(bundle);
        Assert.assertNotNull((Object)actual);
    }

    public void test_getDynamicImportPackage() {
        Object[] expectedPackages = EMPTY_OBJECT_ARRAY;
        Bundle bundle = this.getBundle();
        String[] actualPackages = UTILITY.getDynamicImportPackages(bundle);
        int expected = expectedPackages.length;
        int actual = actualPackages.length;
        Assert.assertEquals((int)expected, (int)actual);
    }

    public void test_getExportPackage() {
        AbstractBundle bundle = new AbstractBundle(){

            public Dictionary getHeaders() {
                Dictionary headers = super.getHeaders();
                String value = BundleManifestUtilityTestCase.this.createPackageList();
                headers.put("Export-Package", value);
                return headers;
            }
        };
        String[] actual = UTILITY.getExportPackages((Bundle)bundle);
        Assert.assertTrue((actual.length == 6 ? 1 : 0) != 0);
    }

    public void test_getFragmentHost() {
        Bundle bundle = this.getBundle();
        Object expected = null;
        String actual = UTILITY.getFragmentHost(bundle);
        Assert.assertSame(expected, (Object)actual);
    }

    public void test_getImportPackage() {
        AbstractBundle bundle = new AbstractBundle(){

            public Dictionary getHeaders() {
                Dictionary headers = super.getHeaders();
                String value = BundleManifestUtilityTestCase.this.createPackageList();
                headers.put("Import-Package", value);
                return headers;
            }
        };
        String[] actual = UTILITY.getImportPackages((Bundle)bundle);
        Assert.assertTrue((actual.length == 6 ? 1 : 0) != 0);
    }

    public void test_getInstance() {
        Assert.assertNotNull((Object)UTILITY);
        BundleManifestUtility instance = BundleManifestUtility.getInstance();
        BundleManifestUtility expected = UTILITY;
        BundleManifestUtility actual = instance;
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public void test_getRequiredBundles() {
        Object[] expected = EMPTY_OBJECT_ARRAY;
        Bundle bundle = this.getBundle();
        String[] actual = UTILITY.getRequireBundles(bundle);
        Assert.assertEquals((int)expected.length, (int)actual.length);
    }

    public void test_getServiceComponents() {
        Bundle bundle = this.getBundle();
        String[] actual = UTILITY.getServiceComponents(bundle);
        Assert.assertTrue((actual.length == 0 ? 1 : 0) != 0);
    }

    public void test_getUnlocalizedHeader() {
        String expected = "%bundle.name";
        Bundle bundle = this.getBundle();
        String actual = UTILITY.getUnlocalizedHeader(bundle, "Bundle-Name");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private class AbstractBundle
    implements Bundle {
        private AbstractBundle() {
        }

        public Enumeration findEntries(String path, String filePattern, boolean recurse) {
            return null;
        }

        public BundleContext getBundleContext() {
            return null;
        }

        public long getBundleId() {
            return Long.MAX_VALUE;
        }

        public URL getEntry(String path) {
            return null;
        }

        public Enumeration getEntryPaths(String path) {
            return null;
        }

        public Dictionary getHeaders() {
            Hashtable<String, String> headers = new Hashtable<String, String>(17);
            ((Dictionary)headers).put("Manifest-Version", "1.0");
            ((Dictionary)headers).put("Bundle-ManifestVersion", "2");
            ((Dictionary)headers).put("Bundle-SymbolicName", "org.dummy.foo");
            return headers;
        }

        public Dictionary getHeaders(String locale) {
            return this.getHeaders();
        }

        public long getLastModified() {
            return 0L;
        }

        public String getLocation() {
            return null;
        }

        public ServiceReference[] getRegisteredServices() {
            return null;
        }

        public URL getResource(String name) {
            return null;
        }

        public Enumeration getResources(String name) throws IOException {
            return null;
        }

        public ServiceReference[] getServicesInUse() {
            return null;
        }

        public int getState() {
            return 32;
        }

        public String getSymbolicName() {
            Dictionary headers = this.getHeaders();
            String value = (String)headers.get("Bundle-SymbolicName");
            return value;
        }

        public boolean hasPermission(Object permission) {
            return true;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return null;
        }

        public void start() throws BundleException {
        }

        public void start(int options) throws BundleException {
            this.start();
        }

        public void stop() throws BundleException {
        }

        public void stop(int options) throws BundleException {
            this.stop();
        }

        public void uninstall() throws BundleException {
        }

        public void update() throws BundleException {
        }

        public void update(InputStream in) throws BundleException {
        }
    }
}

