/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.IDependencyTracker;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;

public class DependencyTrackerTestCase
extends AbstractSatTestCase {
    private static final String JOHN = "John";
    private static final String JANE = "Jane";
    private static final String FRED = "Fred";
    private static final String FREDA = "Freda";
    private static final String PETER = "Peter";
    private static final String TOM = "Tom";
    private static final String BILL = "Bill";
    private static final String MATTHEW = "Matthew";
    private static final String PHILIP = "Philip";
    private IDependencyTracker tracker;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.DependencyTrackerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public DependencyTrackerTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.tracker = AbstractSatTestCase.FACTORY.createDependencyTracker(51, 51);
        Assert.assertNotNull((String)"DependencyTracker is null", (Object)this.tracker);
        this.tracker.add((Object)FRED, (Object)JOHN);
        this.tracker.add((Object)FRED, (Object)JANE);
        this.tracker.add((Object)FREDA, (Object)JOHN);
        this.tracker.add((Object)FREDA, (Object)JANE);
        this.tracker.add((Object)PETER, (Object)FREDA);
        this.tracker.add((Object)PETER, (Object)TOM);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tracker = null;
    }

    public void test_add() {
        List entries = this.tracker.getPrerequisites((Object)FRED);
        boolean valid = entries.size() == 2 && entries.contains(JOHN) && entries.contains(JANE);
        Assert.assertTrue((boolean)valid);
        entries = this.tracker.getPrerequisites((Object)FREDA);
        valid = entries.size() == 2 && entries.contains(JOHN) && entries.contains(JANE);
        Assert.assertTrue((boolean)valid);
        entries = this.tracker.getPrerequisites((Object)PETER);
        valid = entries.size() == 2 && entries.contains(FREDA) && entries.contains(TOM);
        Assert.assertTrue((boolean)valid);
        entries = this.tracker.getDependents((Object)JOHN);
        valid = entries.size() == 2 && entries.contains(FREDA) && entries.contains(FRED);
        Assert.assertTrue((boolean)valid);
        entries = this.tracker.getDependents((Object)JANE);
        valid = entries.size() == 2 && entries.contains(FREDA) && entries.contains(FRED);
        Assert.assertTrue((boolean)valid);
        entries = this.tracker.getDependents((Object)FREDA);
        valid = entries.size() == 1 && entries.contains(PETER);
        Assert.assertTrue((boolean)valid);
        entries = this.tracker.getDependents((Object)TOM);
        valid = entries.size() == 1 && entries.contains(PETER);
        Assert.assertTrue((boolean)valid);
    }

    public void test_getAllDependents() {
        List results = this.tracker.getAllDependents((Object)JOHN);
        boolean valid = results.size() == 3 && results.contains(FRED) && results.contains(FREDA) && results.contains(PETER);
        Assert.assertTrue((String)"All Dependents of John are incorrect", (boolean)valid);
    }

    public void test_getAllPrerequisites() {
        List results = this.tracker.getAllPrerequisites((Object)PETER);
        boolean valid = results.size() == 4 && results.contains(FREDA) && results.contains(TOM) && results.contains(JOHN) && results.contains(JANE);
        Assert.assertTrue((String)"All prerequisites of Peter are incorrect", (boolean)valid);
    }

    public void test_getDependents() {
        List results = this.tracker.getDependents();
        boolean valid = results.size() >= 3 && results.contains(FRED) && results.contains(FREDA) && results.contains(PETER);
        Assert.assertTrue((String)"Dependents are incorrect", (boolean)valid);
    }

    public void test_getDependentsOfEntry() {
        List results = this.tracker.getDependents((Object)JOHN);
        boolean valid = results.size() == 2 && results.contains(FRED) && results.contains(FREDA);
        Assert.assertTrue((String)"Dependents of John are incorrect", (boolean)valid);
    }

    public void test_getPrerequisites() {
        List results = this.tracker.getPrerequisites();
        boolean valid = results.size() >= 4 && results.contains(JOHN) && results.contains(JANE) && results.contains(FREDA) && results.contains(TOM);
        Assert.assertTrue((String)"Prerequisites are incorrect", (boolean)valid);
    }

    public void test_getPrerequisitesOfEntry() {
        List results = this.tracker.getPrerequisites((Object)PETER);
        boolean valid = results.size() == 2 && results.contains(FREDA) && results.contains(TOM);
        Assert.assertTrue((String)"Prerequisites of Peter are incorrect", (boolean)valid);
    }

    public void test_getValues() {
        List results = this.tracker.getValues();
        boolean valid = results.size() == 6 && results.contains(JOHN) && results.contains(JANE) && results.contains(FRED) && results.contains(FREDA) && results.contains(PETER) && results.contains(TOM);
        Assert.assertTrue((String)"Incorrect values", (boolean)valid);
    }

    public void test_hasCircularReference() {
        boolean valid = !this.tracker.hasCircularReferences((Object)JOHN) && !this.tracker.hasCircularReferences((Object)JANE) && !this.tracker.hasCircularReferences((Object)FRED) && !this.tracker.hasCircularReferences((Object)FREDA) && !this.tracker.hasCircularReferences((Object)PETER) && !this.tracker.hasCircularReferences((Object)TOM);
        Assert.assertTrue((String)"Circular reference incorrectly detected", (boolean)valid);
        this.tracker.add((Object)BILL, (Object)MATTHEW);
        this.tracker.add((Object)MATTHEW, (Object)PHILIP);
        this.tracker.add((Object)PHILIP, (Object)BILL);
        valid = this.tracker.hasCircularReferences((Object)BILL) && this.tracker.hasCircularReferences((Object)MATTHEW) && this.tracker.hasCircularReferences((Object)PHILIP);
        Assert.assertTrue((String)"Circular reference not detected", (boolean)valid);
    }

    public void test_hasDependents() {
        boolean result = this.tracker.hasDependents();
        Assert.assertTrue((String)"Dependents not detected", (boolean)result);
        this.tracker.removeAll();
        result = this.tracker.hasDependents();
        Assert.assertFalse((String)"Dependents incorrectly detected", (boolean)result);
    }

    public void test_hasPrerequisites() {
        boolean result = this.tracker.hasPrerequisites();
        Assert.assertTrue((String)"Prerequisites not detected", (boolean)result);
        this.tracker.removeAll();
        result = this.tracker.hasPrerequisites();
        Assert.assertFalse((String)"Prerequisites incorrectly detected", (boolean)result);
    }

    public void test_isEmpty() {
        boolean result = this.tracker.isEmpty();
        Assert.assertFalse((String)"Incorrectly considered empty", (boolean)result);
        this.tracker.removeAll();
        result = this.tracker.isEmpty();
        Assert.assertTrue((String)"Incorrectly considered not empty", (boolean)result);
    }

    public void test_remove() {
        this.tracker.remove((Object)FREDA);
        List results = this.tracker.getDependents((Object)JOHN);
        boolean valid = results.size() == 1 && results.contains(FRED);
        Assert.assertTrue((boolean)valid);
        results = this.tracker.getDependents((Object)JANE);
        valid = results.size() == 1 && results.contains(FRED);
        Assert.assertTrue((boolean)valid);
        results = this.tracker.getPrerequisites((Object)PETER);
        valid = results.size() == 1 && results.contains(TOM);
        Assert.assertTrue((boolean)valid);
    }

    public void test_removeAll() {
        int size = this.tracker.size();
        boolean valid = size > 0;
        Assert.assertTrue((boolean)valid);
        this.tracker.removeAll();
        size = this.tracker.size();
        valid = size == 0;
        Assert.assertTrue((boolean)valid);
    }

    public void test_removeDependent() {
        this.tracker.removeDependent((Object)FRED);
        List list = this.tracker.getDependents();
        boolean result = list.contains(FRED);
        Assert.assertFalse((String)"Dependent not removed", (boolean)result);
    }

    public void test_removePrerequisite() {
        this.tracker.removeDependent((Object)JOHN);
        List list = this.tracker.getDependents();
        boolean result = list.contains(JOHN);
        Assert.assertFalse((String)"Prerequisite not removed", (boolean)result);
    }

    public void test_removeRelationship() {
        List results = this.tracker.getPrerequisites((Object)FRED);
        boolean valid = results.size() == 2 && results.contains(JANE) && results.contains(JOHN);
        Assert.assertTrue((boolean)valid);
        this.tracker.remove((Object)FRED, (Object)JOHN);
        results = this.tracker.getPrerequisites((Object)FRED);
        valid = results.size() == 1 && results.contains(JANE);
        Assert.assertTrue((boolean)valid);
    }

    public void test_removeWithAllPrerequisites() {
        List results = this.tracker.removeWithAllPrerequisites((Object)PETER);
        boolean valid = results.size() == 2 && results.contains(FREDA) && results.contains(TOM);
        Assert.assertTrue((String)"Removed all prerequisites of Peter are incorrect", (boolean)valid);
        this.tracker.add((Object)FREDA, (Object)JOHN);
        this.tracker.add((Object)FREDA, (Object)JANE);
        this.tracker.add((Object)PETER, (Object)FREDA);
        this.tracker.add((Object)PETER, (Object)TOM);
        this.tracker.remove((Object)FRED);
        results = this.tracker.removeWithAllPrerequisites((Object)PETER);
        valid = results.size() == 4 && results.contains(FREDA) && results.contains(TOM) && results.contains(JOHN) && results.contains(JANE);
        Assert.assertTrue((String)"Removed all prerequisites of Peter are incorrect", (boolean)valid);
    }

    public void test_removeWithPrerequisites() {
        this.tracker.remove((Object)FRED);
        List results = this.tracker.removeWithPrerequisites((Object)PETER);
        boolean valid = results.size() == 2 && results.contains(FREDA) && results.contains(TOM);
        Assert.assertTrue((String)"Removed prerequisites of Peter are incorrect", (boolean)valid);
    }

    public void test_size() {
        int size = this.tracker.size();
        Assert.assertEquals((String)"Incorrect size", (int)6, (int)size);
        this.tracker.removeAll();
        size = this.tracker.size();
        Assert.assertEquals((String)"Incorrect size", (int)0, (int)size);
    }
}

