/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.profile.factory;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.core.factory.CoreFactory;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.osgi.service.cm.ManagedServiceFactory;

public abstract class ProfileFactory
extends CoreFactory
implements ManagedServiceFactory,
IManagedServiceFactoryAdvisor {
    public static final String[] IMPORTED_SERVICES = new String[]{"org.eclipse.soda.dk.notification.service.NotificationService"};
    public static final String[] OPTIONAL_SERVICE = new String[]{METATYPE_SERVICE};

    protected ProfileFactory() {
    }

    public synchronized Object create(String pid, Dictionary properties, IBundleActivationManager manager) {
        this.validateConfigurationIds(pid, properties);
        ProfileService profile = this.createService(manager);
        if (profile != null) {
            if (profile instanceof Profile) {
                ((Device)profile).setBundleContext(this.getBundleContext());
            }
            profile.setConfigurationInformation(properties);
            NotificationService notificationService = (NotificationService)manager.getImportedService("org.eclipse.soda.dk.notification.service.NotificationService");
            profile.setNotificationService(notificationService);
            try {
                profile.start();
            }
            catch (RuntimeException exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            Hashtable serviceProperties = this.createProperties();
            this.updateProperties(serviceProperties, properties);
            manager.addExportedServices(this.getExportedServiceNames(pid, null, properties, manager), (Object)profile, (Dictionary)serviceProperties);
        }
        return profile;
    }

    public void createImportedServiceFilters(String pid, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        super.createImportedServiceFilters(pid, oldProperties, properties, manager);
        String adapterServiceName = this.getAdapterServiceName();
        if (adapterServiceName != null && adapterServiceName.length() > 0) {
            Object idFilter = properties.get("idimportfilter");
            String idFilterString = String.valueOf(idFilter);
            if (idFilter != null && idFilterString.length() > 0) {
                manager.addImportedServiceFilter(adapterServiceName, idFilterString);
            } else {
                String id = String.valueOf(properties.get("id"));
                String idString = String.valueOf(id);
                if (id != null && idString.length() > 0) {
                    StringBuffer buffer = new StringBuffer("(id=");
                    buffer.append(idString);
                    buffer.append(')');
                    String filter = buffer.toString();
                    manager.addImportedServiceFilter(adapterServiceName, filter);
                }
            }
        }
    }

    public ProfileService createService(DeviceService device) {
        return null;
    }

    public ProfileService createService(IBundleActivationManager manager) {
        String interestServiceName = this.getInterestServiceName();
        if (interestServiceName != null && interestServiceName.length() > 0) {
            DeviceService device = (DeviceService)manager.getImportedService(interestServiceName);
            ProfileService profile = this.createService(device);
            return profile;
        }
        ProfileService profile = this.createService((DeviceService)null);
        return profile;
    }

    public synchronized void destroy(String pid, Object object, Dictionary properties, IBundleActivationManager manager) {
        try {
            ProfileService profile = (ProfileService)object;
            profile.exit();
            int count = 0;
            while (count < 20 && profile.getState() != 0) {
                Thread.sleep(100L);
                ++count;
            }
        }
        catch (Exception exception) {
            EscObject.handleStaticException((Throwable)exception);
        }
        super.destroy(pid, object, properties, manager);
    }

    public String getAdapterServiceName() {
        return "";
    }

    public String getDeviceServiceName() {
        return "";
    }

    public String[] getImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager manager) {
        return IMPORTED_SERVICES;
    }

    public String getInterestServiceName() {
        return this.getDeviceServiceName();
    }

    public String[] getOptionalImportedServiceNames(String arg0, Dictionary arg1, Dictionary arg2, IBundleActivationManager arg3) {
        return BaseBundleActivator.NO_SERVICES;
    }

    public String getServiceName() {
        return DeviceService.SERVICE_NAME;
    }

    public String[] getServiceNames() {
        return new String[]{this.getServiceName()};
    }

    public synchronized Object update(String pid, Object object, Dictionary oldProperties, Dictionary properties, IBundleActivationManager manager) {
        ProfileService profile = (ProfileService)object;
        int compareLevel = this.compare(oldProperties, properties, this.getMinorProperties());
        switch (compareLevel) {
            case 0: {
                return object;
            }
            case 1: {
                profile.setConfigurationInformation(properties);
                return object;
            }
            case 2: {
                try {
                    manager.removeExportedService(this.getServiceName(), object);
                    Thread.yield();
                    profile.exit();
                }
                catch (RuntimeException e) {
                    EscObject.handleStaticException((Throwable)e);
                }
                return this.create(pid, properties, manager);
            }
        }
        return object;
    }
}

