/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.notification;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.notification.NotificationBase;
import org.eclipse.soda.dk.notification.NotificationListeners;
import org.eclipse.soda.dk.notification.NotificationQueue;
import org.eclipse.soda.dk.notification.service.NotificationExtendableService;
import org.eclipse.soda.dk.notification.service.NotificationExtensionService;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationMonitorService;
import org.eclipse.soda.dk.notification.service.NotificationService;

public class Notification
extends NotificationBase
implements NotificationExtendableService,
Runnable {
    protected static NotificationService Broker = null;
    protected boolean synchronize = false;
    protected Hashtable topicListeners = new Hashtable(1023);
    protected Hashtable beginTopicListeners = null;
    protected Hashtable endTopicListeners = null;
    protected NotificationListener globalTopicListeners = null;
    protected NotificationQueue queue = new NotificationQueue(128);
    private boolean running = false;
    protected Thread thread = null;

    public Notification() {
    }

    public Notification(boolean synchronize) {
        this.setSynchronize(synchronize);
    }

    public static void addData(String key, Dictionary value, int level) {
        if (value != null) {
            Number timestampObject = null;
            if (level > 0 && value.get("timestamp") == null) {
                timestampObject = (Number)EscObject.getCurrentTimestamp();
                value.put("timestamp", timestampObject);
            }
            if (level >= 6) {
                long timestamp;
                long notificationId;
                if (timestampObject == null) {
                    timestampObject = (Number)EscObject.getCurrentTimestamp();
                }
                NotificationId = (notificationId = (timestamp = timestampObject.longValue()) * 1000L) > NotificationId ? notificationId : ++NotificationId;
                if (value.get("notification.timestamp") == null) {
                    value.put("notification.timestamp", timestampObject);
                }
                Number id = Notification.createNumber((long)NotificationId);
                if (value.get("id") == null) {
                    value.put("id", id);
                }
                if (value.get("notification.id") == null) {
                    value.put("notification.id", id);
                }
            }
            if (level >= 9 && value.get("notification.host") == null) {
                value.put("notification.host", NotificationHost);
            }
        }
    }

    public static NotificationService createBroker() {
        return Notification.createBroker(false);
    }

    public static NotificationService createBroker(boolean synchronize) {
        Notification broker = new Notification(synchronize);
        broker.setup();
        broker.start();
        return broker;
    }

    public static NotificationService getBroker() {
        return Notification.getBroker(false);
    }

    public static NotificationService getBroker(boolean synchronize) {
        if (Broker == null) {
            Broker = Notification.createBroker();
        }
        return Broker;
    }

    public static String getExternalKey(String prefix, String key) {
        if (prefix == null) {
            return key;
        }
        int plength = prefix.length();
        if (plength == 0) {
            return key;
        }
        int klength = key.length();
        StringBuffer buffer = new StringBuffer(plength + 1 + klength);
        buffer.append(prefix);
        buffer.append('/');
        buffer.append(key);
        return buffer.toString().intern();
    }

    public static String[] getExternalKeys(String prefix, String[] keys) {
        if (prefix == null) {
            return keys;
        }
        int plength = prefix.length();
        if (plength == 0) {
            return keys;
        }
        int size = keys.length;
        if (size == 0) {
            return keys;
        }
        StringBuffer buffer = new StringBuffer(plength + 1 + 128);
        buffer.append(prefix);
        buffer.append('/');
        String[] newKeys = new String[size];
        int i = 0;
        while (i < size) {
            String key = keys[i];
            buffer.append(key);
            newKeys[i] = buffer.toString().intern();
            buffer.delete(plength + 1, buffer.length());
            ++i;
        }
        return newKeys;
    }

    public void broadcast(String key, Dictionary value) {
        ++this.broadcastCount;
        int level = this.getLevel();
        NotificationExtensionService notificationExtensionService = this.getNotificationExtension();
        if (level >= 2) {
            int send = 0;
            if (notificationExtensionService != null) {
                send = notificationExtensionService.sending(key, value);
            }
            if (send == 0) {
                NotificationMonitorService notificationMonitor = this.getNotificationMonitor();
                if (level >= 4 && notificationMonitor != null) {
                    long start = System.currentTimeMillis();
                    if (this.isSynchronize()) {
                        this.dispatch(key, value);
                    } else {
                        this.getInformationBroker().broadcast(key, value);
                    }
                    long end = System.currentTimeMillis();
                    long delta = end - start;
                    this.updateBroadcastTotalTime(delta);
                    notificationMonitor.sent(key, value, delta);
                } else {
                    this.getInformationBroker().broadcast(key, value);
                }
            }
        } else {
            this.getInformationBroker().broadcast(key, value);
        }
    }

    public void dispatch(String topic, Dictionary data) {
        NotificationExtensionService notificationExtensionService;
        int receive = 0;
        if (this.level >= 2 && (notificationExtensionService = this.getNotificationExtension()) != null) {
            receive = notificationExtensionService.receiving(topic, data);
        }
        if (receive == 0) {
            String subTopic;
            int index;
            Object listener = this.topicListeners.get(topic);
            if (listener instanceof NotificationListener) {
                if (this.level > 0) {
                    this.notify((NotificationListener)listener, topic, data);
                } else {
                    ((NotificationListener)listener).notificationReceived(topic, data);
                }
            }
            if (this.globalTopicListeners != null) {
                if (this.level > 0) {
                    this.notify(this.globalTopicListeners, topic, data);
                } else {
                    this.globalTopicListeners.notificationReceived(topic, data);
                }
            }
            if (this.beginTopicListeners != null) {
                index = 0;
                while (index >= 0) {
                    subTopic = topic.substring(index);
                    Object beginListener = this.beginTopicListeners.get(subTopic);
                    if (beginListener instanceof NotificationListener) {
                        if (this.level > 0) {
                            this.notify((NotificationListener)beginListener, topic, data);
                        } else {
                            ((NotificationListener)beginListener).notificationReceived(topic, data);
                        }
                    }
                    if ((index = topic.indexOf(47, index + 1)) < 0) continue;
                    ++index;
                }
            }
            if (this.endTopicListeners != null) {
                index = topic.length();
                while (index >= 0) {
                    subTopic = topic.substring(0, index);
                    Object endListener = this.endTopicListeners.get(subTopic);
                    if (endListener instanceof NotificationListener) {
                        if (this.level > 0) {
                            this.notify((NotificationListener)endListener, topic, data);
                        } else {
                            ((NotificationListener)endListener).notificationReceived(topic, data);
                        }
                    }
                    index = subTopic.lastIndexOf(47);
                }
            }
        }
    }

    public void exit() {
        this.stop();
        Broker = null;
    }

    public NotificationQueue getInformationBroker() {
        return this.queue;
    }

    public boolean isSynchronize() {
        return this.synchronize;
    }

    public void notify(NotificationListener notificationListener, String topic, Dictionary data) {
        int level = this.getLevel();
        ++this.notifyCount;
        NotificationMonitorService notificationMonitor = this.getNotificationMonitor();
        if (level >= 4 && notificationMonitor != null) {
            long startTime = System.currentTimeMillis();
            notificationListener.notificationReceived(topic, data);
            long endTime = System.currentTimeMillis();
            long delta = endTime - startTime;
            this.updateNotifyTotalTime(delta);
            notificationMonitor.notified(notificationListener, topic, data, delta);
        } else {
            notificationListener.notificationReceived(topic, data);
        }
    }

    public void register(String subscription, NotificationListener listener) {
        this.register(subscription, listener, 1);
    }

    public void register(String subscription, NotificationListener listener, int count) {
        if ("*".equals(subscription) || "#".equals(subscription)) {
            this.globalTopicListeners = NotificationListeners.add(this.globalTopicListeners, listener);
        } else if (subscription.startsWith("*") || subscription.startsWith("#")) {
            if (this.beginTopicListeners == null) {
                this.beginTopicListeners = new Hashtable((count << 2) - 1);
            }
            this.beginTopicListeners.put(subscription.substring(2), NotificationListeners.add((NotificationListener)this.beginTopicListeners.get(subscription), listener));
        } else if (subscription.endsWith("*") || subscription.endsWith("#")) {
            if (this.endTopicListeners == null) {
                this.endTopicListeners = new Hashtable((count << 2) - 1);
            }
            this.endTopicListeners.put(subscription.substring(0, subscription.length() - 2), NotificationListeners.add((NotificationListener)this.endTopicListeners.get(subscription), listener));
        } else {
            if (this.topicListeners == null) {
                this.topicListeners = new Hashtable((count << 2) - 1);
            }
            this.topicListeners.put(subscription, NotificationListeners.add((NotificationListener)this.topicListeners.get(subscription), listener));
        }
    }

    public void register(String[] subscriptions, NotificationListener listener) {
        int length = subscriptions.length;
        int i = 0;
        while (i < subscriptions.length) {
            this.register(subscriptions[i], listener, length);
            ++i;
        }
    }

    public void run() {
        int idleCount = 0;
        this.handleError(null, 100);
        Object[] information = new Object[2];
        while (this.running) {
            long delay = 10000L;
            this.queue.dequeue(delay, information);
            if (!this.running) continue;
            if (information[0] != null) {
                String topic = (String)information[0];
                Dictionary data = (Dictionary)information[1];
                this.dispatch(topic, data);
                idleCount = 0;
                continue;
            }
            if ((++idleCount & 0xFF) == 255) {
                System.gc();
                System.gc();
            }
            long l = 1000L;
        }
        this.handleError(null, 101);
    }

    public void setSynchronize(boolean synchronize) {
        this.synchronize = synchronize;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "InformationBrokerService");
            this.thread.setDaemon(true);
            this.thread.setPriority(6);
            this.running = true;
            this.thread.start();
        }
    }

    public void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException exception) {
                exception.printStackTrace();
            }
        }
        this.thread = null;
    }

    public void unregister(NotificationListener listener) {
        NotificationListener listenersNew;
        NotificationListener listeners;
        Object value;
        Map.Entry entry;
        int i;
        Map.Entry[] entries;
        int size;
        Set beginTopicSet;
        this.globalTopicListeners = NotificationListeners.remove(this.globalTopicListeners, listener);
        if (this.topicListeners != null) {
            beginTopicSet = this.topicListeners.entrySet();
            size = beginTopicSet.size();
            entries = new Map.Entry[size];
            entries = beginTopicSet.toArray(entries);
            i = 0;
            while (i < size) {
                entry = entries[i];
                value = entry.getValue();
                if (value == listener) {
                    this.topicListeners.remove(entry.getKey());
                } else if (value instanceof NotificationListener) {
                    listeners = (NotificationListener)value;
                    listenersNew = NotificationListeners.remove(listeners, listener);
                    entry.setValue(listenersNew);
                }
                ++i;
            }
        }
        if (this.beginTopicListeners != null) {
            beginTopicSet = this.beginTopicListeners.entrySet();
            size = beginTopicSet.size();
            entries = new Map.Entry[size];
            entries = beginTopicSet.toArray(entries);
            i = 0;
            while (i < size) {
                entry = entries[i];
                value = entry.getValue();
                if (value == listener) {
                    this.beginTopicListeners.remove(entry.getKey());
                } else if (value instanceof NotificationListener) {
                    listeners = (NotificationListener)value;
                    listenersNew = NotificationListeners.remove(listeners, listener);
                    entry.setValue(listenersNew);
                }
                ++i;
            }
            if (this.beginTopicListeners.size() == 0) {
                this.beginTopicListeners = null;
            }
        }
        if (this.endTopicListeners != null) {
            Set endTopicSet = this.endTopicListeners.entrySet();
            size = endTopicSet.size();
            entries = new Map.Entry[size];
            entries = endTopicSet.toArray(entries);
            i = 0;
            while (i < size) {
                entry = entries[i];
                value = entry.getValue();
                if (value == listener) {
                    this.endTopicListeners.remove(entry.getKey());
                } else if (value instanceof NotificationListener) {
                    listeners = (NotificationListener)value;
                    listenersNew = NotificationListeners.remove(listeners, listener);
                    entry.setValue(listenersNew);
                }
                ++i;
            }
            if (this.endTopicListeners.size() == 0) {
                this.endTopicListeners = null;
            }
        }
    }
}

