/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.generic.gpio.profile;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.generic.adapter.service.GenericGpioListener;
import org.eclipse.soda.dk.generic.adapter.service.GenericGpioListenerService;
import org.eclipse.soda.dk.generic.adapter.service.GenericGpioService;
import org.eclipse.soda.dk.gpio.profile.GpioProfile;
import org.eclipse.soda.dk.gpio.profile.service.GpioProfileService;

public abstract class GenericGpioProfile
extends GpioProfile {
    private GenericGpioListener gpioListener = new GenericGpioListener(){

        public void receiveInputEvent(int inputPin, boolean state) {
            GenericGpioProfile.this.handleInputEvent(inputPin, state);
        }
    };

    protected GenericGpioProfile() {
    }

    protected GenericGpioProfile(String capabilities, String status, String configuration, String metrics) {
    }

    public void activate() {
        super.activate();
        GenericGpioListenerService adapter = (GenericGpioListenerService)((Object)this.getGenericGpioService());
        adapter.setGpioListener(this.gpioListener);
    }

    public void deactivate() {
        super.deactivate();
        GenericGpioListenerService adapter = (GenericGpioListenerService)((Object)this.getGenericGpioService());
        adapter.setGpioListener(null);
    }

    protected GenericGpioService getGenericGpioService() {
        AdapterService adapter = this.getAdapter();
        if (adapter != null && adapter instanceof GenericGpioService) {
            return (GenericGpioService)adapter;
        }
        return null;
    }

    private Map getNewInputMap() {
        Map oldInputMap = (Map)this.input.getValue();
        Hashtable newInputMap = new Hashtable(32);
        if (oldInputMap != null) {
            newInputMap.putAll(oldInputMap);
        }
        return newInputMap;
    }

    protected void handleInputEvent(int inputPin, boolean state) {
        Map newInputMap = this.getNewInputMap();
        newInputMap.put(GpioProfileService.INPUT_NAMES[inputPin], state ? Boolean.TRUE : Boolean.FALSE);
        this.input.setValue((Object)newInputMap, GenericGpioProfile.getCurrentTimestamp());
    }

    protected void turnOffAllOutputs() {
        Hashtable<String, Boolean> outputs = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= this.getOutputCountValue()) {
            outputs.put(GpioProfileService.OUTPUT_NAMES[i], Boolean.FALSE);
            ++i;
        }
        this.updateOutputs(outputs, null);
    }

    protected void turnOnAllOutputs() {
        Hashtable<String, Boolean> outputs = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= this.getOutputCountValue()) {
            outputs.put(GpioProfileService.OUTPUT_NAMES[i], Boolean.TRUE);
            ++i;
        }
        this.updateOutputs(outputs, null);
    }

    protected void updateOutputs(Map fullState, Map individualRequest) {
        GenericGpioService adapter = this.getGenericGpioService();
        if (adapter != null) {
            adapter.updateOutputs(fullState);
        }
    }
}

