/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.measurement.SignalMeasurement;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.units.service.UnitsService;

public class ReadMeasurement
extends SignalMeasurement {
    protected CommandService readCommand;

    public ReadMeasurement(String key, Object value, UnitsService units, TransformService transform, SignalService signal, CommandService readCommand) {
        super(key, value, units, transform, signal);
        this.setReadCommand(readCommand);
    }

    public ReadMeasurement(String key, UnitsService units, TransformService transform, SignalService signal) {
        super(key, units, transform, signal);
    }

    public ReadMeasurement(String key, TransformService transform, SignalService signal) {
        super(key, transform, signal);
    }

    public ReadMeasurement(String key, SignalService signal) {
        super(key, signal);
    }

    public void executeRead(ChannelService channel) {
        CommandService readCommand = this.getReadCommand();
        if (readCommand != null) {
            readCommand.execute(channel);
        } else {
            super.executeRead(channel);
        }
    }

    public CommandService getReadCommand() {
        return this.readCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(ChannelService channel, long timeout) throws RuntimeException {
        if (this.getReadCommand() != null) {
            ReadMeasurement lock;
            ReadMeasurement readMeasurement = lock = channel == null ? this : channel;
            synchronized (readMeasurement) {
                Object currentStamp = this.getTimestamp(channel);
                this.sleep(1L);
                this.executeRead(channel);
                try {
                    ((Object)((Object)this)).wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
                if (currentStamp == this.getTimestamp(channel)) {
                    throw new RuntimeException(this.format(3019, (Object)this));
                }
            }
            return this.getValue(channel);
        }
        return super.read(channel, timeout);
    }

    public void setReadCommand(CommandService readCommand) {
        this.readCommand = readCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(ChannelService channel, Object timestamp) {
        super.setTimestamp(channel, timestamp);
        ReadMeasurement readMeasurement = this;
        synchronized (readMeasurement) {
            ((Object)((Object)this)).notifyAll();
        }
    }
}

